/*
 * Copyright (C) 1993-2008 the Wine project authors (see the file AUTHORS (in the
 * wine project) for a complete list).
 *
 * See the file LICENSE-wine for the license (GPL) details.
 */
#ifndef CPUDETECT_H
#define CPUDETECT_H

#define CPUTYPE_I386	3
#define CPUTYPE_I486	4
#define CPUTYPE_I586	5
#define CPUTYPE_I686    6

typedef struct cpucaps_s {
	int cpuType;
	int cpuStepping;
	int hasMMX;
	int hasMMX2;
	int has3DNow;
	int has3DNowExt;
	int hasSSE;
	int hasSSE2;
	int isX86;
	unsigned cl_size; /* size of cache line */
        int hasAltiVec;
} CpuCaps;

extern CpuCaps gCpuCaps;

void GetCpuCaps(CpuCaps *caps);

/* returned value is malloc()'ed so free() it after use */
char *GetCpuFriendlyName(unsigned int regs[], unsigned int regs2[]);

#endif /* !CPUDETECT_H */

