/*****************************************************************************
 * sound_plugin.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007, Gregory D Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#ifndef _SOUND_PLUGIN_H_
#define _SOUND_PLUGIN_H_

typedef enum {
	GY_SAMPLE_U8 = 0,	/* Unsigned 8 Bit PCM.	*/
	GY_SAMPLE_ALAW, 	/* 8 Bit a-Law		*/
	GY_SAMPLE_ULAW, 	/* 8 Bit mu-Law		*/
	GY_SAMPLE_S16LE, 	/* Signed 16 Bit PCM, little endian (PC).	*/
	GY_SAMPLE_S16BE, 	/* Signed 16 Bit PCM, big endian.		*/
	GY_SAMPLE_FLOAT32LE, 	/* 32 Bit IEEE floating point, little endian, range -1 to 1	*/
	GY_SAMPLE_FLOAT32BE, 	/* 32 Bit IEEE floating point, big endian, range -1 to 1	*/
	GY_SAMPLE_S32LE, 	/* Signed 32 Bit PCM, little endian (PC).	*/
	GY_SAMPLE_S32BE, 	/* Signed 32 Bit PCM, big endian (PC).		*/
	GY_SAMPLE_MAX 		/* Upper limit of valid sample types.		*/
} GYACHI_FORMAT_TYPE;

typedef enum {
	GY_STREAM_PLAYBACK = 0,	/* playback stream	*/
	GY_STREAM_RECORD,	/* record stream	*/
	GY_STREAM_MAX		/* upper limit, on stream type 	*/
} GYACHI_STREAM_TYPE;


typedef struct _gyachi_sound_plugin {
	char *name;
	char *description;
	void *(*open)(GYACHI_STREAM_TYPE stream, GYACHI_FORMAT_TYPE format, int channels, int rate);
	int  (*play)(void *handle, unsigned const char *data, int size, GYACHI_FORMAT_TYPE format);
	int  (*record)(void *handle, unsigned char *data,     int size, GYACHI_FORMAT_TYPE format);
	int  (*drain)(void *handle);
	int  (*close)(void *handle);
} GYACHI_SOUND_PLUGIN;

extern GYACHI_SOUND_PLUGIN *selected_sound_plugin;

extern int register_sound_device(GYACHI_SOUND_PLUGIN *plugin);
extern GList *gyachi_sound_devices_available();
extern void sync_sound_device();
extern int select_sound_device(const char *name);
extern const char *sound_device_description(const char *name);
extern const char *sound_device_name(const char *description);

#endif

