; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s

define amdgpu_ps void @insertelement_s_v2i8_s_s(<2 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_or_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0xff
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_s(<2 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1 )* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_s(<2 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_or_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0xff
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_s_v(<2 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v2, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    v_mov_b32_e32 v3, 0xff
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_v(<2 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_load_ushort v2, v[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v2, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, 0xff
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_v(<2 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v3, s2
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v4, v3, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_s(<2 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_v(<2 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

; FIXME: 3 element load/store legalization
; define amdgpu_ps void @insertelement_s_v3i8_s_s(<3 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_s(<3 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1 )* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_s(<3 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_s_v(<3 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_v(<3 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_v(<3 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_s(<3 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_v(<3 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

define amdgpu_ps void @insertelement_v_v4i8_s_s(<4 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    s_and_b32 s3, s3, 3
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s1
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s3, s1, s3
; GFX9-NEXT:    s_not_b32 s3, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v5, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v5, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v4, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v1
; GFX9-NEXT:    v_or3_b32 v2, v0, v4, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    s_and_b32 s1, s3, 3
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v6, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v3, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    s_and_b32 s1, s3, 3
; GFX7-NEXT:    s_and_b32 s2, s2, s0
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    s_lshl_b32 s2, s2, s1
; GFX7-NEXT:    s_lshl_b32 s1, s0, s1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1 )* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_s(<4 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s1, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s6
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s6
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s6
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s5, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s4, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s3, s6, s2
; GFX9-NEXT:    s_andn2_b32 s1, s1, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, s2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v1, v0, s6, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_or3_b32 v2, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s5, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s1, s0, 8
; GFX8-NEXT:    s_and_b32 s1, s1, s5
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    s_lshr_b32 s3, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s2, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s3, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s4, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b32 s1, s5, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    v_or_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s5, 0xff
; GFX7-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s1, s0, 8
; GFX7-NEXT:    s_and_b32 s1, s1, s5
; GFX7-NEXT:    s_lshr_b32 s2, s0, 16
; GFX7-NEXT:    s_lshr_b32 s3, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s2, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s3, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s4, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_lshl_b32 s1, s5, s1
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    v_or_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_s_v(<4 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s1, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s6
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s6
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s6
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s5, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s4, s6
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v0, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s6
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v0, s1, v0, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v1, v0, s6, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_or3_b32 v2, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s5, 0xff
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s1, s0, 8
; GFX8-NEXT:    s_and_b32 s1, s1, s5
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    s_lshr_b32 s3, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s2, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s3, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s4, s5
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v0, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s5, 0xff
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s1, s0, 8
; GFX7-NEXT:    s_and_b32 s1, s1, s5
; GFX7-NEXT:    s_lshr_b32 s2, s0, 16
; GFX7-NEXT:    s_lshr_b32 s3, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s2, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s3, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s4, s5
; GFX7-NEXT:    v_lshl_b32_e32 v1, s1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_v(<4 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s5, 0xff
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s1, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s5
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshr_b32 s4, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s5
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s5
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s5
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s4, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v0, s1, v1, v0
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v1, v0, s5, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_or3_b32 v2, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s4, 0xff
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s1, s0, 8
; GFX8-NEXT:    s_and_b32 s1, s1, s4
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    s_lshr_b32 s3, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s2, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s4
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s3, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s4, 0xff
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s1, s0, 8
; GFX7-NEXT:    s_and_b32 s1, s1, s4
; GFX7-NEXT:    s_lshr_b32 s2, s0, 16
; GFX7-NEXT:    s_lshr_b32 s3, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s4
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s2, s4
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s3, 24
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s4, v1
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_s_v(<4 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v2, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s1
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v6, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v6, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, v2, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v4, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v1
; GFX9-NEXT:    v_or3_b32 v2, v0, v4, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v2, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX8-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v4, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX7-NEXT:    s_and_b32 s1, s2, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, s1, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v3, s0, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s0, v4
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_s(<4 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s2, s1, s2
; GFX9-NEXT:    s_not_b32 s2, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v5, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v5, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s2, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v4, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v1
; GFX9-NEXT:    v_or3_b32 v2, v0, v4, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v7, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v4, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v2
; GFX7-NEXT:    s_and_b32 s1, s2, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, s1, v1
; GFX7-NEXT:    s_lshl_b32 s1, s0, s1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v3, s0, v3
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_v(<4 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v3, s1
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v7, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v5
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v6
; GFX9-NEXT:    v_and_or_b32 v0, v0, v3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v5, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_or3_b32 v2, v0, v5, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v6, s0
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX8-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX8-NEXT:    v_mov_b32_e32 v5, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v6, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    s_movk_i32 s2, 0xff
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, s2, v3
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s2, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v5, s2, v5
; GFX7-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, v2, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_s(<8 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s10, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s10
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s6, 24
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s7, s10
; GFX9-NEXT:    s_lshr_b32 s8, s1, 16
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s8, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s9, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshr_b32 s2, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, s10
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, s10, s5
; GFX9-NEXT:    s_andn2_b32 s3, s3, s5
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    s_cmp_eq_u32 s2, 0
; GFX9-NEXT:    s_cselect_b32 s0, s3, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s1, s3, s1
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s10
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s4, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s4, 24
; GFX9-NEXT:    s_lshr_b32 s5, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s5, s10
; GFX9-NEXT:    s_lshr_b32 s6, s1, 16
; GFX9-NEXT:    s_lshr_b32 s7, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s6, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s7, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s10, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_and_b32 s2, s2, s10
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s6, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s3, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s6, 24
; GFX8-NEXT:    s_lshr_b32 s7, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s7, s10
; GFX8-NEXT:    s_lshr_b32 s8, s1, 16
; GFX8-NEXT:    s_lshr_b32 s9, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s2, s8, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s9, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshr_b32 s2, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, s10
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, s10, s5
; GFX8-NEXT:    s_andn2_b32 s3, s3, s5
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_cmp_eq_u32 s2, 0
; GFX8-NEXT:    s_cselect_b32 s0, s3, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s1, s3, s1
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_and_b32 s2, s2, s10
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s3, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s4, 24
; GFX8-NEXT:    s_lshr_b32 s5, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s5, s10
; GFX8-NEXT:    s_lshr_b32 s6, s1, 16
; GFX8-NEXT:    s_lshr_b32 s7, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s2, s6, s10
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s7, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s10, 0xff
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s2, s0, 8
; GFX7-NEXT:    s_and_b32 s2, s2, s10
; GFX7-NEXT:    s_lshr_b32 s3, s0, 16
; GFX7-NEXT:    s_lshr_b32 s6, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s10
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s3, s10
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_lshl_b32 s2, s6, 24
; GFX7-NEXT:    s_lshr_b32 s7, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s7, s10
; GFX7-NEXT:    s_lshr_b32 s8, s1, 16
; GFX7-NEXT:    s_lshr_b32 s9, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s10
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_and_b32 s2, s8, s10
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshl_b32 s2, s9, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, s10
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, s10, s5
; GFX7-NEXT:    s_andn2_b32 s3, s3, s5
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    s_cmp_eq_u32 s2, 0
; GFX7-NEXT:    s_cselect_b32 s4, s3, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s3, s1
; GFX7-NEXT:    s_lshr_b32 s2, s4, 8
; GFX7-NEXT:    s_and_b32 s2, s2, s10
; GFX7-NEXT:    s_lshr_b32 s5, s4, 16
; GFX7-NEXT:    s_lshr_b32 s6, s4, 24
; GFX7-NEXT:    s_and_b32 s4, s4, s10
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s2, s4, s2
; GFX7-NEXT:    s_and_b32 s4, s5, s10
; GFX7-NEXT:    s_lshl_b32 s4, s4, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s4
; GFX7-NEXT:    s_lshl_b32 s4, s6, 24
; GFX7-NEXT:    s_lshr_b32 s7, s3, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s4
; GFX7-NEXT:    s_and_b32 s4, s7, s10
; GFX7-NEXT:    s_lshr_b32 s8, s3, 16
; GFX7-NEXT:    s_lshr_b32 s9, s3, 24
; GFX7-NEXT:    s_and_b32 s3, s3, s10
; GFX7-NEXT:    s_lshl_b32 s4, s4, 8
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    s_and_b32 s4, s8, s10
; GFX7-NEXT:    s_lshl_b32 s4, s4, 16
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    s_lshl_b32 s4, s9, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_s(<8 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    s_lshr_b32 s1, s3, 2
; GFX9-NEXT:    s_and_b32 s3, s3, 3
; GFX9-NEXT:    s_and_b32 s2, s2, s4
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s3, s4, s3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX9-NEXT:    s_not_b32 s3, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v8, v0, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v9, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, s4, v6
; GFX9-NEXT:    v_or3_b32 v0, v0, v8, v5
; GFX9-NEXT:    v_or3_b32 v1, v1, v9, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v3, v4, s3, v3
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v7, v0, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v8, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v3
; GFX9-NEXT:    v_and_or_b32 v1, v1, s4, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v4
; GFX9-NEXT:    v_or3_b32 v1, v1, v8, v5
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    s_lshr_b32 s1, s3, 2
; GFX8-NEXT:    s_and_b32 s3, s3, 3
; GFX8-NEXT:    s_lshl_b32 s3, s3, 3
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s3
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v9, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v10, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX8-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v4, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s6, 0xff
; GFX7-NEXT:    s_and_b32 s1, s3, 3
; GFX7-NEXT:    s_lshr_b32 s0, s3, 2
; GFX7-NEXT:    s_and_b32 s2, s2, s6
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    s_lshl_b32 s2, s2, s1
; GFX7-NEXT:    s_lshl_b32 s1, s6, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, s1, v2
; GFX7-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1 )* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_s(<8 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s10, 0xff
; GFX9-NEXT:    v_and_b32_e32 v0, s10, v0
; GFX9-NEXT:    s_mov_b32 s5, 8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s10
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s6, 24
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s7, s10
; GFX9-NEXT:    s_lshr_b32 s8, s1, 16
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s8, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s9, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshr_b32 s2, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s6, s10, s4
; GFX9-NEXT:    s_andn2_b32 s3, s3, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_lshl_or_b32 v2, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v2, v0, s10, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v2, v0, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-NEXT:    v_and_or_b32 v2, v1, s10, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v5
; GFX9-NEXT:    v_or3_b32 v1, v2, v1, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s9, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, s9
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_and_b32 s2, s2, s9
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s5, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s3, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s5, 24
; GFX8-NEXT:    s_lshr_b32 s6, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s6, s9
; GFX8-NEXT:    s_lshr_b32 s7, s1, 16
; GFX8-NEXT:    s_lshr_b32 s8, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s2, s7, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s8, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshr_b32 s2, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, s9, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s3, s3, s4
; GFX8-NEXT:    v_or_b32_e32 v2, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s9, 0xff
; GFX7-NEXT:    v_and_b32_e32 v0, s9, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s2, s0, 8
; GFX7-NEXT:    s_and_b32 s2, s2, s9
; GFX7-NEXT:    s_lshr_b32 s3, s0, 16
; GFX7-NEXT:    s_lshr_b32 s5, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s3, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_lshl_b32 s2, s5, 24
; GFX7-NEXT:    s_lshr_b32 s6, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s6, s9
; GFX7-NEXT:    s_lshr_b32 s7, s1, 16
; GFX7-NEXT:    s_lshr_b32 s8, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_and_b32 s2, s7, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshl_b32 s2, s8, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, s9, s4
; GFX7-NEXT:    s_andn2_b32 s3, s3, s4
; GFX7-NEXT:    v_or_b32_e32 v2, s3, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s9, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s9, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_v(<8 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s10, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s10
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s6, 24
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s7, s10
; GFX9-NEXT:    s_lshr_b32 s8, s1, 16
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s8, s10
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s9, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_and_b32 s2, s4, s10
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v0, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s10
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v3, v1, v0, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX9-NEXT:    s_mov_b32 s5, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v2, v0, s10, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v2, v0, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-NEXT:    v_and_or_b32 v2, v1, s10, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v5
; GFX9-NEXT:    v_or3_b32 v1, v2, v1, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s9, 0xff
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_and_b32 s2, s2, s9
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s5, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s3, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s5, 24
; GFX8-NEXT:    s_lshr_b32 s6, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s6, s9
; GFX8-NEXT:    s_lshr_b32 s7, s1, 16
; GFX8-NEXT:    s_lshr_b32 s8, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s2, s7, s9
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s8, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_and_b32 s2, s4, s9
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v0, s2
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s9
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v7, s9
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s9, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s2, s0, 8
; GFX7-NEXT:    s_and_b32 s2, s2, s9
; GFX7-NEXT:    s_lshr_b32 s3, s0, 16
; GFX7-NEXT:    s_lshr_b32 s5, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s3, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_lshl_b32 s2, s5, 24
; GFX7-NEXT:    s_lshr_b32 s6, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s6, s9
; GFX7-NEXT:    s_lshr_b32 s7, s1, 16
; GFX7-NEXT:    s_lshr_b32 s8, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_and_b32 s2, s7, s9
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshl_b32 s2, s8, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_and_b32 s2, s4, s9
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshl_b32_e32 v3, s2, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s9, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s9, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s9, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s9, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_v(<8 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s9, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, s9
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s5, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s9
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s3, s9
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s5, 24
; GFX9-NEXT:    s_lshr_b32 s6, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s6, s9
; GFX9-NEXT:    s_lshr_b32 s7, s1, 16
; GFX9-NEXT:    s_lshr_b32 s8, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s9
; GFX9-NEXT:    s_lshl_b32 s2, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_and_b32 s2, s7, s9
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s8, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v3, v3, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v2, v0, s9, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v2, v0, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-NEXT:    v_and_or_b32 v2, v1, s9, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v5
; GFX9-NEXT:    v_or3_b32 v1, v2, v1, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s8, 0xff
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_and_b32 s2, s2, s8
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s8
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s3, s8
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s4, 24
; GFX8-NEXT:    s_lshr_b32 s5, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s5, s8
; GFX8-NEXT:    s_lshr_b32 s6, s1, 16
; GFX8-NEXT:    s_lshr_b32 s7, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s8
; GFX8-NEXT:    s_lshl_b32 s2, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s2, s6, s8
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s7, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v7, s8
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s8, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s2, s0, 8
; GFX7-NEXT:    s_and_b32 s2, s2, s8
; GFX7-NEXT:    s_lshr_b32 s3, s0, 16
; GFX7-NEXT:    s_lshr_b32 s4, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s8
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s3, s8
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_lshl_b32 s2, s4, 24
; GFX7-NEXT:    s_lshr_b32 s5, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s5, s8
; GFX7-NEXT:    s_lshr_b32 s6, s1, 16
; GFX7-NEXT:    s_lshr_b32 s7, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s8
; GFX7-NEXT:    s_lshl_b32 s2, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_and_b32 s2, s6, s8
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshl_b32 s2, s7, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    v_and_b32_e32 v0, s8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s8, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    v_mov_b32_e32 v4, s1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s8, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s8, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s8, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s8, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_v(<8 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_and_b32 s1, s2, s3
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v5, v2, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_mov_b32_e32 v3, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, s0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v10, v0, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v11, v1, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v8
; GFX9-NEXT:    v_or3_b32 v0, v0, v10, v7
; GFX9-NEXT:    v_or3_b32 v1, v1, v11, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v6, v2, v5
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v7, v0, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v8, v1, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v4
; GFX9-NEXT:    v_or3_b32 v1, v1, v8, v5
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, s0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v7, v2, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX8-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v9
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v12, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v13, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v13
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v7
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v5, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s3, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v4, s0, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, s3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v5, s3, v5
; GFX7-NEXT:    v_and_b32_e32 v8, s3, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v6, s3, v6
; GFX7-NEXT:    v_and_b32_e32 v9, s3, v9
; GFX7-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s3, v2
; GFX7-NEXT:    v_and_b32_e32 v5, s3, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s3, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s3, v6
; GFX7-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_s(<8 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    s_lshr_b32 s1, s2, 2
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s2, s3, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX9-NEXT:    s_not_b32 s2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v8, v0, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v9, v1, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v6
; GFX9-NEXT:    v_or3_b32 v0, v0, v8, v5
; GFX9-NEXT:    v_or3_b32 v1, v1, v9, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v4, s2, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v7, v0, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v8, v1, s3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v4
; GFX9-NEXT:    v_or3_b32 v1, v1, v8, v5
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_lshr_b32 s1, s2, 2
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s2, s2, 3
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v10, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v11, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v11
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v5, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s3, 0xff
; GFX7-NEXT:    s_and_b32 s1, s2, 3
; GFX7-NEXT:    s_lshr_b32 s0, s2, 2
; GFX7-NEXT:    v_and_b32_e32 v2, s3, v2
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s1, v2
; GFX7-NEXT:    s_lshl_b32 s1, s3, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s3, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s3, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, s3, v4
; GFX7-NEXT:    v_and_b32_e32 v7, s3, v7
; GFX7-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, s1, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s3, v2
; GFX7-NEXT:    v_and_b32_e32 v5, s3, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s3, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s3, v6
; GFX7-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_and_b32_e32 v1, s3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_v(<8 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 2, v3
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, v3, v4
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v11, v0, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v12, v1, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_and_or_b32 v0, v0, s1, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, s1, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_or3_b32 v0, v0, v11, v8
; GFX9-NEXT:    v_or3_b32 v1, v1, v12, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v7, v3, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v8, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_and_or_b32 v0, v0, v4, v2
; GFX9-NEXT:    v_and_b32_sdwa v9, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or3_b32 v0, v0, v8, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, v4, v5
; GFX9-NEXT:    v_or3_b32 v1, v1, v9, v6
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v5, 8
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, s0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v3, v4
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX8-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v6, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_and_b32_sdwa v13, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v7, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_and_b32_sdwa v4, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX7-NEXT:    v_and_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v6, s0, v6
; GFX7-NEXT:    v_and_b32_e32 v9, s0, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v7, s0, v7
; GFX7-NEXT:    v_and_b32_e32 v10, s0, v10
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v11
; GFX7-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, v6, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v6, v6, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_s(<16 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s18, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s6, s0, 8
; GFX9-NEXT:    s_and_b32 s6, s6, s18
; GFX9-NEXT:    s_lshr_b32 s7, s0, 16
; GFX9-NEXT:    s_lshr_b32 s8, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_and_b32 s6, s7, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_lshl_b32 s6, s8, 24
; GFX9-NEXT:    s_lshr_b32 s9, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_and_b32 s6, s9, s18
; GFX9-NEXT:    s_lshr_b32 s10, s1, 16
; GFX9-NEXT:    s_lshr_b32 s11, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_and_b32 s6, s10, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_lshl_b32 s6, s11, 24
; GFX9-NEXT:    s_lshr_b32 s12, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_and_b32 s6, s12, s18
; GFX9-NEXT:    s_lshr_b32 s13, s2, 16
; GFX9-NEXT:    s_lshr_b32 s14, s2, 24
; GFX9-NEXT:    s_and_b32 s2, s2, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_and_b32 s6, s13, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_lshl_b32 s6, s14, 24
; GFX9-NEXT:    s_lshr_b32 s15, s3, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_and_b32 s6, s15, s18
; GFX9-NEXT:    s_lshr_b32 s16, s3, 16
; GFX9-NEXT:    s_lshr_b32 s17, s3, 24
; GFX9-NEXT:    s_and_b32 s3, s3, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_and_b32 s6, s16, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_lshl_b32 s6, s17, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_lshr_b32 s6, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s7, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s7, s2, s7
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s7, s3, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, s18, s5
; GFX9-NEXT:    s_andn2_b32 s5, s7, s5
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    s_cselect_b32 s0, s4, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s1, s4, s1
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s2, s4, s2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s3, s4, s3
; GFX9-NEXT:    s_lshr_b32 s4, s0, 8
; GFX9-NEXT:    s_and_b32 s4, s4, s18
; GFX9-NEXT:    s_lshr_b32 s5, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_and_b32 s4, s5, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_lshl_b32 s4, s6, 24
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_and_b32 s4, s7, s18
; GFX9-NEXT:    s_lshr_b32 s8, s1, 16
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s4
; GFX9-NEXT:    s_and_b32 s4, s8, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s4
; GFX9-NEXT:    s_lshl_b32 s4, s9, 24
; GFX9-NEXT:    s_lshr_b32 s10, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s4
; GFX9-NEXT:    s_and_b32 s4, s10, s18
; GFX9-NEXT:    s_lshr_b32 s11, s2, 16
; GFX9-NEXT:    s_lshr_b32 s12, s2, 24
; GFX9-NEXT:    s_and_b32 s2, s2, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s4
; GFX9-NEXT:    s_and_b32 s4, s11, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 16
; GFX9-NEXT:    s_or_b32 s2, s2, s4
; GFX9-NEXT:    s_lshl_b32 s4, s12, 24
; GFX9-NEXT:    s_lshr_b32 s13, s3, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s4
; GFX9-NEXT:    s_and_b32 s4, s13, s18
; GFX9-NEXT:    s_lshr_b32 s14, s3, 16
; GFX9-NEXT:    s_lshr_b32 s15, s3, 24
; GFX9-NEXT:    s_and_b32 s3, s3, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    s_and_b32 s4, s14, s18
; GFX9-NEXT:    s_lshl_b32 s4, s4, 16
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    s_lshl_b32 s4, s15, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s18, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s6, s0, 8
; GFX8-NEXT:    s_and_b32 s6, s6, s18
; GFX8-NEXT:    s_lshr_b32 s7, s0, 16
; GFX8-NEXT:    s_lshr_b32 s8, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s6
; GFX8-NEXT:    s_and_b32 s6, s7, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s6
; GFX8-NEXT:    s_lshl_b32 s6, s8, 24
; GFX8-NEXT:    s_lshr_b32 s9, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s6
; GFX8-NEXT:    s_and_b32 s6, s9, s18
; GFX8-NEXT:    s_lshr_b32 s10, s1, 16
; GFX8-NEXT:    s_lshr_b32 s11, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s6
; GFX8-NEXT:    s_and_b32 s6, s10, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s6
; GFX8-NEXT:    s_lshl_b32 s6, s11, 24
; GFX8-NEXT:    s_lshr_b32 s12, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s6
; GFX8-NEXT:    s_and_b32 s6, s12, s18
; GFX8-NEXT:    s_lshr_b32 s13, s2, 16
; GFX8-NEXT:    s_lshr_b32 s14, s2, 24
; GFX8-NEXT:    s_and_b32 s2, s2, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_and_b32 s6, s13, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 16
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_lshl_b32 s6, s14, 24
; GFX8-NEXT:    s_lshr_b32 s15, s3, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_and_b32 s6, s15, s18
; GFX8-NEXT:    s_lshr_b32 s16, s3, 16
; GFX8-NEXT:    s_lshr_b32 s17, s3, 24
; GFX8-NEXT:    s_and_b32 s3, s3, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_or_b32 s3, s3, s6
; GFX8-NEXT:    s_and_b32 s6, s16, s18
; GFX8-NEXT:    s_lshl_b32 s6, s6, 16
; GFX8-NEXT:    s_or_b32 s3, s3, s6
; GFX8-NEXT:    s_lshl_b32 s6, s17, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s6
; GFX8-NEXT:    s_lshr_b32 s6, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s7, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s7, s2, s7
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s7, s3, s7
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, s18, s5
; GFX8-NEXT:    s_andn2_b32 s5, s7, s5
; GFX8-NEXT:    s_or_b32 s4, s5, s4
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    s_cselect_b32 s0, s4, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s1, s4, s1
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s2, s4, s2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s3, s4, s3
; GFX8-NEXT:    s_lshr_b32 s4, s0, 8
; GFX8-NEXT:    s_and_b32 s4, s4, s18
; GFX8-NEXT:    s_lshr_b32 s5, s0, 16
; GFX8-NEXT:    s_lshr_b32 s6, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_and_b32 s4, s5, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_lshl_b32 s4, s6, 24
; GFX8-NEXT:    s_lshr_b32 s7, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_and_b32 s4, s7, s18
; GFX8-NEXT:    s_lshr_b32 s8, s1, 16
; GFX8-NEXT:    s_lshr_b32 s9, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_and_b32 s4, s8, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_lshl_b32 s4, s9, 24
; GFX8-NEXT:    s_lshr_b32 s10, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_and_b32 s4, s10, s18
; GFX8-NEXT:    s_lshr_b32 s11, s2, 16
; GFX8-NEXT:    s_lshr_b32 s12, s2, 24
; GFX8-NEXT:    s_and_b32 s2, s2, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_and_b32 s4, s11, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_lshl_b32 s4, s12, 24
; GFX8-NEXT:    s_lshr_b32 s13, s3, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_and_b32 s4, s13, s18
; GFX8-NEXT:    s_lshr_b32 s14, s3, 16
; GFX8-NEXT:    s_lshr_b32 s15, s3, 24
; GFX8-NEXT:    s_and_b32 s3, s3, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_and_b32 s4, s14, s18
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_lshl_b32 s4, s15, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s18, 0xff
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s6, s0, 8
; GFX7-NEXT:    s_and_b32 s6, s6, s18
; GFX7-NEXT:    s_lshr_b32 s7, s0, 16
; GFX7-NEXT:    s_lshr_b32 s8, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s6
; GFX7-NEXT:    s_and_b32 s6, s7, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s6
; GFX7-NEXT:    s_lshl_b32 s6, s8, 24
; GFX7-NEXT:    s_lshr_b32 s9, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s6
; GFX7-NEXT:    s_and_b32 s6, s9, s18
; GFX7-NEXT:    s_lshr_b32 s10, s1, 16
; GFX7-NEXT:    s_lshr_b32 s11, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s6
; GFX7-NEXT:    s_and_b32 s6, s10, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s6
; GFX7-NEXT:    s_lshl_b32 s6, s11, 24
; GFX7-NEXT:    s_lshr_b32 s12, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s6
; GFX7-NEXT:    s_and_b32 s6, s12, s18
; GFX7-NEXT:    s_lshr_b32 s13, s2, 16
; GFX7-NEXT:    s_lshr_b32 s14, s2, 24
; GFX7-NEXT:    s_and_b32 s2, s2, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_and_b32 s6, s13, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_lshl_b32 s6, s14, 24
; GFX7-NEXT:    s_lshr_b32 s15, s3, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_and_b32 s6, s15, s18
; GFX7-NEXT:    s_lshr_b32 s16, s3, 16
; GFX7-NEXT:    s_lshr_b32 s17, s3, 24
; GFX7-NEXT:    s_and_b32 s3, s3, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s3, s3, s6
; GFX7-NEXT:    s_and_b32 s6, s16, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_or_b32 s3, s3, s6
; GFX7-NEXT:    s_lshl_b32 s6, s17, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s6
; GFX7-NEXT:    s_lshr_b32 s6, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s7, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s7, s2, s7
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s7, s3, s7
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, s18
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, s18, s5
; GFX7-NEXT:    s_andn2_b32 s5, s7, s5
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_cmp_eq_u32 s6, 0
; GFX7-NEXT:    s_cselect_b32 s5, s4, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s7, s4, s1
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s2, s4, s2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s3, s4, s3
; GFX7-NEXT:    s_lshr_b32 s4, s5, 8
; GFX7-NEXT:    s_and_b32 s4, s4, s18
; GFX7-NEXT:    s_lshr_b32 s6, s5, 16
; GFX7-NEXT:    s_lshr_b32 s8, s5, 24
; GFX7-NEXT:    s_and_b32 s5, s5, s18
; GFX7-NEXT:    s_lshl_b32 s4, s4, 8
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_and_b32 s5, s6, s18
; GFX7-NEXT:    s_lshr_b32 s9, s7, 8
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_and_b32 s6, s9, s18
; GFX7-NEXT:    s_or_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, s8, 24
; GFX7-NEXT:    s_or_b32 s4, s4, s5
; GFX7-NEXT:    s_lshr_b32 s10, s7, 16
; GFX7-NEXT:    s_and_b32 s5, s7, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_and_b32 s6, s10, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_lshr_b32 s11, s7, 24
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_lshl_b32 s6, s11, 24
; GFX7-NEXT:    s_lshr_b32 s12, s2, 8
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_and_b32 s6, s12, s18
; GFX7-NEXT:    s_lshr_b32 s13, s2, 16
; GFX7-NEXT:    s_lshr_b32 s14, s2, 24
; GFX7-NEXT:    s_and_b32 s2, s2, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_and_b32 s6, s13, s18
; GFX7-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_lshl_b32 s6, s14, 24
; GFX7-NEXT:    s_lshr_b32 s15, s3, 8
; GFX7-NEXT:    s_or_b32 s6, s2, s6
; GFX7-NEXT:    s_lshr_b32 s16, s3, 16
; GFX7-NEXT:    s_lshr_b32 s17, s3, 24
; GFX7-NEXT:    s_and_b32 s2, s3, s18
; GFX7-NEXT:    s_and_b32 s3, s15, s18
; GFX7-NEXT:    s_lshl_b32 s3, s3, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_and_b32 s3, s16, s18
; GFX7-NEXT:    s_lshl_b32 s3, s3, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s3, s17, 24
; GFX7-NEXT:    s_or_b32 s7, s2, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_s(<16 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    s_and_b32 s1, s3, 3
; GFX9-NEXT:    s_lshr_b32 s4, s3, 2
; GFX9-NEXT:    s_and_b32 s2, s2, s6
; GFX9-NEXT:    s_lshl_b32 s1, s1, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s1
; GFX9-NEXT:    s_lshl_b32 s1, s6, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_not_b32 s5, s1
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 8, v3
; GFX9-NEXT:    v_and_b32_sdwa v14, v0, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v15, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v0, v0, s6, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v1, v1, s6, v8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 24, v3
; GFX9-NEXT:    v_and_b32_sdwa v16, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v2, v2, s6, v10
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or3_b32 v0, v0, v14, v7
; GFX9-NEXT:    v_or3_b32 v1, v1, v15, v9
; GFX9-NEXT:    v_and_b32_sdwa v17, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v12
; GFX9-NEXT:    v_or3_b32 v2, v2, v16, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_or3_b32 v3, v3, v17, v13
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v3, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v5, v6, s5, v5
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v4, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v4, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v13, v0, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v14, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v15, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v16, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v0, v0, s6, v5
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_and_or_b32 v1, v1, s6, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v2, v2, s6, v9
; GFX9-NEXT:    v_or3_b32 v0, v0, v13, v6
; GFX9-NEXT:    v_or3_b32 v1, v1, v14, v8
; GFX9-NEXT:    v_or3_b32 v2, v2, v15, v10
; GFX9-NEXT:    v_or3_b32 v3, v3, v16, v11
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, 8
; GFX8-NEXT:    v_mov_b32_e32 v6, s0
; GFX8-NEXT:    s_and_b32 s1, s3, 3
; GFX8-NEXT:    s_lshr_b32 s4, s3, 2
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_lshl_b32 s5, s2, s1
; GFX8-NEXT:    s_not_b32 s6, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v5, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 8, v2
; GFX8-NEXT:    v_and_b32_sdwa v15, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v16, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v10
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v5, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v15
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v16
; GFX8-NEXT:    v_and_b32_sdwa v17, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v5, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 24, v3
; GFX8-NEXT:    v_and_b32_sdwa v18, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 24, v14
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v18
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v13
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX8-NEXT:    v_or_b32_e32 v4, s5, v4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v5, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v5, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v3
; GFX8-NEXT:    v_and_b32_sdwa v14, v0, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v15, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v16, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v6, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v14
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v16
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_movk_i32 s6, 0xff
; GFX7-NEXT:    s_and_b32 s0, s3, 3
; GFX7-NEXT:    s_lshr_b32 s4, s3, 2
; GFX7-NEXT:    s_and_b32 s1, s2, s6
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_lshl_b32 s5, s1, s0
; GFX7-NEXT:    s_lshl_b32 s0, s6, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s7, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_and_b32_e32 v7, s6, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_and_b32_e32 v8, s6, v8
; GFX7-NEXT:    v_and_b32_e32 v10, s6, v10
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v11, s6, v11
; GFX7-NEXT:    v_and_b32_e32 v13, s6, v13
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v14, s6, v14
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v13
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 24, v15
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v14
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v12
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v15
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v4, s7, v4
; GFX7-NEXT:    v_or_b32_e32 v4, s5, v4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1 )* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_s(<16 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s18, 0xff
; GFX9-NEXT:    v_and_b32_e32 v0, s18, v0
; GFX9-NEXT:    s_mov_b32 s5, 8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s6, s0, 8
; GFX9-NEXT:    s_and_b32 s6, s6, s18
; GFX9-NEXT:    s_lshr_b32 s7, s0, 16
; GFX9-NEXT:    s_lshr_b32 s8, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_and_b32 s6, s7, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_lshl_b32 s6, s8, 24
; GFX9-NEXT:    s_lshr_b32 s9, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_and_b32 s6, s9, s18
; GFX9-NEXT:    s_lshr_b32 s10, s1, 16
; GFX9-NEXT:    s_lshr_b32 s11, s1, 24
; GFX9-NEXT:    s_and_b32 s1, s1, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_and_b32 s6, s10, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_lshl_b32 s6, s11, 24
; GFX9-NEXT:    s_lshr_b32 s12, s2, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_and_b32 s6, s12, s18
; GFX9-NEXT:    s_lshr_b32 s13, s2, 16
; GFX9-NEXT:    s_lshr_b32 s14, s2, 24
; GFX9-NEXT:    s_and_b32 s2, s2, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_and_b32 s6, s13, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_lshl_b32 s6, s14, 24
; GFX9-NEXT:    s_lshr_b32 s15, s3, 8
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_and_b32 s6, s15, s18
; GFX9-NEXT:    s_lshr_b32 s16, s3, 16
; GFX9-NEXT:    s_lshr_b32 s17, s3, 24
; GFX9-NEXT:    s_and_b32 s3, s3, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_and_b32 s6, s16, s18
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_lshl_b32 s6, s17, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_lshr_b32 s6, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s7, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s7, s2, s7
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s7, s3, s7
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s8, s18, s4
; GFX9-NEXT:    s_andn2_b32 s7, s7, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_lshl_or_b32 v4, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s6, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s6, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s6, 2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s6, 3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v4, v0, s18, v4
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v4, v0, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_and_or_b32 v5, v1, s18, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX9-NEXT:    v_or3_b32 v1, v5, v1, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v5, v2, s18, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-NEXT:    v_and_b32_sdwa v2, v2, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v9
; GFX9-NEXT:    v_or3_b32 v2, v5, v2, v6
; GFX9-NEXT:    v_and_or_b32 v4, v3, s18, v4
; GFX9-NEXT:    v_and_b32_sdwa v3, v3, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v11
; GFX9-NEXT:    v_or3_b32 v3, v4, v3, v5
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s17, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s5, s0, 8
; GFX8-NEXT:    s_and_b32 s5, s5, s17
; GFX8-NEXT:    s_lshr_b32 s6, s0, 16
; GFX8-NEXT:    s_lshr_b32 s7, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_and_b32 s5, s6, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_lshl_b32 s5, s7, 24
; GFX8-NEXT:    s_lshr_b32 s8, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_and_b32 s5, s8, s17
; GFX8-NEXT:    s_lshr_b32 s9, s1, 16
; GFX8-NEXT:    s_lshr_b32 s10, s1, 24
; GFX8-NEXT:    s_and_b32 s1, s1, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s5
; GFX8-NEXT:    s_and_b32 s5, s9, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s5
; GFX8-NEXT:    s_lshl_b32 s5, s10, 24
; GFX8-NEXT:    s_lshr_b32 s11, s2, 8
; GFX8-NEXT:    s_or_b32 s1, s1, s5
; GFX8-NEXT:    s_and_b32 s5, s11, s17
; GFX8-NEXT:    s_lshr_b32 s12, s2, 16
; GFX8-NEXT:    s_lshr_b32 s13, s2, 24
; GFX8-NEXT:    s_and_b32 s2, s2, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_and_b32 s5, s12, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 16
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_lshl_b32 s5, s13, 24
; GFX8-NEXT:    s_lshr_b32 s14, s3, 8
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_and_b32 s5, s14, s17
; GFX8-NEXT:    s_lshr_b32 s15, s3, 16
; GFX8-NEXT:    s_lshr_b32 s16, s3, 24
; GFX8-NEXT:    s_and_b32 s3, s3, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_or_b32 s3, s3, s5
; GFX8-NEXT:    s_and_b32 s5, s15, s17
; GFX8-NEXT:    s_lshl_b32 s5, s5, 16
; GFX8-NEXT:    s_or_b32 s3, s3, s5
; GFX8-NEXT:    s_lshl_b32 s5, s16, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s5
; GFX8-NEXT:    s_lshr_b32 s5, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s5, 1
; GFX8-NEXT:    s_cselect_b32 s6, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s5, 2
; GFX8-NEXT:    s_cselect_b32 s6, s2, s6
; GFX8-NEXT:    s_cmp_eq_u32 s5, 3
; GFX8-NEXT:    s_cselect_b32 s6, s3, s6
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, s17, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s4, s6, s4
; GFX8-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v12, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v12, s17
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v5, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v2, v2, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v3, v3, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s17, 0xff
; GFX7-NEXT:    v_and_b32_e32 v0, s17, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s5, s0, 8
; GFX7-NEXT:    s_and_b32 s5, s5, s17
; GFX7-NEXT:    s_lshr_b32 s6, s0, 16
; GFX7-NEXT:    s_lshr_b32 s7, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_and_b32 s5, s6, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_lshl_b32 s5, s7, 24
; GFX7-NEXT:    s_lshr_b32 s8, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_and_b32 s5, s8, s17
; GFX7-NEXT:    s_lshr_b32 s9, s1, 16
; GFX7-NEXT:    s_lshr_b32 s10, s1, 24
; GFX7-NEXT:    s_and_b32 s1, s1, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s5
; GFX7-NEXT:    s_and_b32 s5, s9, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s1, s1, s5
; GFX7-NEXT:    s_lshl_b32 s5, s10, 24
; GFX7-NEXT:    s_lshr_b32 s11, s2, 8
; GFX7-NEXT:    s_or_b32 s1, s1, s5
; GFX7-NEXT:    s_and_b32 s5, s11, s17
; GFX7-NEXT:    s_lshr_b32 s12, s2, 16
; GFX7-NEXT:    s_lshr_b32 s13, s2, 24
; GFX7-NEXT:    s_and_b32 s2, s2, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_and_b32 s5, s12, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_lshl_b32 s5, s13, 24
; GFX7-NEXT:    s_lshr_b32 s14, s3, 8
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_and_b32 s5, s14, s17
; GFX7-NEXT:    s_lshr_b32 s15, s3, 16
; GFX7-NEXT:    s_lshr_b32 s16, s3, 24
; GFX7-NEXT:    s_and_b32 s3, s3, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_or_b32 s3, s3, s5
; GFX7-NEXT:    s_and_b32 s5, s15, s17
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s3, s3, s5
; GFX7-NEXT:    s_lshl_b32 s5, s16, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s5
; GFX7-NEXT:    s_lshr_b32 s5, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s5, 1
; GFX7-NEXT:    s_cselect_b32 s6, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s5, 2
; GFX7-NEXT:    s_cselect_b32 s6, s2, s6
; GFX7-NEXT:    s_cmp_eq_u32 s5, 3
; GFX7-NEXT:    s_cselect_b32 s6, s3, s6
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, s17, s4
; GFX7-NEXT:    s_andn2_b32 s4, s6, s4
; GFX7-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s17, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s17, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s17, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s17, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s17, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_v(<16 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s18, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s5, s0, 8
; GFX9-NEXT:    s_and_b32 s5, s5, s18
; GFX9-NEXT:    s_lshr_b32 s7, s0, 16
; GFX9-NEXT:    s_lshr_b32 s8, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s18
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s5
; GFX9-NEXT:    s_and_b32 s5, s7, s18
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s5
; GFX9-NEXT:    s_lshl_b32 s5, s8, 24
; GFX9-NEXT:    s_lshr_b32 s9, s1, 8
; GFX9-NEXT:    s_or_b32 s8, s0, s5
; GFX9-NEXT:    s_lshr_b32 s10, s1, 16
; GFX9-NEXT:    s_lshr_b32 s11, s1, 24
; GFX9-NEXT:    s_and_b32 s0, s1, s18
; GFX9-NEXT:    s_and_b32 s1, s9, s18
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s10, s18
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s11, 24
; GFX9-NEXT:    s_lshr_b32 s12, s2, 8
; GFX9-NEXT:    s_or_b32 s9, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s12, s18
; GFX9-NEXT:    s_lshr_b32 s13, s2, 16
; GFX9-NEXT:    s_and_b32 s0, s2, s18
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s13, s18
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_lshr_b32 s14, s2, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s14, 24
; GFX9-NEXT:    s_lshr_b32 s15, s3, 8
; GFX9-NEXT:    s_or_b32 s10, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s15, s18
; GFX9-NEXT:    s_lshr_b32 s16, s3, 16
; GFX9-NEXT:    s_and_b32 s0, s3, s18
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s16, s18
; GFX9-NEXT:    s_lshr_b32 s17, s3, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s17, 24
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-NEXT:    s_or_b32 s11, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_and_b32 s4, s4, s18
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v5, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    s_mov_b32 s6, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s6, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v4, v0, s18, v4
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v4, v0, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_and_or_b32 v5, v1, s18, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX9-NEXT:    v_or3_b32 v1, v5, v1, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v5, v2, s18, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-NEXT:    v_and_b32_sdwa v2, v2, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v9
; GFX9-NEXT:    v_or3_b32 v2, v5, v2, v6
; GFX9-NEXT:    v_and_or_b32 v4, v3, s18, v4
; GFX9-NEXT:    v_and_b32_sdwa v3, v3, s18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v11
; GFX9-NEXT:    v_or3_b32 v3, v4, v3, v5
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s18, 0xff
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s5, s0, 8
; GFX8-NEXT:    s_and_b32 s5, s5, s18
; GFX8-NEXT:    s_lshr_b32 s6, s0, 16
; GFX8-NEXT:    s_lshr_b32 s7, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s18
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_and_b32 s5, s6, s18
; GFX8-NEXT:    s_lshl_b32 s5, s5, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_lshl_b32 s5, s7, 24
; GFX8-NEXT:    s_lshr_b32 s9, s1, 8
; GFX8-NEXT:    s_or_b32 s8, s0, s5
; GFX8-NEXT:    s_lshr_b32 s10, s1, 16
; GFX8-NEXT:    s_lshr_b32 s11, s1, 24
; GFX8-NEXT:    s_and_b32 s0, s1, s18
; GFX8-NEXT:    s_and_b32 s1, s9, s18
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s10, s18
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s11, 24
; GFX8-NEXT:    s_lshr_b32 s12, s2, 8
; GFX8-NEXT:    s_or_b32 s9, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s12, s18
; GFX8-NEXT:    s_lshr_b32 s13, s2, 16
; GFX8-NEXT:    s_and_b32 s0, s2, s18
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s13, s18
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_lshr_b32 s14, s2, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s14, 24
; GFX8-NEXT:    s_lshr_b32 s15, s3, 8
; GFX8-NEXT:    s_or_b32 s10, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s15, s18
; GFX8-NEXT:    s_lshr_b32 s16, s3, 16
; GFX8-NEXT:    s_and_b32 s0, s3, s18
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s16, s18
; GFX8-NEXT:    s_lshr_b32 s17, s3, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s17, 24
; GFX8-NEXT:    v_mov_b32_e32 v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NEXT:    s_or_b32 s11, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_and_b32 s4, s4, s18
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s18
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v12, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v12, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_mov_b32_e32 v12, s18
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v5, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v2, v2, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v3, v3, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s18, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s5, s0, 8
; GFX7-NEXT:    s_and_b32 s5, s5, s18
; GFX7-NEXT:    s_lshr_b32 s6, s0, 16
; GFX7-NEXT:    s_lshr_b32 s7, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s18
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_and_b32 s5, s6, s18
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_lshl_b32 s5, s7, 24
; GFX7-NEXT:    s_lshr_b32 s9, s1, 8
; GFX7-NEXT:    s_or_b32 s8, s0, s5
; GFX7-NEXT:    s_lshr_b32 s10, s1, 16
; GFX7-NEXT:    s_lshr_b32 s11, s1, 24
; GFX7-NEXT:    s_and_b32 s0, s1, s18
; GFX7-NEXT:    s_and_b32 s1, s9, s18
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s10, s18
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s11, 24
; GFX7-NEXT:    s_lshr_b32 s12, s2, 8
; GFX7-NEXT:    s_or_b32 s9, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s12, s18
; GFX7-NEXT:    s_lshr_b32 s13, s2, 16
; GFX7-NEXT:    s_and_b32 s0, s2, s18
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s13, s18
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_lshr_b32 s14, s2, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s14, 24
; GFX7-NEXT:    s_lshr_b32 s15, s3, 8
; GFX7-NEXT:    s_or_b32 s10, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s15, s18
; GFX7-NEXT:    s_lshr_b32 s16, s3, 16
; GFX7-NEXT:    s_and_b32 s0, s3, s18
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s16, s18
; GFX7-NEXT:    s_lshr_b32 s17, s3, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s17, 24
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-NEXT:    s_or_b32 s11, s0, s1
; GFX7-NEXT:    v_mov_b32_e32 v3, s10
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_and_b32 s4, s4, s18
; GFX7-NEXT:    v_lshl_b32_e32 v2, s4, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s18, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s18, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s18, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s18, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s18, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s18, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_v(<16 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_movk_i32 s17, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s4, s0, 8
; GFX9-NEXT:    s_and_b32 s4, s4, s17
; GFX9-NEXT:    s_lshr_b32 s5, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s0, s0, s17
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_and_b32 s4, s5, s17
; GFX9-NEXT:    s_lshl_b32 s4, s4, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_lshl_b32 s4, s6, 24
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_or_b32 s4, s0, s4
; GFX9-NEXT:    s_lshr_b32 s9, s1, 16
; GFX9-NEXT:    s_lshr_b32 s10, s1, 24
; GFX9-NEXT:    s_and_b32 s0, s1, s17
; GFX9-NEXT:    s_and_b32 s1, s7, s17
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s9, s17
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s10, 24
; GFX9-NEXT:    s_lshr_b32 s11, s2, 8
; GFX9-NEXT:    s_or_b32 s5, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s11, s17
; GFX9-NEXT:    s_lshr_b32 s12, s2, 16
; GFX9-NEXT:    s_and_b32 s0, s2, s17
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s12, s17
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_lshr_b32 s13, s2, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s13, 24
; GFX9-NEXT:    s_lshr_b32 s14, s3, 8
; GFX9-NEXT:    s_or_b32 s6, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s14, s17
; GFX9-NEXT:    s_lshr_b32 s15, s3, 16
; GFX9-NEXT:    s_and_b32 s0, s3, s17
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_and_b32 s1, s15, s17
; GFX9-NEXT:    s_lshr_b32 s16, s3, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s16, 24
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    s_or_b32 s7, s0, s1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v6, s7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v5, v2, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX9-NEXT:    s_mov_b32 s8, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v4, v0, s17, v4
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, s17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v4, v0, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_and_or_b32 v5, v1, s17, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX9-NEXT:    v_or3_b32 v1, v5, v1, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v5, v2, s17, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-NEXT:    v_and_b32_sdwa v2, v2, s17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v9
; GFX9-NEXT:    v_or3_b32 v2, v5, v2, v6
; GFX9-NEXT:    v_and_or_b32 v4, v3, s17, v4
; GFX9-NEXT:    v_and_b32_sdwa v3, v3, s17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v11
; GFX9-NEXT:    v_or3_b32 v3, v4, v3, v5
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_movk_i32 s16, 0xff
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s4, s0, 8
; GFX8-NEXT:    s_and_b32 s4, s4, s16
; GFX8-NEXT:    s_lshr_b32 s5, s0, 16
; GFX8-NEXT:    s_lshr_b32 s6, s0, 24
; GFX8-NEXT:    s_and_b32 s0, s0, s16
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_and_b32 s4, s5, s16
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_lshl_b32 s4, s6, 24
; GFX8-NEXT:    s_lshr_b32 s7, s1, 8
; GFX8-NEXT:    s_or_b32 s4, s0, s4
; GFX8-NEXT:    s_lshr_b32 s8, s1, 16
; GFX8-NEXT:    s_lshr_b32 s9, s1, 24
; GFX8-NEXT:    s_and_b32 s0, s1, s16
; GFX8-NEXT:    s_and_b32 s1, s7, s16
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s8, s16
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s9, 24
; GFX8-NEXT:    s_lshr_b32 s10, s2, 8
; GFX8-NEXT:    s_or_b32 s5, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s10, s16
; GFX8-NEXT:    s_lshr_b32 s11, s2, 16
; GFX8-NEXT:    s_and_b32 s0, s2, s16
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s11, s16
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_lshr_b32 s12, s2, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s12, 24
; GFX8-NEXT:    s_lshr_b32 s13, s3, 8
; GFX8-NEXT:    s_or_b32 s6, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s13, s16
; GFX8-NEXT:    s_lshr_b32 s14, s3, 16
; GFX8-NEXT:    s_and_b32 s0, s3, s16
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s14, s16
; GFX8-NEXT:    s_lshr_b32 s15, s3, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s15, 24
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    s_or_b32 s7, s0, s1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s16
; GFX8-NEXT:    v_mov_b32_e32 v6, s7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v12, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v12, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v12, s16
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v5, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v2, v2, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v3, v3, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_movk_i32 s16, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s4, s0, 8
; GFX7-NEXT:    s_and_b32 s4, s4, s16
; GFX7-NEXT:    s_lshr_b32 s5, s0, 16
; GFX7-NEXT:    s_lshr_b32 s6, s0, 24
; GFX7-NEXT:    s_and_b32 s0, s0, s16
; GFX7-NEXT:    s_lshl_b32 s4, s4, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s4
; GFX7-NEXT:    s_and_b32 s4, s5, s16
; GFX7-NEXT:    s_lshl_b32 s4, s4, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s4
; GFX7-NEXT:    s_lshl_b32 s4, s6, 24
; GFX7-NEXT:    s_lshr_b32 s7, s1, 8
; GFX7-NEXT:    s_or_b32 s4, s0, s4
; GFX7-NEXT:    s_lshr_b32 s8, s1, 16
; GFX7-NEXT:    s_lshr_b32 s9, s1, 24
; GFX7-NEXT:    s_and_b32 s0, s1, s16
; GFX7-NEXT:    s_and_b32 s1, s7, s16
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s8, s16
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s9, 24
; GFX7-NEXT:    s_lshr_b32 s10, s2, 8
; GFX7-NEXT:    s_or_b32 s5, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s10, s16
; GFX7-NEXT:    s_lshr_b32 s11, s2, 16
; GFX7-NEXT:    s_and_b32 s0, s2, s16
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s11, s16
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_lshr_b32 s12, s2, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s12, 24
; GFX7-NEXT:    s_lshr_b32 s13, s3, 8
; GFX7-NEXT:    s_or_b32 s6, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s13, s16
; GFX7-NEXT:    s_lshr_b32 s14, s3, 16
; GFX7-NEXT:    s_and_b32 s0, s3, s16
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s14, s16
; GFX7-NEXT:    s_lshr_b32 s15, s3, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s15, 24
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    s_or_b32 s7, s0, s1
; GFX7-NEXT:    v_mov_b32_e32 v5, s6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s16, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, s7
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s16, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s16, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s16, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_v(<16 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_and_b32 s1, s2, s6
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_lshlrev_b32_e64 v7, v2, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s6
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v1
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, s0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v0, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 24, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 8, v6
; GFX9-NEXT:    v_and_b32_sdwa v16, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v17, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v4, v4, s6, v10
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, v0, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v6
; GFX9-NEXT:    v_and_b32_sdwa v18, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX9-NEXT:    v_and_or_b32 v5, v5, s6, v12
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or3_b32 v3, v3, v16, v9
; GFX9-NEXT:    v_or3_b32 v4, v4, v17, v11
; GFX9-NEXT:    v_and_b32_sdwa v19, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v15, 24, v15
; GFX9-NEXT:    v_and_or_b32 v6, v6, s6, v14
; GFX9-NEXT:    v_or3_b32 v5, v5, v18, v13
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v1
; GFX9-NEXT:    v_or3_b32 v6, v6, v19, v15
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v2, v8, v2, v7
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v3, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v5, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v0, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v13, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v14, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v15, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v1, v1, s6, v5
; GFX9-NEXT:    v_and_b32_sdwa v16, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v5, v2, s6, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v4, v4, s6, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v7
; GFX9-NEXT:    v_or3_b32 v0, v1, v13, v6
; GFX9-NEXT:    v_or3_b32 v1, v3, v14, v8
; GFX9-NEXT:    v_or3_b32 v2, v4, v15, v10
; GFX9-NEXT:    v_or3_b32 v3, v5, v16, v11
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, s0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX8-NEXT:    v_lshlrev_b32_e64 v9, v2, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX8-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 8, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v16, 8, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v4
; GFX8-NEXT:    v_and_b32_sdwa v18, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v19, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v1, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v19
; GFX8-NEXT:    v_and_b32_sdwa v10, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v4, v5, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v1, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v18
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 24, v6
; GFX8-NEXT:    v_or_b32_sdwa v5, v6, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v6, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 24, v15
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v10
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 24, v17
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v3, vcc
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v14
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v5, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v2, v6, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v2
; GFX8-NEXT:    v_and_b32_sdwa v15, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v16, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v14, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v7, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v15
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v16
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v4, v1, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v9
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v12
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v14
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_movk_i32 s6, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v17, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, s6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v17
; GFX7-NEXT:    v_lshl_b32_e32 v18, s0, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v17
; GFX7-NEXT:    v_lshl_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v17
; GFX7-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v17
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 8, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 8, v5
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_and_b32_e32 v8, s6, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 16, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 8, v6
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_and_b32_e32 v9, s6, v9
; GFX7-NEXT:    v_and_b32_e32 v11, s6, v11
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 24, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 16, v6
; GFX7-NEXT:    v_and_b32_e32 v12, s6, v12
; GFX7-NEXT:    v_and_b32_e32 v14, s6, v14
; GFX7-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v16, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v15, s6, v15
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v12
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v14
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v15
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 24, v16
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v13
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v16
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v4, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v18
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v13
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_s(<16 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_and_b32 s1, s2, 3
; GFX9-NEXT:    s_lshl_b32 s1, s1, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    s_lshl_b32 s1, s6, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_not_b32 s5, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 8, v6
; GFX9-NEXT:    v_and_b32_sdwa v14, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v2, v3, s6, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_b32_sdwa v15, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v3, v4, s6, v8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v0, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 24, v6
; GFX9-NEXT:    v_and_b32_sdwa v16, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v4, v5, s6, v10
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, v0, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or3_b32 v2, v2, v14, v7
; GFX9-NEXT:    v_or3_b32 v3, v3, v15, v9
; GFX9-NEXT:    v_and_b32_sdwa v17, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v5, v6, s6, v12
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX9-NEXT:    v_or3_b32 v4, v4, v16, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v2, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_or3_b32 v5, v5, v17, v13
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v4, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v5, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v1, v6, s5, v1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, v1, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v1, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v0, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v13, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v14, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v15, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v2, v2, s6, v5
; GFX9-NEXT:    v_and_b32_sdwa v16, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v5, v1, s6, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX9-NEXT:    v_and_or_b32 v4, v4, s6, v9
; GFX9-NEXT:    v_or3_b32 v0, v2, v13, v6
; GFX9-NEXT:    v_or3_b32 v1, v3, v14, v8
; GFX9-NEXT:    v_or3_b32 v2, v4, v15, v10
; GFX9-NEXT:    v_or3_b32 v3, v5, v16, v11
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v8, s1
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, s0
; GFX8-NEXT:    s_lshr_b32 s4, s2, 2
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_not_b32 s5, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v9
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v11
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v11, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 8, v6
; GFX8-NEXT:    v_and_b32_sdwa v16, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v17, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v4, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v16
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v17
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_and_b32_sdwa v18, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v4, v5, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v1, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v18
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 24, v6
; GFX8-NEXT:    v_and_b32_sdwa v19, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v5, v6, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 24, v15
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v19
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v3, vcc
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v14
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v5, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v6, s5, v6
; GFX8-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v2
; GFX8-NEXT:    v_and_b32_sdwa v15, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v16, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v14, v0, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v7, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v15
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v16
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v4, v1, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v9
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v12
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v14
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_movk_i32 s6, 0xff
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    s_lshr_b32 s4, s2, 2
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    s_lshl_b32 s0, s6, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s5, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 8, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 8, v5
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_and_b32_e32 v8, s6, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 16, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 8, v6
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_and_b32_e32 v9, s6, v9
; GFX7-NEXT:    v_and_b32_e32 v11, s6, v11
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 24, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 16, v6
; GFX7-NEXT:    v_and_b32_e32 v12, s6, v12
; GFX7-NEXT:    v_and_b32_e32 v14, s6, v14
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v16, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v15, s6, v15
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v12
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v14
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v10
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v15
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 24, v16
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v13
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v1, v2, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v16
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v4, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v5, s5, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v0, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v0, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_and_b32_e32 v1, s6, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v2, s6, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v3, s6, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v13
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_and_b32_e32 v5, s6, v5
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v15
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_v(<16 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 2, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, v3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v11, v1, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_b32_sdwa v17, v4, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v18, v5, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v5, v5, s1, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 24, v7
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, v1, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v1, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_and_or_b32 v4, v4, s1, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_b32_sdwa v19, v6, s1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v6, v6, s1, v13
; GFX9-NEXT:    v_and_or_b32 v9, v7, v0, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v14
; GFX9-NEXT:    v_and_b32_sdwa v7, v7, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 24, v16
; GFX9-NEXT:    v_or3_b32 v4, v4, v17, v10
; GFX9-NEXT:    v_or3_b32 v5, v5, v18, v11
; GFX9-NEXT:    v_or3_b32 v7, v9, v7, v13
; GFX9-NEXT:    v_or3_b32 v6, v6, v19, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v4, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v7, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v2, v9, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v4, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v6, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v7, v2, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 8, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX9-NEXT:    v_and_b32_sdwa v15, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v16, v5, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v4, v4, v0, v8
; GFX9-NEXT:    v_and_or_b32 v5, v5, v0, v10
; GFX9-NEXT:    v_and_b32_sdwa v14, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_and_or_b32 v3, v3, v0, v6
; GFX9-NEXT:    v_and_or_b32 v6, v2, v0, v1
; GFX9-NEXT:    v_and_b32_sdwa v17, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX9-NEXT:    v_or3_b32 v1, v4, v15, v9
; GFX9-NEXT:    v_or3_b32 v2, v5, v16, v11
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_or3_b32 v0, v3, v14, v7
; GFX9-NEXT:    v_or3_b32 v3, v6, v17, v12
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_mov_b32_e32 v9, s0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v10
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v10
; GFX8-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v10
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 8, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 8, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 8, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v8, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 8, v7
; GFX8-NEXT:    v_and_b32_sdwa v19, v4, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 24, v5
; GFX8-NEXT:    v_or_b32_sdwa v4, v5, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v9, v5, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v8, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v16, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 24, v14
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v9
; GFX8-NEXT:    v_and_b32_sdwa v11, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v5, v6, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v8, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v19
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 24, v7
; GFX8-NEXT:    v_or_b32_sdwa v6, v7, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v7, v7, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 24, v16
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v11
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v12
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v13
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 24, v18
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v1, v4, vcc
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v15
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v3, v7, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v5, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 8, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v8, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v2
; GFX8-NEXT:    v_and_b32_sdwa v14, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v15, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v16, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v4, v4, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v14
; GFX8-NEXT:    v_or_b32_e32 v5, v2, v0
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v16
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v15
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v3, v9
; GFX8-NEXT:    v_or_b32_e32 v2, v4, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v12
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[4:7], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    v_mov_b32_e32 v8, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v19, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v19
; GFX7-NEXT:    v_and_b32_e32 v2, v2, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v3, v8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v19
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v19
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 8, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 8, v6
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_and_b32_e32 v10, s0, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 24, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v16, 8, v7
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_and_b32_e32 v11, s0, v11
; GFX7-NEXT:    v_and_b32_e32 v13, s0, v13
; GFX7-NEXT:    v_and_b32_e32 v4, s0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v5, s0, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 24, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v17, 16, v7
; GFX7-NEXT:    v_and_b32_e32 v14, v14, v8
; GFX7-NEXT:    v_and_b32_e32 v16, v16, v8
; GFX7-NEXT:    v_and_b32_e32 v6, s0, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v18, 24, v7
; GFX7-NEXT:    v_and_b32_e32 v17, v17, v8
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX7-NEXT:    v_and_b32_e32 v7, v7, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX7-NEXT:    v_or_b32_e32 v1, v4, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v13
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 8, v16
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 24, v15
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v14
; GFX7-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX7-NEXT:    v_or_b32_e32 v6, v7, v16
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v12
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v17
; GFX7-NEXT:    v_lshlrev_b32_e32 v18, 24, v18
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v15
; GFX7-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v19
; GFX7-NEXT:    v_or_b32_e32 v5, v5, v18
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v5, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v3, v6, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v4, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v5, v2, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_and_b32_e32 v2, v2, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, v7, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v1, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, v9, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v12, 16, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v2, v3, v8
; GFX7-NEXT:    v_and_b32_e32 v3, v11, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, v12, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 8, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 16, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v16, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v3, v4, v8
; GFX7-NEXT:    v_and_b32_e32 v4, v14, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v5, v8
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_and_b32_e32 v4, v15, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v16
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}
