# Copyright 2012-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

""":class:`NodeKey` model."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'NodeKey',
    ]

from django.db.models import (
    CharField,
    Model,
    OneToOneField,
)
from maasserver.models.cleansave import CleanSave
from metadataserver import DefaultMeta
from piston.models import (
    KEY_SIZE,
    Token,
)


class NodeKey(CleanSave, Model):
    """Associate a Node with its OAuth (token) key.

    :ivar node: A Node.
    :ivar key: A key, to be used by `node` for logging in.  The key belongs
        to the maas-init-node user.
    """

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""

    node = OneToOneField(
        'maasserver.Node', null=False, editable=False)
    token = OneToOneField(
        Token, null=False, editable=False)
    key = CharField(
        max_length=KEY_SIZE, null=False, editable=False, unique=True)
