/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB)

#include "JSDOMURL.h"

#include "DOMURL.h"
#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMURL);

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMURLPrototypeTableValues[3] =
{
    { "createObjectURL", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMURLPrototypeFunctionCreateObjectURL), (intptr_t)1 THUNK_GENERATOR(0) },
    { "revokeObjectURL", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMURLPrototypeFunctionRevokeObjectURL), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMURLPrototypeTable = { 4, 3, JSDOMURLPrototypeTableValues, 0 };
static const HashTable* getJSDOMURLPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMURLPrototypeTable);
}

const ClassInfo JSDOMURLPrototype::s_info = { "DOMURLPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSDOMURLPrototypeTable };

JSObject* JSDOMURLPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMURL>(exec, globalObject);
}

bool JSDOMURLPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDOMURLPrototypeTable(exec), this, propertyName, slot);
}

bool JSDOMURLPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDOMURLPrototypeTable(exec), this, propertyName, descriptor);
}

const ClassInfo JSDOMURL::s_info = { "DOMURL", &JSDOMWrapper::s_info, 0, 0 };

JSDOMURL::JSDOMURL(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMURL> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMURL::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMURLPrototype(exec->globalData(), globalObject, JSDOMURLPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

EncodedJSValue JSC_HOST_CALL jsDOMURLPrototypeFunctionCreateObjectURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMURL::s_info))
        return throwVMTypeError(exec);
    JSDOMURL* castedThis = static_cast<JSDOMURL*>(asObject(thisValue));
    DOMURL* imp = static_cast<DOMURL*>(castedThis->impl());
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsStringOrUndefined(exec, imp->createObjectURL(blob));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMURLPrototypeFunctionRevokeObjectURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMURL::s_info))
        return throwVMTypeError(exec);
    JSDOMURL* castedThis = static_cast<JSDOMURL*>(asObject(thisValue));
    DOMURL* imp = static_cast<DOMURL*>(castedThis->impl());
    const String& url(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->revokeObjectURL(url);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMURL* impl)
{
    return wrap<JSDOMURL>(exec, globalObject, impl);
}

DOMURL* toDOMURL(JSC::JSValue value)
{
    return value.inherits(&JSDOMURL::s_info) ? static_cast<JSDOMURL*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB)
