/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service.aws;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.processors.service.HttpServiceResponseHandler;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.processors.service.aws.AwsSoapClient;
import amazon.fws.clicommando.security.SecurityKeys;
import amazon.fws.clicommando.util.ConsoleOutputControl;

public class AwsSoapCaller
extends AwsServiceCaller {
    public static final String EC2_CERT_FILE_PARAM = "EC2CertFile";
    public static final String EC2_PRIVATE_KEY_FILE_PARAM = "EC2PrivateKeyFile";

    public AwsSoapCaller(ServiceCallConfig awsCallConfig) {
        this.awsCallConfig = awsCallConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Command command) {
        ConsoleOutputControl.consoleStdout(false);
        ConsoleOutputControl.consoleStderr(false);
        try {
            CommandConfig commandConfig = command.getCurrentCommandConfig();
            this.loadSoapData(commandConfig);
            AwsSoapClient soapClient = new AwsSoapClient(this.awsCallConfig);
            soapClient.call();
            this.awsRequestUrl = this.awsCallConfig.getServiceUrl() + "\n\nBEGIN SOAP request:\n" + soapClient.getRequestBody() + "\nEND SOAP request";
            this.responseHandler = new HttpServiceResponseHandler(this.awsCallConfig.getServiceUrl(), "POST", soapClient.getHttpStatusCode(), soapClient.getResponseHeader(), soapClient.getResponseBody(), command);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ConsoleOutputControl.consoleStdout(true);
            ConsoleOutputControl.consoleStderr(true);
            throw throwable;
        }
        ConsoleOutputControl.consoleStdout(true);
        ConsoleOutputControl.consoleStderr(true);
    }

    private void loadSoapData(CommandConfig commandConfig) {
        for (SecurityKeys keys : commandConfig.getSecurityKeys()) {
            if (keys.getKeyType() != SecurityKeys.KeyType.CERT_PRIVATE_KEY) continue;
            this.awsCallConfig.setPublicSecretReference(keys.getPublicKey());
            this.awsCallConfig.setPrivateSecretReference(keys.getPrivateKey());
            return;
        }
    }
}

