/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyTemplates
extends Instruction {
    protected Expression select;
    protected WithParam[] actualParams = null;
    protected WithParam[] tunnelParams = null;
    protected boolean useCurrentMode = false;
    protected boolean useTailRecursion = false;
    protected Mode mode;
    protected boolean implicitSelect;

    protected ApplyTemplates() {
    }

    public ApplyTemplates(Expression select, boolean useCurrentMode, boolean useTailRecursion, Mode mode, boolean implicitSelect) {
        this.init(select, useCurrentMode, useTailRecursion, mode, implicitSelect);
    }

    protected void init(Expression select, boolean useCurrentMode, boolean useTailRecursion, Mode mode, boolean implicitSelect) {
        this.select = select;
        this.useCurrentMode = useCurrentMode;
        this.useTailRecursion = useTailRecursion;
        this.mode = mode;
        this.implicitSelect = implicitSelect;
        this.adoptChildExpression(select);
    }

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
    }

    @Override
    public int getInstructionNameCode() {
        return 130;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        this.select = visitor.simplify(this.select);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        WithParam.typeCheck(this.tunnelParams, visitor, contextItemType);
        try {
            this.select = visitor.typeCheck(this.select, contextItemType);
        }
        catch (XPathException e) {
            if (this.implicitSelect) {
                String code = e.getErrorCodeLocalPart();
                if ("XPTY0020".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is an atomic value");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
                if ("XPDY0002".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is undefined");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
            }
            throw e;
        }
        this.adoptChildExpression(this.select);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (this.mode != null && this.mode.isStreamable()) {
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            return opt.makeStreamingApplyTemplates(this);
        }
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.apply(context, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return this.apply(context, this.useTailRecursion);
    }

    protected TailCall apply(XPathContext context, boolean returnTailCall) throws XPathException {
        Mode thisMode = this.mode;
        if (this.useCurrentMode) {
            thisMode = context.getCurrentMode();
        }
        ParameterSet params = ApplyTemplates.assembleParams(context, this.actualParams);
        ParameterSet tunnels = ApplyTemplates.assembleTunnelParams(context, this.tunnelParams);
        if (returnTailCall) {
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.select, context, 1), thisMode, params, tunnels, c2, this.getLocationId());
        }
        SequenceIterator iter = this.select.iterate(context);
        if (iter instanceof EmptyIterator) {
            return null;
        }
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        try {
            for (TailCall tc = ApplyTemplates.applyTemplates(iter, thisMode, params, tunnels, c2, this.getLocationId()); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (StackOverflowError e) {
            XPathException err = new XPathException("Too many nested apply-templates calls. The stylesheet may be looping.");
            err.setErrorCode("SXLM0001");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        return null;
    }

    public static TailCall applyTemplates(SequenceIterator iterator, Mode mode, ParameterSet parameters, ParameterSet tunnelParameters, XPathContextMajor context, int locationId) throws XPathException {
        Controller controller = context.getController();
        TailCall tc = null;
        if (controller.isTracing()) {
            NodeInfo node;
            context.setCurrentIterator(iterator);
            context.setCurrentMode(mode);
            while ((node = (NodeInfo)iterator.next()) != null) {
                while (tc != null) {
                    tc = tc.processLeavingTail();
                }
                Rule rule = mode.getRule(node, context);
                if (rule == null) {
                    ApplyTemplates.defaultAction(node, parameters, tunnelParameters, context, locationId);
                    continue;
                }
                Template template = (Template)rule.getAction();
                TraceListener traceListener = controller.getTraceListener();
                context.setLocalParameters(parameters);
                context.setTunnelParameters(tunnelParameters);
                context.openStackFrame(template.getStackFrameMap());
                context.setOriginatingConstructType(2008);
                context.setCurrentTemplateRule(rule);
                traceListener.startCurrentItem(node);
                tc = template.applyLeavingTail(context);
                traceListener.endCurrentItem(node);
            }
        } else {
            context.setCurrentIterator(iterator);
            context.setCurrentMode(mode);
            boolean lookahead = (iterator.getProperties() & 4) != 0;
            Template previousTemplate = null;
            while (true) {
                NodeInfo node;
                if (tc != null) {
                    if (!lookahead || ((LookaheadIterator)iterator).hasNext()) {
                        while ((tc = tc.processLeavingTail()) != null) {
                        }
                    }
                    break;
                }
                if ((node = (NodeInfo)iterator.next()) == null) break;
                Rule rule = mode.getRule(node, context);
                if (rule == null) {
                    ApplyTemplates.defaultAction(node, parameters, tunnelParameters, context, locationId);
                    continue;
                }
                Template template = (Template)rule.getAction();
                if (template != previousTemplate) {
                    previousTemplate = template;
                    context.openStackFrame(template.getStackFrameMap());
                    context.setLocalParameters(parameters);
                    context.setTunnelParameters(tunnelParameters);
                }
                context.setCurrentTemplateRule(rule);
                tc = template.applyLeavingTail(context);
            }
        }
        return tc;
    }

    public static void defaultAction(NodeInfo node, ParameterSet parameters, ParameterSet tunnelParams, XPathContext context, int locationId) throws XPathException {
        switch (node.getNodeKind()) {
            case 1: 
            case 9: {
                AxisIterator iter = node.iterateAxis((byte)3);
                XPathContextMajor c2 = context.newContext();
                c2.setOriginatingConstructType(2010);
                for (TailCall tc = ApplyTemplates.applyTemplates(iter, context.getCurrentMode(), parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                }
                return;
            }
            case 2: 
            case 3: {
                context.getReceiver().characters(node.getStringValueCS(), locationId, 0);
                return;
            }
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        list.add(this.select);
        WithParam.getXPathExpressions(this.actualParams, list);
        WithParam.getXPathExpressions(this.tunnelParams, list);
        return list.iterator();
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child instanceof WithParam;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        return found;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public boolean isImplicitSelect() {
        return this.implicitSelect;
    }

    public boolean useTailRecursion() {
        return this.useTailRecursion;
    }

    public boolean usesCurrentMode() {
        return this.useCurrentMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this, this.select, offer);
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("applyTemplates");
        if (this.mode != null && !this.mode.isDefaultMode()) {
            out.emitAttribute("mode", this.mode.getModeName().getDisplayName());
        }
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private static class ApplyTemplatesPackage
    implements TailCall {
        private ValueRepresentation selectedNodes;
        private Mode mode;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContextMajor evaluationContext;
        private int locationId;

        ApplyTemplatesPackage(ValueRepresentation selectedNodes, Mode mode, ParameterSet params, ParameterSet tunnelParams, XPathContextMajor context, int locationId) {
            this.selectedNodes = selectedNodes;
            this.mode = mode;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = context;
            this.locationId = locationId;
        }

        public TailCall processLeavingTail() throws XPathException {
            return ApplyTemplates.applyTemplates(Value.getIterator(this.selectedNodes), this.mode, this.params, this.tunnelParams, this.evaluationContext, this.locationId);
        }
    }
}

