#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Leisure Suit Larry 7
# send your bug reports to contact@dotslashplay.it
###

script_version=20230216.1

GAME_ID='leisure-suit-larry-7'
GAME_NAME='Leisure Suit Larry 7: Love for Sail!'

ARCHIVE_BASE_EN_0='leisure_suit_larry_love_for_sail_en_gog_1_20744.sh'
ARCHIVE_BASE_EN_0_MD5='38862663d3dd9298acdf3fcc5f4bd88d'
ARCHIVE_BASE_EN_0_TYPE='mojosetup'
ARCHIVE_BASE_EN_0_SIZE='680000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog20744'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/leisure_suit_larry_love_for_sail'

ARCHIVE_BASE_FR_0='leisure_suit_larry_love_for_sail_fr_gog_1_20744.sh'
ARCHIVE_BASE_FR_0_MD5='1386fa634b48ecb5af83fdab12e99c2d'
ARCHIVE_BASE_FR_0_TYPE='mojosetup'
ARCHIVE_BASE_FR_0_SIZE='630000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog20744'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/leisure_suit_larry_love_for_sail'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
drivers
movie
music
patches
version
resource.???
*.000
*.bmp
*.csc
*.dll
*.err
*.exe
*.inf'
CONTENT_DOC_MAIN_FILES='
manual.pdf'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='sci:lsl7'
APP_MAIN_ICON='lsl7.ico'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_GOG_EN="${GAME_ID}-en"
PKG_MAIN_ID_GOG_FR="${GAME_ID}-fr"
PKG_MAIN_PROVIDE="$PKG_MAIN_ID"
PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract data from game

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	tolower .
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
