#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The House of Da Vinci
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220217.4

# Set game-specific variables

GAME_ID='the-house-of-da-vinci'
GAME_NAME='The House of Da Vinci'

ARCHIVE_BASE_0='setup_the_house_of_da_vinci_1.0.3_(64bit)_(52072).exe'
ARCHIVE_BASE_0_MD5='2cf6dce4524fe1b2ce1429f19438c38f'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_the_house_of_da_vinci_1.0.3_(64bit)_(52072)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3b3e636a1697fa84161b57fc18bfacba'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2700000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog52072'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_house_of_da_vinci'

UNITY3D_NAME='the house of da vinci'

CONTENT_PATH_DEFAULT='the house of da vinci'
ARCHIVE_GAME_BIN_FILES='
the?house?of?da?vinci.exe
the?house?of?da?vinci_data/mono
the?house?of?da?vinci_data/plugins
unityplayer.dll'
ARCHIVE_GAME_DATA_FILES='
the?house?of?da?vinci_data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Blue Brain Games/The House of da Vinci'
DATA_DIRS='./userdata/Profiles'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
