#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40,000: Dakka Squadron
# send your bug reports to contact@dotslashplay.it
###

script_version=20221204.4

GAME_ID='warhammer-40k-dakka-squadron'
GAME_NAME='Warhammer 40,000: Dakka Squadron'

ARCHIVE_BASE_0='setup_warhammer_40000_dakka_squadron_-_flyboyz_edition_1.154277.shipping_(64bit)_(46795).exe'
ARCHIVE_BASE_0_MD5='746ce7f112d089a2aca8dd6d4458dd26'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_warhammer_40000_dakka_squadron_-_flyboyz_edition_1.154277.shipping_(64bit)_(46795)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='f32a0390b27c406063fcf7ad3bff4655'
ARCHIVE_BASE_0_PART2='setup_warhammer_40000_dakka_squadron_-_flyboyz_edition_1.154277.shipping_(64bit)_(46795)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='9c978a8867a9747039bcfceb462d0a2e'
ARCHIVE_BASE_0_PART3='setup_warhammer_40000_dakka_squadron_-_flyboyz_edition_1.154277.shipping_(64bit)_(46795)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='ffb1a9b6e5343e6cb8955d6c8814ef97'
ARCHIVE_BASE_0_SIZE='9200000'
ARCHIVE_BASE_0_VERSION='1.154277-gog46795'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/warhammer_40000_dakka_squadron'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
engine
dakkagame/binaries/win64/dakkagame-win64-shipping.exe
dakkagame/plugins/onlinesubsystemgog/source/thirdparty/galaxysdk/libraries/galaxy64.dll'
ARCHIVE_GAME_DATA_FILES='
dakkagame/content'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='dakkagame/binaries/win64/dakkagame-win64-shipping.exe'
APP_MAIN_ICON='dakkagame/binaries/win64/dakkagame-win64-shipping.exe'

WINE_DIRECT3D_RENDERER='dxvk'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/Local/DakkaGame/Saved'
USER_PERSISTENT_DIRECTORIES='
userdata/Config
userdata/SaveGames'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_ARCH='gst-plugins-good gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-plugins/gst-plugins-good media-plugins/gst-plugins-libav'

# Work around a crash related to shaders compilation
# Without these native libraries, the games crash with the following error:
# SlateD3DShaders::CompileShader() - D3DCompilerFunc Result: DXGI_ERROR_80004005

APP_WINETRICKS="$APP_WINETRICKS d3dcompiler_43 d3dcompiler_47"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
