#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# Kind Words
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220417.1

# Set game-specific variables

GAME_ID='kind-words'
GAME_NAME='Kind Words'

ARCHIVE_BASE_1='kind-words-linux-64-67.zip'
ARCHIVE_BASE_1_MD5='c4cfc5e184cba2bb19964ae429c92966'
ARCHIVE_BASE_1_SIZE='290000'
ARCHIVE_BASE_1_VERSION='2022.04.01-itch.67'
ARCHIVE_BASE_1_URL='https://popcannibal.itch.io/kindwords'

ARCHIVE_BASE_0='kind-words-linux-64-66.zip'
ARCHIVE_BASE_0_MD5='e15ca776e2c5da2f3e33f03aea754730'
ARCHIVE_BASE_0_SIZE='290000'
ARCHIVE_BASE_0_VERSION='2021.09.10-itch.66'

UNITY3D_NAME='Kind Words'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
Kind?Words.x86_64
Kind?Words_Data/MonoBleedingEdge
Kind?Words_Data/Plugins
UnityPlayer.so'
ARCHIVE_GAME_DATA_FILES='
Kind?Words_Data'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
