#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (main expansions):
# - Utopia
# - Apocalypse
# - MegaCorp
# - Federations
# - Nemesis
# - Overlord
# - Galactic Paragons
# - Astral Planes
###

script_version=20240127.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_UTOPIA='utopia'
EXPANSION_NAME_UTOPIA='Utopia'

EXPANSION_ID_APOCALYPSE='apocalypse'
EXPANSION_NAME_APOCALYPSE='Apocalypse'

EXPANSION_ID_MEGACORP='megacorp'
EXPANSION_NAME_MEGACORP='MegaCorp'

EXPANSION_ID_FEDERATIONS='federations'
EXPANSION_NAME_FEDERATIONS='Federations'

EXPANSION_ID_NEMESIS='nemesis'
EXPANSION_NAME_NEMESIS='Nemesis'

EXPANSION_ID_OVERLORD='overlord'
EXPANSION_NAME_OVERLORD='Overlord'

EXPANSION_ID_PARAGONS='galactic-paragons'
EXPANSION_NAME_PARAGONS='Galactic Paragons'

EXPANSION_ID_PLANES='astral-planes'
EXPANSION_NAME_PLANES='Astral Planes'

# Archives

## Utopia

ARCHIVE_BASE_UTOPIA_47_NAME='stellaris_utopia_3_10_4_70670.sh'
ARCHIVE_BASE_UTOPIA_47_MD5='34740602274bd7cb248a25dbcf68ae50'
ARCHIVE_BASE_UTOPIA_47_SIZE='75007'
ARCHIVE_BASE_UTOPIA_47_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_UTOPIA_47_URL='https://www.gog.com/game/stellaris_utopia'

ARCHIVE_BASE_UTOPIA_46_NAME='stellaris_utopia_3_10_4_69706.sh'
ARCHIVE_BASE_UTOPIA_46_MD5='b941854d72b3941de2e9a2a5c0bd09f5'
ARCHIVE_BASE_UTOPIA_46_SIZE='75007'
ARCHIVE_BASE_UTOPIA_46_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_UTOPIA_45_NAME='stellaris_utopia_3_10_3_69539.sh'
ARCHIVE_BASE_UTOPIA_45_MD5='28ad8fb133f7274e9094e68290c2bf4a'
ARCHIVE_BASE_UTOPIA_45_SIZE='75328'
ARCHIVE_BASE_UTOPIA_45_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_UTOPIA_44_NAME='stellaris_utopia_3_10_2_69346.sh'
ARCHIVE_BASE_UTOPIA_44_MD5='de3da13d66cae59773672e8174b37ba6'
ARCHIVE_BASE_UTOPIA_44_SIZE='75328'
ARCHIVE_BASE_UTOPIA_44_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_UTOPIA_43_NAME='stellaris_utopia_3_10_1_69202.sh'
ARCHIVE_BASE_UTOPIA_43_MD5='09cd47f044d34cfdde5ef304ac98275d'
ARCHIVE_BASE_UTOPIA_43_SIZE='75324'
ARCHIVE_BASE_UTOPIA_43_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_UTOPIA_42_NAME='stellaris_utopia_3_10_0_2_68987.sh'
ARCHIVE_BASE_UTOPIA_42_MD5='56e133c664fa914c20470499c27d1151'
ARCHIVE_BASE_UTOPIA_42_SIZE='75328'
ARCHIVE_BASE_UTOPIA_42_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_UTOPIA_41_NAME='stellaris_utopia_3_9_3_68314.sh'
ARCHIVE_BASE_UTOPIA_41_MD5='b720f9ac6deec5dda989e0b52c2cee80'
ARCHIVE_BASE_UTOPIA_41_SIZE='75324'
ARCHIVE_BASE_UTOPIA_41_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_UTOPIA_38_NAME='stellaris_utopia_3_8_4_1_65337.sh'
ARCHIVE_BASE_UTOPIA_38_MD5='f37db816affaea32fa037afcf05e6f5c'
ARCHIVE_BASE_UTOPIA_38_SIZE='76000'
ARCHIVE_BASE_UTOPIA_38_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_UTOPIA_34_NAME='stellaris_utopia_3_7_4_63489.sh'
ARCHIVE_BASE_UTOPIA_34_MD5='757c0a5000d03c0c977ea3feb4ac4bec'
ARCHIVE_BASE_UTOPIA_34_SIZE='76000'
ARCHIVE_BASE_UTOPIA_34_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_UTOPIA_31_NAME='stellaris_utopia_3_6_1_60754.sh'
ARCHIVE_BASE_UTOPIA_31_MD5='6942f80fac13261e2de34e350d96e6b8'
ARCHIVE_BASE_UTOPIA_31_SIZE='76000'
ARCHIVE_BASE_UTOPIA_31_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_UTOPIA_29_NAME='stellaris_utopia_3_5_3_59410.sh'
ARCHIVE_BASE_UTOPIA_29_MD5='b71a7c123fa029a65fdeee0f46112560'
ARCHIVE_BASE_UTOPIA_29_SIZE='76000'
ARCHIVE_BASE_UTOPIA_29_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_UTOPIA_27_NAME='stellaris_utopia_3_4_5_56913.sh'
ARCHIVE_BASE_UTOPIA_27_MD5='c78bbd8859e22b93534f8aeec16ef08f'
ARCHIVE_BASE_UTOPIA_27_SIZE='76000'
ARCHIVE_BASE_UTOPIA_27_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_UTOPIA_23_NAME='stellaris_utopia_3_3_4_54421.sh'
ARCHIVE_BASE_UTOPIA_23_MD5='9b4715a94ffdca001ff56e6e6d9a807d'
ARCHIVE_BASE_UTOPIA_23_SIZE='76000'
ARCHIVE_BASE_UTOPIA_23_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_UTOPIA_19_NAME='stellaris_utopia_3_2_1_1_51520.sh'
ARCHIVE_BASE_UTOPIA_19_MD5='bb6b18eabd4e45d846468e1c38d2e7ea'
ARCHIVE_BASE_UTOPIA_19_SIZE='76000'
ARCHIVE_BASE_UTOPIA_19_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_UTOPIA_18_NAME='stellaris_utopia_3_1_1_50008.sh'
ARCHIVE_BASE_UTOPIA_18_MD5='129501ad6bf862bc04aa775f6538e7fe'
ARCHIVE_BASE_UTOPIA_18_SIZE='76000'
ARCHIVE_BASE_UTOPIA_18_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_UTOPIA_17_NAME='stellaris_utopia_3_0_3_47193.sh'
ARCHIVE_BASE_UTOPIA_17_MD5='0987db58e4cb8629714bbe9b2d01906e'
ARCHIVE_BASE_UTOPIA_17_SIZE='76000'
ARCHIVE_BASE_UTOPIA_17_VERSION='3.0.3-gog47193'

## Apocalypse

ARCHIVE_BASE_APOCALYPSE_37_NAME='stellaris_apocalypse_3_10_4_70670.sh'
ARCHIVE_BASE_APOCALYPSE_37_MD5='77856badbd6716a8d4b2b7c3d50dac7d'
ARCHIVE_BASE_APOCALYPSE_37_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_37_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_APOCALYPSE_37_URL='https://www.gog.com/game/stellaris_apocalypse'

ARCHIVE_BASE_APOCALYPSE_36_NAME='stellaris_apocalypse_3_10_4_69706.sh'
ARCHIVE_BASE_APOCALYPSE_36_MD5='b894170308363ea56cc7d74206c67219'
ARCHIVE_BASE_APOCALYPSE_36_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_36_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_APOCALYPSE_35_NAME='stellaris_apocalypse_3_10_3_69539.sh'
ARCHIVE_BASE_APOCALYPSE_35_MD5='d4c87fe2168b68d31e4998933ed81d78'
ARCHIVE_BASE_APOCALYPSE_35_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_35_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_APOCALYPSE_34_NAME='stellaris_apocalypse_3_10_2_69346.sh'
ARCHIVE_BASE_APOCALYPSE_34_MD5='c36eb19699cec1afa1b2fde53b49f3ca'
ARCHIVE_BASE_APOCALYPSE_34_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_34_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_APOCALYPSE_33_NAME='stellaris_apocalypse_3_10_1_69202.sh'
ARCHIVE_BASE_APOCALYPSE_33_MD5='ac4266364748ada11f6119d659934617'
ARCHIVE_BASE_APOCALYPSE_33_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_33_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_APOCALYPSE_32_NAME='stellaris_apocalypse_3_10_0_2_68987.sh'
ARCHIVE_BASE_APOCALYPSE_32_MD5='84b1b5c099f9a1ade045491ec1000dc3'
ARCHIVE_BASE_APOCALYPSE_32_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_APOCALYPSE_31_NAME='stellaris_apocalypse_3_9_3_68314.sh'
ARCHIVE_BASE_APOCALYPSE_31_MD5='1e81c558321b0c494118f5eaa320a31a'
ARCHIVE_BASE_APOCALYPSE_31_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_APOCALYPSE_28_NAME='stellaris_apocalypse_3_8_4_1_65337.sh'
ARCHIVE_BASE_APOCALYPSE_28_MD5='a01fd114beedaae30f8036532aeaa3a5'
ARCHIVE_BASE_APOCALYPSE_28_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_APOCALYPSE_24_NAME='stellaris_apocalypse_3_7_4_63489.sh'
ARCHIVE_BASE_APOCALYPSE_24_MD5='635fad17d0a6dbcb51bc4bc134f7a2fc'
ARCHIVE_BASE_APOCALYPSE_24_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_APOCALYPSE_21_NAME='stellaris_apocalypse_3_6_1_60754.sh'
ARCHIVE_BASE_APOCALYPSE_21_MD5='ba7aa69bc21ddc041767975d6891c394'
ARCHIVE_BASE_APOCALYPSE_21_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_APOCALYPSE_19_NAME='stellaris_apocalypse_3_5_3_59410.sh'
ARCHIVE_BASE_APOCALYPSE_19_MD5='40e997269f2806e26c3cef5b604009e2'
ARCHIVE_BASE_APOCALYPSE_19_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_APOCALYPSE_17_NAME='stellaris_apocalypse_3_4_5_56913.sh'
ARCHIVE_BASE_APOCALYPSE_17_MD5='2294a815d331a90c2a226ea679d1b9c2'
ARCHIVE_BASE_APOCALYPSE_17_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_APOCALYPSE_13_NAME='stellaris_apocalypse_3_3_4_54421.sh'
ARCHIVE_BASE_APOCALYPSE_13_MD5='df86d7aa67f4be37822523fef72d15ee'
ARCHIVE_BASE_APOCALYPSE_13_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_APOCALYPSE_9_NAME='stellaris_apocalypse_3_2_1_1_51520.sh'
ARCHIVE_BASE_APOCALYPSE_9_MD5='0db5f6b23432efa4941f7e4e89ff9488'
ARCHIVE_BASE_APOCALYPSE_9_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_APOCALYPSE_8_NAME='stellaris_apocalypse_3_1_1_50008.sh'
ARCHIVE_BASE_APOCALYPSE_8_MD5='a4d25b308d2daf3c81fef2aef33727da'
ARCHIVE_BASE_APOCALYPSE_8_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_APOCALYPSE_7_NAME='stellaris_apocalypse_3_0_3_47193.sh'
ARCHIVE_BASE_APOCALYPSE_7_MD5='3cdf97dedf2514fbb1e9fd123cb253b7'
ARCHIVE_BASE_APOCALYPSE_7_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_7_VERSION='3.0.3-gog47193'

## MegaCorp

ARCHIVE_BASE_MEGACORP_34_NAME='stellaris_megacorp_3_10_4_70670.sh'
ARCHIVE_BASE_MEGACORP_34_MD5='c155eb5f1b6f3283e068b17574107070'
ARCHIVE_BASE_MEGACORP_34_SIZE='130614'
ARCHIVE_BASE_MEGACORP_34_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_MEGACORP_34_URL='https://www.gog.com/game/stellaris_megacorp'

ARCHIVE_BASE_MEGACORP_33_NAME='stellaris_megacorp_3_10_4_69706.sh'
ARCHIVE_BASE_MEGACORP_33_MD5='4485e8c66c997bec73f95fb6e7aba992'
ARCHIVE_BASE_MEGACORP_33_SIZE='130614'
ARCHIVE_BASE_MEGACORP_33_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_MEGACORP_32_NAME='stellaris_megacorp_3_10_3_69539.sh'
ARCHIVE_BASE_MEGACORP_32_MD5='df9e76d2d210bae53fde19e7e88742eb'
ARCHIVE_BASE_MEGACORP_32_SIZE='130940'
ARCHIVE_BASE_MEGACORP_32_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_MEGACORP_31_NAME='stellaris_megacorp_3_10_2_69346.sh'
ARCHIVE_BASE_MEGACORP_31_MD5='521df86e0279c09dac4be008f0f40dbb'
ARCHIVE_BASE_MEGACORP_31_SIZE='130940'
ARCHIVE_BASE_MEGACORP_31_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_MEGACORP_30_NAME='stellaris_megacorp_3_10_1_69202.sh'
ARCHIVE_BASE_MEGACORP_30_MD5='c1f6bdde4832e94df24d75e7ae2a5383'
ARCHIVE_BASE_MEGACORP_30_SIZE='130940'
ARCHIVE_BASE_MEGACORP_30_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_MEGACORP_29_NAME='stellaris_megacorp_3_10_0_2_68987.sh'
ARCHIVE_BASE_MEGACORP_29_MD5='55f0cfa082c93e363c44d2edabc3f881'
ARCHIVE_BASE_MEGACORP_29_SIZE='130940'
ARCHIVE_BASE_MEGACORP_29_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_MEGACORP_28_NAME='stellaris_megacorp_3_9_3_68314.sh'
ARCHIVE_BASE_MEGACORP_28_MD5='b4bf123675295aa81910698500cdd33b'
ARCHIVE_BASE_MEGACORP_28_SIZE='130940'
ARCHIVE_BASE_MEGACORP_28_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_MEGACORP_25_NAME='stellaris_megacorp_3_8_4_1_65337.sh'
ARCHIVE_BASE_MEGACORP_25_MD5='3b00aacd428ef943bbbd7a4d0e6b50b2'
ARCHIVE_BASE_MEGACORP_25_SIZE='140000'
ARCHIVE_BASE_MEGACORP_25_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_MEGACORP_21_NAME='stellaris_megacorp_3_7_4_63489.sh'
ARCHIVE_BASE_MEGACORP_21_MD5='5b9573bb4261bd177dad3f4acc74a6a1'
ARCHIVE_BASE_MEGACORP_21_SIZE='140000'
ARCHIVE_BASE_MEGACORP_21_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_MEGACORP_18_NAME='stellaris_megacorp_3_6_1_60754.sh'
ARCHIVE_BASE_MEGACORP_18_MD5='af184beefdd7efc6f2d3973bf0d50c71'
ARCHIVE_BASE_MEGACORP_18_SIZE='140000'
ARCHIVE_BASE_MEGACORP_18_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_MEGACORP_16_NAME='stellaris_megacorp_3_5_3_59410.sh'
ARCHIVE_BASE_MEGACORP_16_MD5='2a95d9ff26ed58860be33c860c41fd63'
ARCHIVE_BASE_MEGACORP_16_SIZE='140000'
ARCHIVE_BASE_MEGACORP_16_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_MEGACORP_14_NAME='stellaris_megacorp_3_4_5_56913.sh'
ARCHIVE_BASE_MEGACORP_14_MD5='893df0403e44e6e36060756740230147'
ARCHIVE_BASE_MEGACORP_14_SIZE='140000'
ARCHIVE_BASE_MEGACORP_14_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_MEGACORP_10_NAME='stellaris_megacorp_3_3_4_54421.sh'
ARCHIVE_BASE_MEGACORP_10_MD5='44fb07a81f15d0954088f4bfd88fb933'
ARCHIVE_BASE_MEGACORP_10_SIZE='140000'
ARCHIVE_BASE_MEGACORP_10_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_MEGACORP_6_NAME='stellaris_megacorp_3_2_1_1_51520.sh'
ARCHIVE_BASE_MEGACORP_6_MD5='5965b8b2b51ae9e3dca5726c5d466792'
ARCHIVE_BASE_MEGACORP_6_SIZE='140000'
ARCHIVE_BASE_MEGACORP_6_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_MEGACORP_5_NAME='stellaris_megacorp_3_1_1_50008.sh'
ARCHIVE_BASE_MEGACORP_5_MD5='fa01a1fb786ae3625437bd23275ac401'
ARCHIVE_BASE_MEGACORP_5_SIZE='140000'
ARCHIVE_BASE_MEGACORP_5_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_MEGACORP_4_NAME='stellaris_megacorp_3_0_3_47193.sh'
ARCHIVE_BASE_MEGACORP_4_MD5='8992c77ac7de034c7d3deceb656fb3f6'
ARCHIVE_BASE_MEGACORP_4_SIZE='140000'
ARCHIVE_BASE_MEGACORP_4_VERSION='3.0.3-gog47193'

## Federations

ARCHIVE_BASE_FEDERATIONS_29_NAME='stellaris_federations_3_10_4_70670.sh'
ARCHIVE_BASE_FEDERATIONS_29_MD5='00836b70d3d84d95de238c607e25e309'
ARCHIVE_BASE_FEDERATIONS_29_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_29_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_FEDERATIONS_29_URL='https://www.gog.com/game/stellaris_federations'

ARCHIVE_BASE_FEDERATIONS_28_NAME='stellaris_federations_3_10_4_69706.sh'
ARCHIVE_BASE_FEDERATIONS_28_MD5='8afa570b56dd696db6ac7dd3d8d812ae'
ARCHIVE_BASE_FEDERATIONS_28_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_28_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_FEDERATIONS_27_NAME='stellaris_federations_3_10_3_69539.sh'
ARCHIVE_BASE_FEDERATIONS_27_MD5='2f602f1a59f8850357773de50d58b531'
ARCHIVE_BASE_FEDERATIONS_27_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_27_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_FEDERATIONS_26_NAME='stellaris_federations_3_10_2_69346.sh'
ARCHIVE_BASE_FEDERATIONS_26_MD5='6093bfd50439b9d548504cfb035405c2'
ARCHIVE_BASE_FEDERATIONS_26_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_26_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_FEDERATIONS_25_NAME='stellaris_federations_3_10_1_69202.sh'
ARCHIVE_BASE_FEDERATIONS_25_MD5='2597c00c7e2e775c05a11c3b695d5db3'
ARCHIVE_BASE_FEDERATIONS_25_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_25_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_FEDERATIONS_24_NAME='stellaris_federations_3_10_0_2_68987.sh'
ARCHIVE_BASE_FEDERATIONS_24_MD5='1cb0a687189ef805856709e9f8c8e0ad'
ARCHIVE_BASE_FEDERATIONS_24_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_24_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_FEDERATIONS_23_NAME='stellaris_federations_3_9_3_68314.sh'
ARCHIVE_BASE_FEDERATIONS_23_MD5='5c2ecccea91eeeea578cd2925a5621eb'
ARCHIVE_BASE_FEDERATIONS_23_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_23_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_FEDERATIONS_20_NAME='stellaris_federations_3_8_4_1_65337.sh'
ARCHIVE_BASE_FEDERATIONS_20_MD5='6fd1449caf09cfd06baff37237aff954'
ARCHIVE_BASE_FEDERATIONS_20_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_20_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_FEDERATIONS_16_NAME='stellaris_federations_3_7_4_63489.sh'
ARCHIVE_BASE_FEDERATIONS_16_MD5='df6d008a05e26559ba65d184e52d5926'
ARCHIVE_BASE_FEDERATIONS_16_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_16_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_FEDERATIONS_13_NAME='stellaris_federations_3_6_1_60754.sh'
ARCHIVE_BASE_FEDERATIONS_13_MD5='7f86c6a7c6d13946528a58c90c7eebc8'
ARCHIVE_BASE_FEDERATIONS_13_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_13_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_FEDERATIONS_11_NAME='stellaris_federations_3_5_3_59410.sh'
ARCHIVE_BASE_FEDERATIONS_11_MD5='02dee79bf1c26ba1b1cfca5103dccdca'
ARCHIVE_BASE_FEDERATIONS_11_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_11_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_FEDERATIONS_9_NAME='stellaris_federations_3_4_5_56913.sh'
ARCHIVE_BASE_FEDERATIONS_9_MD5='96170769d5fef74f2aedf9f3fd85f656'
ARCHIVE_BASE_FEDERATIONS_9_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_9_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_FEDERATIONS_5_NAME='stellaris_federations_3_3_4_54421.sh'
ARCHIVE_BASE_FEDERATIONS_5_MD5='d0dcbaef570563bb87dd16e600e162bd'
ARCHIVE_BASE_FEDERATIONS_5_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_5_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_FEDERATIONS_1_NAME='stellaris_federations_3_2_2_51685.sh'
ARCHIVE_BASE_FEDERATIONS_1_MD5='df17fc878abd4eb957e147feb5b7e39b'
ARCHIVE_BASE_FEDERATIONS_1_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_1_VERSION='3.2.2-gog51685'

## Nemesis

ARCHIVE_BASE_NEMESIS_16_NAME='stellaris_nemesis_3_10_4_70670.sh'
ARCHIVE_BASE_NEMESIS_16_MD5='749b70150b8b77b9f905d50b641594c7'
ARCHIVE_BASE_NEMESIS_16_SIZE='38539'
ARCHIVE_BASE_NEMESIS_16_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_NEMESIS_16_URL='https://www.gog.com/game/stellaris_nemesis'

ARCHIVE_BASE_NEMESIS_15_NAME='stellaris_nemesis_3_10_4_69706.sh'
ARCHIVE_BASE_NEMESIS_15_MD5='312e8472b38288a83d3adf590794e299'
ARCHIVE_BASE_NEMESIS_15_SIZE='38539'
ARCHIVE_BASE_NEMESIS_15_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_NEMESIS_14_NAME='stellaris_nemesis_3_10_3_69539.sh'
ARCHIVE_BASE_NEMESIS_14_MD5='372e8d3daaeb61abed3c61b321faa29a'
ARCHIVE_BASE_NEMESIS_14_SIZE='38856'
ARCHIVE_BASE_NEMESIS_14_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_NEMESIS_13_NAME='stellaris_nemesis_3_10_2_69346.sh'
ARCHIVE_BASE_NEMESIS_13_MD5='7ea2f1b47be86b5ba0c756f9c708f5d0'
ARCHIVE_BASE_NEMESIS_13_SIZE='38856'
ARCHIVE_BASE_NEMESIS_13_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_NEMESIS_12_NAME='stellaris_nemesis_3_10_1_69202.sh'
ARCHIVE_BASE_NEMESIS_12_MD5='a947e9923334ef68652edbb24191e20c'
ARCHIVE_BASE_NEMESIS_12_SIZE='38856'
ARCHIVE_BASE_NEMESIS_12_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_NEMESIS_11_NAME='stellaris_nemesis_3_10_0_2_68987.sh'
ARCHIVE_BASE_NEMESIS_11_MD5='83964f37d25affd9132d6e49baf6d76b'
ARCHIVE_BASE_NEMESIS_11_SIZE='38856'
ARCHIVE_BASE_NEMESIS_11_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_NEMESIS_10_NAME='stellaris_nemesis_3_9_3_68314.sh'
ARCHIVE_BASE_NEMESIS_10_MD5='105f2c56365c3b2b3c329806e4b5272b'
ARCHIVE_BASE_NEMESIS_10_SIZE='38856'
ARCHIVE_BASE_NEMESIS_10_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NEMESIS_7_NAME='stellaris_nemesis_3_8_4_1_65337.sh'
ARCHIVE_BASE_NEMESIS_7_MD5='ea624db6ea0f9f485cb194c1358dda62'
ARCHIVE_BASE_NEMESIS_7_SIZE='40000'
ARCHIVE_BASE_NEMESIS_7_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NEMESIS_3_NAME='stellaris_nemesis_3_7_4_63489.sh'
ARCHIVE_BASE_NEMESIS_3_MD5='9fa7ca1ebe2ffb736787f18bf2611311'
ARCHIVE_BASE_NEMESIS_3_SIZE='40000'
ARCHIVE_BASE_NEMESIS_3_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NEMESIS_0_NAME='stellaris_nemesis_3_6_1_60754.sh'
ARCHIVE_BASE_NEMESIS_0_MD5='ec08053da0ef60ea42a974b26892031a'
ARCHIVE_BASE_NEMESIS_0_SIZE='40000'
ARCHIVE_BASE_NEMESIS_0_VERSION='3.6.1-gog60754'

## Overlord

ARCHIVE_BASE_OVERLORD_11_NAME='stellaris_overlord_3_10_4_70670.sh'
ARCHIVE_BASE_OVERLORD_11_MD5='a6bf968c0f6c7dc75998884b333025ec'
ARCHIVE_BASE_OVERLORD_11_SIZE='99860'
ARCHIVE_BASE_OVERLORD_11_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_OVERLORD_11_URL='https://www.gog.com/game/stellaris_overlord'

ARCHIVE_BASE_OVERLORD_10_NAME='stellaris_overlord_3_10_4_69706.sh'
ARCHIVE_BASE_OVERLORD_10_MD5='927949921df505f021d33780b53a5418'
ARCHIVE_BASE_OVERLORD_10_SIZE='99860'
ARCHIVE_BASE_OVERLORD_10_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_OVERLORD_9_NAME='stellaris_overlord_3_10_3_69539.sh'
ARCHIVE_BASE_OVERLORD_9_MD5='170a93d40a6d2cd1986e2fbaf4272735'
ARCHIVE_BASE_OVERLORD_9_SIZE='100180'
ARCHIVE_BASE_OVERLORD_9_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_OVERLORD_8_NAME='stellaris_overlord_3_10_2_69346.sh'
ARCHIVE_BASE_OVERLORD_8_MD5='28b8de70c9c213e38c04b00edf0db0b1'
ARCHIVE_BASE_OVERLORD_8_SIZE='100184'
ARCHIVE_BASE_OVERLORD_8_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_OVERLORD_7_NAME='stellaris_overlord_3_10_1_69202.sh'
ARCHIVE_BASE_OVERLORD_7_MD5='ae491975383cfcfc35da0b1b4e003cc0'
ARCHIVE_BASE_OVERLORD_7_SIZE='100180'
ARCHIVE_BASE_OVERLORD_7_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_OVERLORD_6_NAME='stellaris_overlord_3_10_0_2_68987.sh'
ARCHIVE_BASE_OVERLORD_6_MD5='031c07da495842109040c6449a2b4db4'
ARCHIVE_BASE_OVERLORD_6_SIZE='100184'
ARCHIVE_BASE_OVERLORD_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_OVERLORD_5_NAME='stellaris_overlord_3_9_3_68314.sh'
ARCHIVE_BASE_OVERLORD_5_MD5='580bcbdf375ead938c80956f27e1069d'
ARCHIVE_BASE_OVERLORD_5_SIZE='100180'
ARCHIVE_BASE_OVERLORD_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_OVERLORD_2_NAME='stellaris_overlord_3_8_4_1_65337.sh'
ARCHIVE_BASE_OVERLORD_2_MD5='e1c1700fa00f2c2d0c86ec4d7d1d63ea'
ARCHIVE_BASE_OVERLORD_2_SIZE='110000'
ARCHIVE_BASE_OVERLORD_2_VERSION='3.8.4.1-gog65337'

## Galactic Paragons

ARCHIVE_BASE_PARAGONS_11_NAME='stellaris_galactic_paragons_3_10_4_70670.sh'
ARCHIVE_BASE_PARAGONS_11_MD5='e081e220e0a862bd8adc42860b9bd1f4'
ARCHIVE_BASE_PARAGONS_11_SIZE='832'
ARCHIVE_BASE_PARAGONS_11_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_PARAGONS_11_URL='https://www.gog.com/game/stellaris_galactic_paragons'

ARCHIVE_BASE_PARAGONS_10_NAME='stellaris_galactic_paragons_3_10_4_69706.sh'
ARCHIVE_BASE_PARAGONS_10_MD5='0781905dcf4cf726b21574c74b018a94'
ARCHIVE_BASE_PARAGONS_10_SIZE='832'
ARCHIVE_BASE_PARAGONS_10_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_PARAGONS_9_NAME='stellaris_galactic_paragons_3_10_3_69539.sh'
ARCHIVE_BASE_PARAGONS_9_MD5='a2d47fb32fbdfdaad4015aac868f0729'
ARCHIVE_BASE_PARAGONS_9_SIZE='1152'
ARCHIVE_BASE_PARAGONS_9_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_PARAGONS_8_NAME='stellaris_galactic_paragons_3_10_2_69346.sh'
ARCHIVE_BASE_PARAGONS_8_MD5='4338b6764e1c76d2d08838c4b940698b'
ARCHIVE_BASE_PARAGONS_8_SIZE='1152'
ARCHIVE_BASE_PARAGONS_8_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_PARAGONS_7_NAME='stellaris_galactic_paragons_3_10_1_69202.sh'
ARCHIVE_BASE_PARAGONS_7_MD5='a51b35147b8737a83dc2c87d1e15c6e7'
ARCHIVE_BASE_PARAGONS_7_SIZE='1152'
ARCHIVE_BASE_PARAGONS_7_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_PARAGONS_6_NAME='stellaris_galactic_paragons_3_10_0_2_68987.sh'
ARCHIVE_BASE_PARAGONS_6_MD5='0a9ca705958130bf0472b47e91506afb'
ARCHIVE_BASE_PARAGONS_6_SIZE='1152'
ARCHIVE_BASE_PARAGONS_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_PARAGONS_5_NAME='stellaris_galactic_paragons_3_9_3_68314.sh'
ARCHIVE_BASE_PARAGONS_5_MD5='4e1ad6ceb7a5e3bb6d55d1bc7547954e'
ARCHIVE_BASE_PARAGONS_5_SIZE='1152'
ARCHIVE_BASE_PARAGONS_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PARAGONS_2_NAME='stellaris_galactic_paragons_3_8_4_1_65337.sh'
ARCHIVE_BASE_PARAGONS_2_MD5='e47a7ab7c264021f49b8419e1aedc580'
ARCHIVE_BASE_PARAGONS_2_SIZE='1200'
ARCHIVE_BASE_PARAGONS_2_VERSION='3.8.4.1-gog65337'

## Astral Planes

ARCHIVE_BASE_PLANES_5_NAME='stellaris_astral_planes_3_10_4_70670.sh'
ARCHIVE_BASE_PLANES_5_MD5='fab105e52dffbf0ec425d4cedf89feae'
ARCHIVE_BASE_PLANES_5_SIZE='46789'
ARCHIVE_BASE_PLANES_5_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_PLANES_5_URL='https://www.gog.com/game/stellaris_astral_planes'

ARCHIVE_BASE_PLANES_4_NAME='stellaris_astral_planes_3_10_4_69706.sh'
ARCHIVE_BASE_PLANES_4_MD5='1f13892554e3dd7f518e6c24c7588902'
ARCHIVE_BASE_PLANES_4_SIZE='46789'
ARCHIVE_BASE_PLANES_4_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_PLANES_3_NAME='stellaris_astral_planes_3_10_3_69539.sh'
ARCHIVE_BASE_PLANES_3_MD5='fa20993e9d31c987a11a32a05a10fca3'
ARCHIVE_BASE_PLANES_3_SIZE='47108'
ARCHIVE_BASE_PLANES_3_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_PLANES_2_NAME='stellaris_astral_planes_3_10_2_69346.sh'
ARCHIVE_BASE_PLANES_2_MD5='ccf3ead407701f817a64b35c5bf86e68'
ARCHIVE_BASE_PLANES_2_SIZE='47108'
ARCHIVE_BASE_PLANES_2_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_PLANES_1_NAME='stellaris_astral_planes_3_10_1_69202.sh'
ARCHIVE_BASE_PLANES_1_MD5='9c1e948d507f71c367502ad0b27b8556'
ARCHIVE_BASE_PLANES_1_SIZE='47104'
ARCHIVE_BASE_PLANES_1_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_PLANES_0_NAME='stellaris_astral_planes_3_10_0_2_68987.sh'
ARCHIVE_BASE_PLANES_0_MD5='02a08ebe68c3394d121724e3d7f2221c'
ARCHIVE_BASE_PLANES_0_SIZE='47104'
ARCHIVE_BASE_PLANES_0_VERSION='3.10.0.2-gog68987'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
