/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.ServiceCaller;
import amazon.fws.clicommando.security.SelfSignedSSLSupport;
import amazon.fws.clicommando.security.VerifyHostnameAgainstCertificate;

public abstract class AbstractScaffoldCallProcessor {
    protected ServiceCallConfig awsCallConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void callService(ServiceCaller serviceCaller, Command command) {
        block8: {
            block7: {
                try {
                    if (this.awsCallConfig.getSslEncryptionOnly()) {
                        SelfSignedSSLSupport.setHttpsTrustManager(true);
                    } else {
                        VerifyHostnameAgainstCertificate.setHttpsTrustManager(true, this.awsCallConfig);
                    }
                    serviceCaller.call(command);
                    if (serviceCaller.isError()) {
                        throw serviceCaller.getException();
                    }
                    Object var4_3 = null;
                    if (!this.awsCallConfig.getSslEncryptionOnly()) break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.awsCallConfig.getSslEncryptionOnly()) {
                        SelfSignedSSLSupport.setHttpsTrustManager(false);
                    } else {
                        VerifyHostnameAgainstCertificate.setHttpsTrustManager(false, this.awsCallConfig);
                    }
                    this.loadResultsIntoCommandConfig(serviceCaller, command.getCurrentCommandConfig());
                    throw throwable;
                }
                SelfSignedSSLSupport.setHttpsTrustManager(false);
                break block8;
            }
            VerifyHostnameAgainstCertificate.setHttpsTrustManager(false, this.awsCallConfig);
        }
        this.loadResultsIntoCommandConfig(serviceCaller, command.getCurrentCommandConfig());
    }

    protected void loadResultsIntoCommandConfig(ServiceCaller serviceCaller, CommandConfig commandConfig) {
        commandConfig.setResponse(serviceCaller.getResponse());
        commandConfig.setResponseHeaders(serviceCaller.getHeader());
        commandConfig.setRequestUrl(serviceCaller.getUrl());
    }
}

