#!/bin/sh
# This script creates '*_ext_alias.h' from '*_ext_api.h'

prefix="glx wgl gl"

for name in $prefix; do
	src="include/allegrogl/GLext/"$name"_ext_api.h"
	out="include/allegrogl/GLext/"$name"_ext_alias.h"
	prfx=`echo $name | sed 's/glx/glX/'`
	cat $src | sed -e '/^[ 	]*#/!s/[ 	]//g' | awk -F"," "BEGIN{print\"/*Automatically generated by mkalias.sh DO NOT EDIT!*/\"}
	{if (\$0 ~ /^AGL_API/) printf \"#define $prfx%s __a$prfx%s\n\",\$2,\$2;
	else print \$0}" > $out
done
