#include <Puma/CTree.h>
#include <Puma/CUnit.h>
#include <Puma/ManipCommander.h>
#include "Transformer.h"

Transformer::Transformer(Puma::ErrorStream& err) : m_Err(err) {
}
void Transformer::transform(Puma::CTree* node) {
  visit(node);
}
void Transformer::pre_visit(Puma::CTree* node) {
  if (node->NodeName() == Puma::CT_IfStmt::NodeId() ||
      node->NodeName() == Puma::CT_IfElseStmt::NodeId()) {
      insertComment(node);
  }
}
void Transformer::insertComment(Puma::CTree* node) {
  Puma::Token* token_if = node->token();
  Puma::CUnit comment(m_Err);
  comment << "/* " << token_if->location() << " */ " << Puma::endu;
  Puma::ManipCommander mc;
  mc.paste_before(token_if, &comment);
  mc.commit();
}
