#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>
#include <fstream>
#include <sys/stat.h>
#include <sys/wait.h>
#include <spawn.h>
#include <signal.h>

#include "./opensslutil.h"

int main(void) {

  std::string url, cert_file, signercert, signerkey, cadir, cafile, resp_str;
  bool res;
  url = "http://localhost:8888";
  cert_file = "./test/testCA/certs/cert.pem";
  signercert = "./test/testCA/certs/cert.pem";
  signerkey = "./test/testCA/certs/key.pem";
  cadir = "./test/trusted_certificates";

  int r;
  std::string cmd;
  std::string index_file = "id.txt";
  std::ofstream f(index_file.c_str(), std::ifstream::trunc);
  f.close();

  //command: "openssl ocsp -port 8888 -rsigner ./test/testCA/cacert.pem -rkey ./test/testCA/cakey.pem -ndays 10 -CA ./test/testCA/cacert.pem -resp_key_id -index ./id.txt";

  pid_t pid;
  char *argv[16];
  argv[0] = (char*)"/usr/bin/openssl";
  argv[1] = (char*)"ocsp";
  argv[2] = (char*)"-port";
  argv[3] = (char*)"8888";
  argv[4] = (char*)"-rsigner";
  argv[5] = (char*)"./test/testCA/cacert.pem";
  argv[6] = (char*)"-rkey";
  argv[7] = (char*)"./test/testCA/cakey.pem";
  argv[8] = (char*)"-ndays";
  argv[9] = (char*)"10";
  argv[10] = (char*)"-CA";
  argv[11] = (char*)"./test/testCA/cacert.pem";
  argv[12] = (char*)"-resp_key_id";
  argv[13] = (char*)"-index";
  argv[14] = (char*)"./id.txt";
  argv[15] = NULL;

  if(posix_spawn(&pid, argv[0], NULL, NULL, argv, NULL) != 0) {
    std::cout<<"posix_spawn failed"<<std::endl;
    exit (1);
  }
  else sleep(2); //sleep a little time to wait the openssl ocsp server being launched

/*
  if(waitpid(pid, &status, 0) != pid) {
    std::cout<<"wrong child"<<std::endl;
    exit(1);
  }
*/

  AuthN::Context context(AuthN::Context::EmptyContext);
  context.SetCAPath(cadir);
  AuthN::OpenSSL::CertContext cert_ctx(context, cert_file.c_str());
  std::string cache_file = "./test_ocsp_cache";
  AuthN::Utils::Cache cache(cache_file, &context);

  AuthN::OpenSSL::OCSPContext ocsp_ctx(&context, cert_ctx.getCert(), &cache);
  ocsp_ctx.SetRequestSigner(signercert.c_str(), signerkey.c_str());
  AuthN::Status status = ocsp_ctx.MakeOCSPRequest();
  if(status) { 
    status = ocsp_ctx.QueryOCSPResponder();
    if(status) {
      ocsp_ctx.GetOCSPResponse(resp_str);
    }
  }
  if(!status) std::cout<<status.GetDescription()<<std::endl;

 // std::cout<<"Response: "<<std::endl<<resp_str<<std::endl;

  int sig = SIGTERM;
  if(kill(pid, sig)!=0) { std::cout<<"failed to kill child"<<std::endl; exit(1); }

  return 0;
}

