#ifndef _CDO_GETOPT_H
#define _CDO_GETOPT_H

extern int CDO_optind;
extern const char *CDO_optarg;
extern int CDO_opterr;

struct cdo_option
{
  /* name of long option */
  const char *name;
  /*
   * one of no_argument, required_argument, and optional_argument:
   * whether option takes an argument
   */
  int has_arg;
  /* if not nullptr, set *flag to val when option found */
  int *flag;
  /* if flag not nullptr, value to set *flag to; else return value */
  int val;
};

constexpr int no_argument = 1;        // no argument to the option is expect
constexpr int required_argument = 2;  // an argument to the option is required
constexpr int optional_argument = 3;  // an argument to the option may be presented.

int cdo_getopt(int argc, char *const *argv, const char *optstring);
int cdo_getopt_long(int argc, char *const *argv, const char *optstring, const struct cdo_option *longopts, int *longindex);

#endif /* _CDO_GETOPT_H */
