// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUI.h"
#include "Logger.pypp.hpp"

namespace bp = boost::python;

struct Logger_wrapper : CEGUI::Logger, bp::wrapper< CEGUI::Logger > {

    Logger_wrapper( )
    : CEGUI::Logger( )
      , bp::wrapper< CEGUI::Logger >(){
        // null constructor
    
    }

    virtual void logEvent( ::CEGUI::String const & message, ::CEGUI::LoggingLevel level=::CEGUI::Standard ){
        bp::override func_logEvent = this->get_override( "logEvent" );
        func_logEvent( boost::ref(message), level );
    }

    virtual void setLogFilename( ::CEGUI::String const & filename, bool append=false ){
        bp::override func_setLogFilename = this->get_override( "setLogFilename" );
        func_setLogFilename( boost::ref(filename), append );
    }

};

void register_Logger_class(){

    { //::CEGUI::Logger
        typedef bp::class_< Logger_wrapper, bp::bases< CEGUI::Singleton< CEGUI::Logger > >, boost::noncopyable > Logger_exposer_t;
        Logger_exposer_t Logger_exposer = Logger_exposer_t( "Logger", bp::init< >("*!\n\
        \n\
           Constructor for Logger object.\n\
        *\n") );
        bp::scope Logger_scope( Logger_exposer );
        { //::CEGUI::Logger::getLoggingLevel
        
            typedef ::CEGUI::LoggingLevel ( ::CEGUI::Logger::*getLoggingLevel_function_type )(  ) const;
            
            Logger_exposer.def( 
                "getLoggingLevel"
                , getLoggingLevel_function_type( &::CEGUI::Logger::getLoggingLevel )
                , "*!\n\
               \n\
                  return the current logging level setting\n\
            \n\
               @return\n\
                  One of the LoggingLevel enumerated values specifying the current level of logging\n\
               *\n" );
        
        }
        { //::CEGUI::Logger::logEvent
        
            typedef void ( ::CEGUI::Logger::*logEvent_function_type )( ::CEGUI::String const &,::CEGUI::LoggingLevel ) ;
            
            Logger_exposer.def( 
                "logEvent"
                , bp::pure_virtual( logEvent_function_type(&::CEGUI::Logger::logEvent) )
                , ( bp::arg("message"), bp::arg("level")=::CEGUI::Standard )
                , "*!\n\
               \n\
                  Add an event to the log.\n\
            \n\
               @param message\n\
                  String object containing the message to be added to the event log.\n\
            \n\
               @param level\n\
                  LoggingLevel for this message.  If  level is greater than the current set logging level, the\
                  message is not logged.\n\
            \n\
               @return\n\
                  Nothing\n\
               *\n" );
        
        }
        { //::CEGUI::Logger::setLogFilename
        
            typedef void ( ::CEGUI::Logger::*setLogFilename_function_type )( ::CEGUI::String const &,bool ) ;
            
            Logger_exposer.def( 
                "setLogFilename"
                , bp::pure_virtual( setLogFilename_function_type(&::CEGUI::Logger::setLogFilename) )
                , ( bp::arg("filename"), bp::arg("append")=(bool)(false) )
                , "*!\n\
                \n\
                    Set the name of the log file where all subsequent log entries should be written.\n\
                    The interpretation of file name may differ depending on the concrete logger\n\
                    implementation.\n\
            \n\
                \note\n\
                    When this is called, and the log file is created, any cached log entries are\n\
                    flushed to the log file.\n\
            \n\
                @param filename\n\
                    Name of the file to put log messages.\n\
            \n\
                @param append\n\
                    - true if events should be added to the end of the current file.\n\
                    - false if the current contents of the file should be discarded.\n\
                 *\n" );
        
        }
        { //::CEGUI::Logger::setLoggingLevel
        
            typedef void ( ::CEGUI::Logger::*setLoggingLevel_function_type )( ::CEGUI::LoggingLevel ) ;
            
            Logger_exposer.def( 
                "setLoggingLevel"
                , setLoggingLevel_function_type( &::CEGUI::Logger::setLoggingLevel )
                , ( bp::arg("level") )
                , "*!\n\
               \n\
                  Set the level of logging information that will get out to the log file\n\
            \n\
               @param level\n\
                  One of the LoggingLevel enumerated values that specified the level of logging information\
                  required.\n\
            \n\
               @return\n\
                  Nothing\n\
               *\n" );
        
        }
    }

}
