/****************************************************************************
 *    lib/c/Arguments.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Arguments.h"

using namespace C;

Arguments::Arguments(Variable* variable) {
	args_ = vector<Term*>(1, variable);
	min_ = -1;
	max_ = -1;
}

Arguments::Arguments(Constant* constant) {
	args_ = vector<Term*>(1, constant);
	min_ = -1;
	max_ = -1;
}

Arguments::Arguments(Pool* pool) {
	args_ = vector<Term*>(1, pool);
	min_ = -1;
	max_ = -1;
}

Arguments::Arguments(Interval* interval) {
	args_ = vector<Term*>(1, interval);
	min_ = -1;
	max_ = -1;
}

Arguments::Arguments(Function* function) {
	args_ = vector<Term*>(1, function);
	min_ = -1;
	max_ = -1;
}


Arguments::~Arguments() { }

string Arguments::print(Printer* p) {
	string result = "";
	
	for(vector<Term*>::iterator n = args_.begin(); n != args_.end(); ++n) {
		result += (*n)->print();
		if(n != args_.end()-1) result += ",";
	}
	
	return result;
}

void Arguments::addVariable(Variable* var) {
	args_.push_back(var);
}

void Arguments::addConstant(Constant* con) {
	args_.push_back(con);
}

void Arguments::addPool(Pool* pool) {
	args_.push_back(pool);
}

void Arguments::addInterval(Interval* interval) {
	args_.push_back(interval);
}

void Arguments::addFunction(Function* function) {
	args_.push_back(function);
}

void Arguments::setMin(int min) {
	min_ = min;
}

void Arguments::setMax(int max) {
	max_ = max;
}

int Arguments::getMin() {
	return min_;
}

int Arguments::getMax() {
	return max_;
}

vector<Term*>* Arguments::getArgs() {
	return &args_;
}

/**
 * @return vector<Variable*>
 */
set<Variable*>* Arguments::getVariables() {
	set<Variable*>* vars = new set<Variable*>();

	if(!args_.empty()) {
		for(vector<Term*>::iterator n = args_.begin(); n!= args_.end(); ++n) {
			set<Variable*>* tmp_vars = (*n)->getVariables();
			
			if(!tmp_vars->empty()) {
				vars->insert(tmp_vars->begin(), tmp_vars->end());
			}
			delete tmp_vars;
		}
	}
	return vars;
}
