/* $Id: hdrl_imagelist.h,v 1.1 2013-10-16 11:31:14 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 11:31:14 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_IMAGELIST_H
#define HDRL_IMAGELIST_H

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _hdrl_imagelist_ hdrl_imagelist;

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "hdrl_imagelist_io.h"
#include "hdrl_imagelist_basic.h"
#include "hdrl_imagelist_view.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup hdrl_imagelist HDRL Image List
 *
 * This module provides functions to create, use, and destroy an
 *   @em hdrl_imagelist.
 * An @em hdrl_imagelist is an ordered list of hdrl_images.
 * 
 * @par Synopsis:
 * @code
 *   #include "hdrl_imagelist.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/

#endif 
