/* $Id: hdrl_iter.h,v 1.3 2013-10-16 16:52:20 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 16:52:20 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_ITER_H
#define HDRL_ITER_H

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>


/*-----------------------------------------------------------------------------
                                Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                            Functions prototypes
 -----------------------------------------------------------------------------*/
CPL_BEGIN_DECLS

typedef enum {
    /* next returns a imagelist */
    HDRL_ITER_IMAGELIST = 1<<0,
    /* next returns a image */
    HDRL_ITER_IMAGE = 1<<1,
    /* next returns an initialized input buffer */
    HDRL_ITER_INPUT = 1<<2,
    /* next returns an uninitialized output buffer */
    HDRL_ITER_OUTPUT = 1<<3
} hdrl_iter_type_t;

typedef struct hdrl_iter_s hdrl_iter_t;
typedef void * (hdrl_iter_next_f)(hdrl_iter_t * it);
typedef void (hdrl_iter_reset_f)(hdrl_iter_t * it);
typedef cpl_size (hdrl_iter_length_f)(hdrl_iter_t * it);

hdrl_iter_t *
hdrl_iter_init(hdrl_iter_next_f * next,
                  hdrl_iter_reset_f * reset,
                  hdrl_iter_length_f * length,
                  hdrl_iter_type_t type,
                  void * state);
void * hdrl_iter_next(hdrl_iter_t * it);

cpl_size hdrl_iter_length(hdrl_iter_t * it);

void hdrl_iter_reset(hdrl_iter_t * it);

void * hdrl_iter_state(hdrl_iter_t * it);

cpl_boolean hdrl_iter_check(hdrl_iter_t * it, hdrl_iter_type_t type);

void hdrl_iter_delete(hdrl_iter_t * it);

/*-----------------------------------------------------------------------------
             Private declarations - must not be used outside of hdrl
 -----------------------------------------------------------------------------*/

#ifdef HDRL_USE_PRIVATE

#endif

CPL_END_DECLS

#endif
