/* CT-API 1.1 Card Terminal API definition
 *
 * This file was written by Simon Richter <Simon.Richter@hogyros.de>.
 *
 * As this is an interface definition, it is the author's opinion that it
 * is not protected as a creative work.
 *
 * Public Domain fallback: If copyright protection extends to this file, it
 * is hereby placed in the public domain.
 */

#ifndef ctapi_h_
#define ctapi_h_ 1

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

int8_t CT_init(
	uint16_t logical_terminal_number,
	uint16_t physical_interface
);

int8_t CT_data(
	uint16_t logical_terminal_number,
	uint8_t *destination_address,
	uint8_t *source_address,
	uint16_t command_length,
	uint8_t *command,
	uint16_t *response_length,
	uint8_t *response
);

int8_t CT_close(
	uint16_t logical_terminal_number
);

enum
{
	OK = 0,
	ERR_INVALID = -1,
	ERR_CT = -8,
	ERR_TRANS = -10,
	ERR_MEMORY = -11,
	ERR_HOST = -127,
	ERR_HTSI = -128
};

enum
{
	HOST = 0x02,
	REMOTE_HOST = 0x05
};

enum
{
	ICC1 = 0x00,
	CT = 0x01,
	ICC2 = 0x02,
	ICC3 = 0x03,
	ICC4 = 0x04,
	ICC5 = 0x05,
	ICC6 = 0x06,
	ICC7 = 0x07,
	ICC8 = 0x08,
	ICC9 = 0x09,
	ICC10 = 0x0a,
	ICC11 = 0x0b,
	ICC12 = 0x0c,
	ICC13 = 0x0d,
	ICC14 = 0x0e
};

#ifdef __cplusplus
}
#endif

#endif
