/**************************************************************************
*   Copyright (C) 2010-2011 by Eugene V. Lyubimkin                        *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License                  *
*   (version 3 or above) as published by the Free Software Foundation.    *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU GPL                        *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
**************************************************************************/
#ifndef CUPT_INTERNAL_NATIVERESOLVER_SCORE_SEEN
#define CUPT_INTERNAL_NATIVERESOLVER_SCORE_SEEN

#include <cupt/common.hpp>
#include <cupt/fwd.hpp>

namespace cupt {
namespace internal {

using cache::BinaryVersion;
using system::Resolver;

class ScoreChange
{
	friend class ScoreManager;

	struct SubScore
	{
		enum Type { Version, New, Removal, RemovalOfEssential, RemovalOfAuto, Upgrade, Downgrade,
				UnsatisfiedRecommends, UnsatisfiedSuggests, FailedSync,
				UnsatisfiedTry, UnsatisfiedWish, UnsatisfiedCustomRequest,
				PositionPenalty, Count };
	};

	ssize_t __subscores[SubScore::Count];

	string __to_string() const;

 public:
	ScoreChange();
	void setPosition(size_t);
};

class ScoreManager
{
	shared_ptr< const Cache > __cache;
	ssize_t __subscore_multipliers[ScoreChange::SubScore::Count];
	ssize_t __preferred_version_default_pin;
	struct
	{
		ssize_t common;
		ssize_t negative;
		ssize_t priorityDowngrade;
	} p_versionFactors; // all in percents

	void p_addVersionChangeWeight(ScoreChange*, const BinaryVersion*, const BinaryVersion*) const;
	void p_addVersionChangeClass(ScoreChange*, const BinaryVersion*, const BinaryVersion*) const;
	ssize_t p_getFactoredVersionScore(ssize_t, ssize_t) const;
 public:
	ScoreManager(const Config&, const shared_ptr< const Cache >&);
	ssize_t getScoreChangeValue(const ScoreChange&) const;
	ScoreChange getVersionScoreChange(const BinaryVersion*, const BinaryVersion*) const;
	ScoreChange getUnsatisfiedRecommendsScoreChange() const;
	ScoreChange getUnsatisfiedSuggestsScoreChange() const;
	ScoreChange getUnsatisfiedSynchronizationScoreChange() const;
	ScoreChange getCustomUnsatisfiedScoreChange(Resolver::RequestImportance) const;
	string getScoreChangeString(const ScoreChange&) const;

	ssize_t qualityAdjustment;
};

}
}

#endif

