# coding: utf-8

"""
    Debian Code Search

    OpenAPI for https://codesearch.debian.net/  # noqa: E501

    OpenAPI spec version: 1.4.0
    Contact: stapelberg@debian.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from debian_codesearch_client.swagger_client.configuration import Configuration


class SearchResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "package": "str",
        "path": "str",
        "line": "int",
        "context_before": "list[str]",
        "context": "str",
        "context_after": "list[str]",
    }

    attribute_map = {
        "package": "package",
        "path": "path",
        "line": "line",
        "context_before": "context_before",
        "context": "context",
        "context_after": "context_after",
    }

    def __init__(
        self,
        package=None,
        path=None,
        line=None,
        context_before=None,
        context=None,
        context_after=None,
        _configuration=None,
    ):  # noqa: E501
        """SearchResult - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._package = None
        self._path = None
        self._line = None
        self._context_before = None
        self._context = None
        self._context_after = None
        self.discriminator = None

        self.package = package
        self.path = path
        self.line = line
        if context_before is not None:
            self.context_before = context_before
        self.context = context
        if context_after is not None:
            self.context_after = context_after

    @property
    def package(self):
        """Gets the package of this SearchResult.  # noqa: E501

        The Debian source package containing this search result, including the full Debian version number.  # noqa: E501

        :return: The package of this SearchResult.  # noqa: E501
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """Sets the package of this SearchResult.

        The Debian source package containing this search result, including the full Debian version number.  # noqa: E501

        :param package: The package of this SearchResult.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and package is None:
            raise ValueError(
                "Invalid value for `package`, must not be `None`"
            )  # noqa: E501

        self._package = package

    @property
    def path(self):
        """Gets the path of this SearchResult.  # noqa: E501

        Path to the file containing the this search result, starting with `package`.  # noqa: E501

        :return: The path of this SearchResult.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this SearchResult.

        Path to the file containing the this search result, starting with `package`.  # noqa: E501

        :param path: The path of this SearchResult.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and path is None:
            raise ValueError(
                "Invalid value for `path`, must not be `None`"
            )  # noqa: E501

        self._path = path

    @property
    def line(self):
        """Gets the line of this SearchResult.  # noqa: E501

        Line number containing the search result.  # noqa: E501

        :return: The line of this SearchResult.  # noqa: E501
        :rtype: int
        """
        return self._line

    @line.setter
    def line(self, line):
        """Sets the line of this SearchResult.

        Line number containing the search result.  # noqa: E501

        :param line: The line of this SearchResult.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and line is None:
            raise ValueError(
                "Invalid value for `line`, must not be `None`"
            )  # noqa: E501

        self._line = line

    @property
    def context_before(self):
        """Gets the context_before of this SearchResult.  # noqa: E501

        Up to 2 full lines before the search result (see `context`).  # noqa: E501

        :return: The context_before of this SearchResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._context_before

    @context_before.setter
    def context_before(self, context_before):
        """Sets the context_before of this SearchResult.

        Up to 2 full lines before the search result (see `context`).  # noqa: E501

        :param context_before: The context_before of this SearchResult.  # noqa: E501
        :type: list[str]
        """

        self._context_before = context_before

    @property
    def context(self):
        """Gets the context of this SearchResult.  # noqa: E501

        The full line containing the search result.  # noqa: E501

        :return: The context of this SearchResult.  # noqa: E501
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this SearchResult.

        The full line containing the search result.  # noqa: E501

        :param context: The context of this SearchResult.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and context is None:
            raise ValueError(
                "Invalid value for `context`, must not be `None`"
            )  # noqa: E501

        self._context = context

    @property
    def context_after(self):
        """Gets the context_after of this SearchResult.  # noqa: E501

        Up to 2 full lines after the search result (see `context`).  # noqa: E501

        :return: The context_after of this SearchResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._context_after

    @context_after.setter
    def context_after(self, context_after):
        """Sets the context_after of this SearchResult.

        Up to 2 full lines after the search result (see `context`).  # noqa: E501

        :param context_after: The context_after of this SearchResult.  # noqa: E501
        :type: list[str]
        """

        self._context_after = context_after

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(SearchResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchResult):
            return True

        return self.to_dict() != other.to_dict()
