// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool WildcardPathSegment.Match(string value)', validate parameter 'value' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PathSegments.WildcardPathSegment.Match(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PatternContextLinear.CalculateStem(FileInfoBase matchedFile)', validate parameter 'matchedFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear.CalculateStem(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileInfoBase)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PatternContextLinear.PushDirectory(DirectoryInfoBase directory)', validate parameter 'directory' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear.PushDirectory(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PatternTestResult PatternContextLinear.Test(FileInfoBase file)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test file before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileInfoBase)~Microsoft.Extensions.FileSystemGlobbing.Internal.PatternTestResult")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PatternTestResult PatternContextLinear.Test(FileInfoBase file)', validate parameter 'file' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileInfoBase)~Microsoft.Extensions.FileSystemGlobbing.Internal.PatternTestResult")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PatternContextLinearExclude.Test(DirectoryInfoBase directory)', validate parameter 'directory' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearExclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool PatternContextLinearExclude.Test(DirectoryInfoBase directory)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test directory before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearExclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PatternContextLinearInclude.Declare(Action<IPathSegment, bool> onDeclare)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't declare path segment before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearInclude.Declare(System.Action{Microsoft.Extensions.FileSystemGlobbing.Internal.IPathSegment,System.Boolean})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PatternContextLinearInclude.Declare(Action<IPathSegment, bool> onDeclare)', validate parameter 'onDeclare' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearInclude.Declare(System.Action{Microsoft.Extensions.FileSystemGlobbing.Internal.IPathSegment,System.Boolean})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PatternContextLinearInclude.Test(DirectoryInfoBase directory)', validate parameter 'directory' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearInclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool PatternContextLinearInclude.Test(DirectoryInfoBase directory)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test directory before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinearInclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PatternContextRagged.CalculateStem(FileInfoBase matchedFile)', validate parameter 'matchedFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged.CalculateStem(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileInfoBase)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PatternContextRagged.PushDirectory(DirectoryInfoBase directory)', validate parameter 'directory' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged.PushDirectory(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PatternTestResult PatternContextRagged.Test(FileInfoBase file)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test file before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileInfoBase)~Microsoft.Extensions.FileSystemGlobbing.Internal.PatternTestResult")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PatternContextRagged.TestMatchingGroup(FileSystemInfoBase value)', validate parameter 'value' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged.TestMatchingGroup(Microsoft.Extensions.FileSystemGlobbing.Abstractions.FileSystemInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool PatternContextRaggedExclude.Test(DirectoryInfoBase directory)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test directory before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRaggedExclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PatternContextRaggedInclude.Declare(Action<IPathSegment, bool> onDeclare)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't declare path segment before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRaggedInclude.Declare(System.Action{Microsoft.Extensions.FileSystemGlobbing.Internal.IPathSegment,System.Boolean})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PatternContextRaggedInclude.Declare(Action<IPathSegment, bool> onDeclare)', validate parameter 'onDeclare' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRaggedInclude.Declare(System.Action{Microsoft.Extensions.FileSystemGlobbing.Internal.IPathSegment,System.Boolean})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PatternContextRaggedInclude.Test(DirectoryInfoBase directory)', validate parameter 'directory' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRaggedInclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool PatternContextRaggedInclude.Test(DirectoryInfoBase directory)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't test directory before entering a directory.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRaggedInclude.Test(Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'IPattern PatternBuilder.Build(string pattern)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"\"..\" can be only added at the beginning of the pattern.\".", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.Patterns.PatternBuilder.Build(System.String)~Microsoft.Extensions.FileSystemGlobbing.Internal.IPattern")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'pattern'", Justification = "External repository", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Internal.Patterns.PatternBuilder.Build(System.String)~Microsoft.Extensions.FileSystemGlobbing.Internal.IPattern")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void MatcherExtensions.AddExcludePatterns(Matcher matcher, params IEnumerable<string>[] excludePatternsGroups)', validate parameter 'matcher' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.MatcherExtensions.AddExcludePatterns(Microsoft.Extensions.FileSystemGlobbing.Matcher,System.Collections.Generic.IEnumerable{System.String}[])")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void MatcherExtensions.AddIncludePatterns(Matcher matcher, params IEnumerable<string>[] includePatternsGroups)', validate parameter 'matcher' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.MatcherExtensions.AddIncludePatterns(Microsoft.Extensions.FileSystemGlobbing.Matcher,System.Collections.Generic.IEnumerable{System.String}[])")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> MatcherExtensions.GetResultsInFullPath(Matcher matcher, string directoryPath)', validate parameter 'matcher' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.MatcherExtensions.GetResultsInFullPath(Microsoft.Extensions.FileSystemGlobbing.Matcher,System.String)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void AddSourceRunner.Run(AddSourceArgs args, Func<ILogger> getLogger)', validate parameter 'args' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.AddSourceRunner.Run(NuGet.Commands.AddSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void BuildAssetsUtils.AddNuGetProperties(XDocument doc, IEnumerable<string> packageFolders, string repositoryRoot, ProjectStyle projectStyle, string assetsFilePath, bool success)', validate parameter 'doc' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.AddNuGetProperties(System.Xml.Linq.XDocument,System.Collections.Generic.IEnumerable{System.String},System.String,NuGet.ProjectModel.ProjectStyle,System.String,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XElement BuildAssetsUtils.GenerateContentFilesItem(string path, LockFileContentFile item, string packageId, string packageVersion)', validate parameter 'item' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GenerateContentFilesItem(System.String,NuGet.ProjectModel.LockFileContentFile,System.String,System.String)~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string BuildAssetsUtils.GetLanguage(string nugetLanguage)', validate parameter 'nugetLanguage' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GetLanguage(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string BuildAssetsUtils.GetMSBuildFilePathForPackageReferenceStyleProject(PackageSpec project, string extension)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GetMSBuildFilePathForPackageReferenceStyleProject(NuGet.ProjectModel.PackageSpec,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'List<MSBuildOutputFile> BuildAssetsUtils.GetMSBuildOutputFiles(PackageSpec project, LockFile assetsFile, IEnumerable<RestoreTargetGraph> targetGraphs, IReadOnlyList<NuGetv3LocalRepository> repositories, RestoreRequest request, string assetsFilePath, bool restoreSuccess, ILogger log)', validate parameter 'assetsFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GetMSBuildOutputFiles(NuGet.ProjectModel.PackageSpec,NuGet.ProjectModel.LockFile,System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreTargetGraph},System.Collections.Generic.IReadOnlyList{NuGet.Repositories.NuGetv3LocalRepository},NuGet.Commands.RestoreRequest,System.String,System.Boolean,NuGet.Common.ILogger)~System.Collections.Generic.List{NuGet.Commands.MSBuildOutputFile}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter log of method GetMSBuildOutputFiles is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GetMSBuildOutputFiles(NuGet.ProjectModel.PackageSpec,NuGet.ProjectModel.LockFile,System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreTargetGraph},System.Collections.Generic.IReadOnlyList{NuGet.Repositories.NuGetv3LocalRepository},NuGet.Commands.RestoreRequest,System.String,System.Boolean,NuGet.Common.ILogger)~System.Collections.Generic.List{NuGet.Commands.MSBuildOutputFile}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string BuildAssetsUtils.GetPathWithMacros(string absolutePath, string repositoryRoot)', validate parameter 'absolutePath' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.GetPathWithMacros(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XDocument BuildAssetsUtils.ReadExisting(string path, ILogger log)', validate parameter 'log' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.ReadExisting(System.String,NuGet.Common.ILogger)~System.Xml.Linq.XDocument")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ReadExisting' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.ReadExisting(System.String,NuGet.Common.ILogger)~System.Xml.Linq.XDocument")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void BuildAssetsUtils.WriteFiles(IEnumerable<MSBuildOutputFile> files, ILogger log)', validate parameter 'files' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.BuildAssetsUtils.WriteFiles(System.Collections.Generic.IEnumerable{NuGet.Commands.MSBuildOutputFile},NuGet.Common.ILogger)")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'LoadCertificateFromFileAsync(options)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.Commands.CertificateProvider.GetCertificatesAsync(NuGet.Commands.CertificateSourceOptions)~System.Threading.Tasks.Task{System.Security.Cryptography.X509Certificates.X509Certificate2Collection}")]
[assembly: SuppressMessage("Build", "CA1822:Member IsPackageCompatible does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.CompatibilityChecker.IsPackageCompatible(NuGet.Commands.CompatibilityChecker.CompatibilityData)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member IsPackageTypeCompatible does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.CompatibilityChecker.IsPackageTypeCompatible(NuGet.Commands.CompatibilityChecker.CompatibilityData)~System.Boolean")]
[assembly: SuppressMessage("Globalization", "CA1308:Normalize strings to uppercase", Justification = "Language folder lowercase convention for lock file", Scope = "member", Target = "~M:NuGet.Commands.ContentFileUtils.GetContentFileGroup(NuGet.Packaging.NuspecReader,System.Collections.Generic.List{NuGet.ContentModel.ContentItemGroup})~System.Collections.Generic.List{NuGet.ProjectModel.LockFileContentFile}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task DeleteRunner.Run(ISettings settings, IPackageSourceProvider sourceProvider, string packageId, string packageVersion, string source, string apiKey, bool nonInteractive, bool noServiceEndpoint, Func<string, bool> confirmFunc, ILogger logger)', validate parameter 'sourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DeleteRunner.Run(NuGet.Configuration.ISettings,NuGet.Configuration.IPackageSourceProvider,System.String,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Func{System.String,System.Boolean},NuGet.Common.ILogger)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<ExternalProjectReference> DependencyGraphSpecRequestProvider.GetExternalClosure(DependencyGraphSpec dgFile, string projectNameToRestore)', validate parameter 'dgFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DependencyGraphSpecRequestProvider.GetExternalClosure(NuGet.ProjectModel.DependencyGraphSpec,System.String)~System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ExternalProjectReference}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPackagesPath does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DependencyGraphSpecRequestProvider.GetPackagesPath(NuGet.Commands.RestoreArgs,NuGet.ProjectModel.PackageSpec)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string DiagnosticUtility.FormatGraphName(RestoreTargetGraph graph)', validate parameter 'graph' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DiagnosticUtility.FormatGraphName(NuGet.Commands.RestoreTargetGraph)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string DiagnosticUtility.FormatIdentity(LibraryIdentity identity)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DiagnosticUtility.FormatIdentity(NuGet.LibraryModel.LibraryIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string DiagnosticUtility.GetMultiLineMessage(IEnumerable<string> lines)', validate parameter 'lines' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DiagnosticUtility.GetMultiLineMessage(System.Collections.Generic.IEnumerable{System.String})~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void DisableSourceRunner.Run(DisableSourceArgs args, Func<ILogger> getLogger)', validate parameter 'getLogger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DisableSourceRunner.Run(NuGet.Commands.DisableSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DownloadDependencyResolutionResult DownloadDependencyResolutionResult.Create(NuGetFramework framework, IList<Tuple<LibraryRange, RemoteMatch>> dependencies, IList<IRemoteDependencyProvider> remoteDependencyProviders)', validate parameter 'remoteDependencyProviders' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.DownloadDependencyResolutionResult.Create(NuGet.Frameworks.NuGetFramework,System.Collections.Generic.IList{System.Tuple{NuGet.LibraryModel.LibraryRange,NuGet.DependencyResolver.RemoteMatch}},System.Collections.Generic.IList{NuGet.DependencyResolver.IRemoteDependencyProvider})~NuGet.Commands.DownloadDependencyResolutionResult")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void EnableSourceRunner.Run(EnableSourceArgs args, Func<ILogger> getLogger)', validate parameter 'args' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.EnableSourceRunner.Run(NuGet.Commands.EnableSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter listCommandLicenseUrl of method ListArgs.ListArgs(IList<string>, IList<PackageSource>, ISettings, ILogger, ListArgs.Log, bool, string, string, string, bool, bool, bool, CancellationToken) from string to System.Uri, or provide an overload to ListArgs.ListArgs(IList<string>, IList<PackageSource>, ISettings, ILogger, ListArgs.Log, bool, string, string, string, bool, bool, bool, CancellationToken) that allows listCommandLicenseUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ListArgs.#ctor(System.Collections.Generic.IList{System.String},System.Collections.Generic.IList{NuGet.Configuration.PackageSource},NuGet.Configuration.ISettings,NuGet.Common.ILogger,NuGet.Commands.ListArgs.Log,System.Boolean,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Threading.CancellationToken)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task ListCommandRunner.ExecuteCommand(ListArgs listArgs)', validate parameter 'listArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ListCommandRunner.ExecuteCommand(NuGet.Commands.ListArgs)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void ListSourceRunner.Run(ListSourceArgs args, Func<ILogger> getLogger)', validate parameter 'args' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ListSourceRunner.Run(NuGet.Commands.ListSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1822:Member ClearCacheDirectory does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LocalsCommandRunner.ClearCacheDirectory(System.String,NuGet.Commands.LocalsArgs)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void LocalsCommandRunner.ExecuteCommand(LocalsArgs localsArgs)', validate parameter 'localsArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LocalsCommandRunner.ExecuteCommand(NuGet.Commands.LocalsArgs)")]
[assembly: SuppressMessage("Build", "CA1822:Member PrintLocalResourcePath does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LocalsCommandRunner.PrintLocalResourcePath(System.String,System.String,NuGet.Commands.LocalsArgs)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LockFileTargetLibrary LockFileUtils.CreateLockFileTargetProject(GraphItem<RemoteResolveResult> graphItem, LibraryIdentity library, LibraryIncludeFlags dependencyType, RestoreTargetGraph targetGraph, ProjectStyle rootProjectStyle)', validate parameter 'library' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LockFileUtils.CreateLockFileTargetProject(NuGet.DependencyResolver.GraphItem{NuGet.DependencyResolver.RemoteResolveResult},NuGet.LibraryModel.LibraryIdentity,NuGet.LibraryModel.LibraryIncludeFlags,NuGet.Commands.RestoreTargetGraph,NuGet.ProjectModel.ProjectStyle)~NuGet.ProjectModel.LockFileTargetLibrary")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void LockFileUtils.ExcludeItems(LockFileTargetLibrary lockFileLib, LibraryIncludeFlags dependencyType)', validate parameter 'lockFileLib' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LockFileUtils.ExcludeItems(NuGet.ProjectModel.LockFileTargetLibrary,NuGet.LibraryModel.LibraryIncludeFlags)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageBuilder MSBuildProjectFactory.CreateBuilder(string basePath, NuGetVersion version, string suffix, bool buildIfNeeded, PackageBuilder builder)', validate parameter 'builder' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildProjectFactory.CreateBuilder(System.String,NuGet.Versioning.NuGetVersion,System.String,System.Boolean,NuGet.Packaging.PackageBuilder)~NuGet.Packaging.PackageBuilder")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IProjectFactory MSBuildProjectFactory.ProjectCreator(PackArgs packArgs, string path)', validate parameter 'packArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildProjectFactory.ProjectCreator(NuGet.Commands.PackArgs,System.String)~NuGet.Commands.IProjectFactory")]
[assembly: SuppressMessage("Build", "CA1801:Parameter path of method ProjectCreator is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildProjectFactory.ProjectCreator(NuGet.Commands.PackArgs,System.String)~NuGet.Commands.IProjectFactory")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void MSBuildRestoreUtility.Dump(IEnumerable<IMSBuildItem> items, ILogger log)', validate parameter 'items' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildRestoreUtility.Dump(System.Collections.Generic.IEnumerable{NuGet.Commands.IMSBuildItem},NuGet.Common.ILogger)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string MSBuildRestoreUtility.FixSourcePath(string s)', validate parameter 's' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildRestoreUtility.FixSourcePath(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool MSBuildRestoreUtility.LogErrorForClearIfInvalid(IEnumerable<string> values, string projectPath, ILogger logger)', validate parameter 'logger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildRestoreUtility.LogErrorForClearIfInvalid(System.Collections.Generic.IEnumerable{System.String},System.String,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void MSBuildRestoreUtility.NormalizePathCasings(IDictionary<string, string> paths, DependencyGraphSpec graphSpec)', validate parameter 'paths' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildRestoreUtility.NormalizePathCasings(System.Collections.Generic.IDictionary{System.String,System.String},NuGet.ProjectModel.DependencyGraphSpec)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void MSBuildRestoreUtility.RemoveMissingProjects(DependencyGraphSpec graphSpec)', validate parameter 'graphSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildRestoreUtility.RemoveMissingProjects(NuGet.ProjectModel.DependencyGraphSpec)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter projectPath of method GetProjectCacheFilePath is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.NoOpRestoreUtilities.GetProjectCacheFilePath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetToolCacheFilePath', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.NoOpRestoreUtilities.GetToolCacheFilePath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void OriginalCaseGlobalPackageFolder.ConvertLockFileToOriginalCase(LockFile lockFile)', validate parameter 'lockFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.OriginalCaseGlobalPackageFolder.ConvertLockFileToOriginalCase(NuGet.ProjectModel.LockFile)")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new LocalPackageArchiveDownloader(' before all references to it are out of scope.", Justification = "The following using statement disposes LocalPackageArchiveDownloader instance", Scope = "member", Target = "~M:NuGet.Commands.OriginalCaseGlobalPackageFolder.CopyPackagesToOriginalCaseAsync(System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreTargetGraph},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task OriginalCaseGlobalPackageFolder.CopyPackagesToOriginalCaseAsync(IEnumerable<RestoreTargetGraph> graphs, CancellationToken token)', validate parameter 'graphs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.OriginalCaseGlobalPackageFolder.CopyPackagesToOriginalCaseAsync(System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreTargetGraph},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1308:In method 'CreateNuGetLockFile', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackagesLockFileBuilder.CreateNuGetLockFile(NuGet.ProjectModel.LockFile)~NuGet.ProjectModel.PackagesLockFile")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackagesLockFile PackagesLockFileBuilder.CreateNuGetLockFile(LockFile assetsFile)', validate parameter 'assetsFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackagesLockFileBuilder.CreateNuGetLockFile(NuGet.ProjectModel.LockFile)~NuGet.ProjectModel.PackagesLockFile")]
[assembly: SuppressMessage("Build", "CA1822:Member CreateNuGetLockFile does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackagesLockFileBuilder.CreateNuGetLockFile(NuGet.ProjectModel.LockFile)~NuGet.ProjectModel.PackagesLockFile")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackageSourceProviderExtensions.ResolveAndValidateSource(IPackageSourceProvider sourceProvider, string source)', validate parameter 'sourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackageSourceProviderExtensions.ResolveAndValidateSource(NuGet.Configuration.IPackageSourceProvider,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSpecificWarningProperties PackageSpecificWarningProperties.CreatePackageSpecificWarningProperties(PackageSpec packageSpec)', validate parameter 'packageSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackageSpecificWarningProperties.CreatePackageSpecificWarningProperties(NuGet.ProjectModel.PackageSpec)~NuGet.Commands.PackageSpecificWarningProperties")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSpecificWarningProperties PackageSpecificWarningProperties.CreatePackageSpecificWarningProperties(PackageSpec packageSpec, NuGetFramework framework)', validate parameter 'packageSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackageSpecificWarningProperties.CreatePackageSpecificWarningProperties(NuGet.ProjectModel.PackageSpec,NuGet.Frameworks.NuGetFramework)~NuGet.Commands.PackageSpecificWarningProperties")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackCollectorLogger.Log(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCollectorLogger.Log(NuGet.Common.ILogMessage)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackCollectorLogger.LogAsync(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCollectorLogger.LogAsync(NuGet.Common.ILogMessage)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackCommandRunner.AddDependencyGroups(IEnumerable<LibraryDependency> dependencies, NuGetFramework framework, PackageBuilder builder)', validate parameter 'dependencies' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.AddDependencyGroups(System.Collections.Generic.IEnumerable{NuGet.LibraryModel.LibraryDependency},NuGet.Frameworks.NuGetFramework,NuGet.Packaging.PackageBuilder)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackCommandRunner.AddLibraryDependency(LibraryDependency dependency, ISet<LibraryDependency> list)', validate parameter 'list' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.AddLibraryDependency(NuGet.LibraryModel.LibraryDependency,System.Collections.Generic.ISet{NuGet.LibraryModel.LibraryDependency})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackCommandRunner.AddPackageDependency(PackageDependency dependency, ISet<PackageDependency> set)', validate parameter 'set' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.AddPackageDependency(NuGet.Packaging.Core.PackageDependency,System.Collections.Generic.ISet{NuGet.Packaging.Core.PackageDependency})")]
[assembly: SuppressMessage("Build", "CA1822:Member CheckForUnsupportedFrameworks does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.CheckForUnsupportedFrameworks(NuGet.Packaging.PackageBuilder)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackCommandRunner.GetInputFile(PackArgs packArgs)', validate parameter 'packArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.GetInputFile(NuGet.Commands.PackArgs)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackCommandRunner.GetOutputFileName(string packageId, NuGetVersion version, bool isNupkg, bool symbols, SymbolPackageFormat symbolPackageFormat, bool excludeVersion = false)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.GetOutputFileName(System.String,NuGet.Versioning.NuGetVersion,System.Boolean,System.Boolean,NuGet.Commands.SymbolPackageFormat,System.Boolean)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackCommandRunner.GetOutputPath(PackageBuilder builder, PackArgs packArgs, bool symbols = false, NuGetVersion nugetVersion = null, string outputDirectory = null, bool isNupkg = true)', validate parameter 'packArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.GetOutputPath(NuGet.Packaging.PackageBuilder,NuGet.Commands.PackArgs,System.Boolean,NuGet.Versioning.NuGetVersion,System.String,System.Boolean)~System.String")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PackCommandRunner.PrintVerbose(string outputPath, PackageBuilder builder)' passes a literal string as parameter 'message' of a call to 'void PackCommandRunner.WriteLine(string message, object arg = null)'. Retrieve the following string(s) from a resource table instead: \"Version: {0}\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.PrintVerbose(System.String,NuGet.Packaging.PackageBuilder)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackCommandRunner.SetupCurrentDirectory(PackArgs packArgs)', validate parameter 'packArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackCommandRunner.SetupCurrentDirectory(NuGet.Commands.PackArgs)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RemoveSourceRunner.Run(RemoveSourceArgs args, Func<ILogger> getLogger)', validate parameter 'getLogger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RemoveSourceRunner.Run(NuGet.Commands.RemoveSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RestoreArgs.ApplyStandardProperties(RestoreRequest request)', validate parameter 'request' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreArgs.ApplyStandardProperties(NuGet.Commands.RestoreRequest)")]
[assembly: SuppressMessage("Build", "CA1822:Member GetEffectiveFallbackPackageFolders does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreArgs.GetEffectiveFallbackPackageFolders(NuGet.Configuration.ISettings)~System.Collections.Generic.IReadOnlyList{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RestoreCollectorLogger.ApplyRestoreInputs(PackageSpec projectSpec)', validate parameter 'projectSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.ApplyRestoreInputs(NuGet.ProjectModel.PackageSpec)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool RestoreCollectorLogger.DisplayMessage(IRestoreLogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.DisplayMessage(NuGet.Common.IRestoreLogMessage)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RestoreCollectorLogger.Log(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.Log(NuGet.Common.ILogMessage)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RestoreCollectorLogger.Log(IRestoreLogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.Log(NuGet.Common.IRestoreLogMessage)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task RestoreCollectorLogger.LogAsync(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.LogAsync(NuGet.Common.ILogMessage)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task RestoreCollectorLogger.LogAsync(IRestoreLogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCollectorLogger.LogAsync(NuGet.Common.IRestoreLogMessage)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestoreCommandProviders RestoreCommandProvidersCache.GetOrCreate(string globalPackagesPath, IReadOnlyList<string> fallbackPackagesPaths, IReadOnlyList<SourceRepository> sources, SourceCacheContext cacheContext, ILogger log)', validate parameter 'fallbackPackagesPaths' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCommandProvidersCache.GetOrCreate(System.String,System.Collections.Generic.IReadOnlyList{System.String},System.Collections.Generic.IReadOnlyList{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger)~NuGet.Commands.RestoreCommandProviders")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IReadOnlyList<RestoreSummaryRequest>> RestoreRunner.GetRequests(RestoreArgs restoreContext)', validate parameter 'restoreContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreRunner.GetRequests(NuGet.Commands.RestoreArgs)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummaryRequest}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IReadOnlyList<RestoreSummary>> RestoreRunner.RunAsync(RestoreArgs restoreContext, CancellationToken token)', validate parameter 'restoreContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreRunner.RunAsync(NuGet.Commands.RestoreArgs,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummary}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IReadOnlyList<RestoreResultPair>> RestoreRunner.RunWithoutCommit(IEnumerable<RestoreSummaryRequest> restoreRequests, RestoreArgs restoreContext)', validate parameter 'restoreContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreRunner.RunWithoutCommit(System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreSummaryRequest},NuGet.Commands.RestoreArgs)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreResultPair}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestoreSummary.RestoreSummary(RestoreResult result, string inputPath, IEnumerable<string> configFiles, IEnumerable<SourceRepository> sourceRepositories, IEnumerable<RestoreLogMessage> errors)', validate parameter 'result' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreSummary.#ctor(NuGet.Commands.RestoreResult,System.String,System.Collections.Generic.IEnumerable{System.String},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RestoreSummary.Log(ILogger logger, IReadOnlyList<RestoreSummary> restoreSummaries, bool logErrors = false)', validate parameter 'logger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreSummary.Log(NuGet.Common.ILogger,System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummary},System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter log of method Create is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreTargetGraph.Create(NuGet.RuntimeModel.RuntimeGraph,System.Collections.Generic.IEnumerable{NuGet.DependencyResolver.GraphNode{NuGet.DependencyResolver.RemoteResolveResult}},NuGet.DependencyResolver.RemoteWalkContext,NuGet.Common.ILogger,NuGet.Frameworks.NuGetFramework,System.String)~NuGet.Commands.RestoreTargetGraph")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestoreTargetGraph RestoreTargetGraph.Create(RuntimeGraph runtimeGraph, IEnumerable<GraphNode<RemoteResolveResult>> graphs, RemoteWalkContext context, ILogger log, NuGetFramework framework, string runtimeIdentifier)', validate parameter 'graphs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreTargetGraph.Create(NuGet.RuntimeModel.RuntimeGraph,System.Collections.Generic.IEnumerable{NuGet.DependencyResolver.GraphNode{NuGet.DependencyResolver.RemoteResolveResult}},NuGet.DependencyResolver.RemoteWalkContext,NuGet.Common.ILogger,NuGet.Frameworks.NuGetFramework,System.String)~NuGet.Commands.RestoreTargetGraph")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<int> SignCommandRunner.ExecuteCommandAsync(SignArgs signArgs)', validate parameter 'signArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SignCommandRunner.ExecuteCommandAsync(NuGet.Commands.SignArgs)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<int> SignCommandRunner.ExecuteCommandAsync(IEnumerable<string> packagesToSign, SignPackageRequest signPackageRequest, string timestamper, ILogger logger, string outputDirectory, bool overwrite, CancellationToken token)', validate parameter 'packagesToSign' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SignCommandRunner.ExecuteCommandAsync(System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Signing.SignPackageRequest,System.String,NuGet.Common.ILogger,System.String,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1822:Member ExecuteCommandAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SignCommandRunner.ExecuteCommandAsync(System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Signing.SignPackageRequest,System.String,NuGet.Common.ILogger,System.String,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ExecuteCommandAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SignCommandRunner.ExecuteCommandAsync(System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Signing.SignPackageRequest,System.String,NuGet.Common.ILogger,System.String,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SpecValidationUtility.ValidateDependencySpec(DependencyGraphSpec spec, HashSet<string> projectsToSkip)', validate parameter 'projectsToSkip' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SpecValidationUtility.ValidateDependencySpec(NuGet.ProjectModel.DependencyGraphSpec,System.Collections.Generic.HashSet{System.String})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSpec ToolRestoreUtility.GetSpec(string projectFilePath, string id, VersionRange versionRange, NuGetFramework framework, string packagesPath, IList<string> fallbackFolders, IList<PackageSource> sources, WarningProperties projectWideWarningProperties)', validate parameter 'framework' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ToolRestoreUtility.GetSpec(System.String,System.String,NuGet.Versioning.VersionRange,NuGet.Frameworks.NuGetFramework,System.String,System.Collections.Generic.IList{System.String},System.Collections.Generic.IList{NuGet.Configuration.PackageSource},NuGet.ProjectModel.WarningProperties)~NuGet.ProjectModel.PackageSpec")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IReadOnlyList<RestoreSummaryRequest> ToolRestoreUtility.GetSubSetRequests(IEnumerable<RestoreSummaryRequest> requestSummaries)', validate parameter 'requestSummaries' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ToolRestoreUtility.GetSubSetRequests(System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreSummaryRequest})~System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummaryRequest}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LockFileTargetLibrary ToolRestoreUtility.GetToolTargetLibrary(LockFile toolLockFile, string toolId)', validate parameter 'toolLockFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ToolRestoreUtility.GetToolTargetLibrary(NuGet.ProjectModel.LockFile,System.String)~NuGet.ProjectModel.LockFileTargetLibrary")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string ToolRestoreUtility.GetUniqueName(string id, string framework, VersionRange versionRange)', validate parameter 'versionRange' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ToolRestoreUtility.GetUniqueName(System.String,System.String,NuGet.Versioning.VersionRange)~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetUniqueName', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ToolRestoreUtility.GetUniqueName(System.String,System.String,NuGet.Versioning.VersionRange)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'WarningPropertiesCollection TransitiveNoWarnUtils.CreateTransitiveWarningPropertiesCollection(IEnumerable<RestoreTargetGraph> targetGraphs, PackageSpec parentProjectSpec)', validate parameter 'targetGraphs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TransitiveNoWarnUtils.CreateTransitiveWarningPropertiesCollection(System.Collections.Generic.IEnumerable{NuGet.Commands.RestoreTargetGraph},NuGet.ProjectModel.PackageSpec)~NuGet.Commands.WarningPropertiesCollection")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'HashSet<NuGetLogCode> TransitiveNoWarnUtils.MergeCodes(HashSet<NuGetLogCode> first, HashSet<NuGetLogCode> second)', validate parameter 'first' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TransitiveNoWarnUtils.MergeCodes(System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode},System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode})~System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Dictionary<string, HashSet<NuGetLogCode>> TransitiveNoWarnUtils.MergePackageSpecificNoWarn(Dictionary<string, HashSet<NuGetLogCode>> first, Dictionary<string, HashSet<NuGetLogCode>> second)', validate parameter 'first' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TransitiveNoWarnUtils.MergePackageSpecificNoWarn(System.Collections.Generic.Dictionary{System.String,System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode}},System.Collections.Generic.Dictionary{System.String,System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode}})~System.Collections.Generic.Dictionary{System.String,System.Collections.Generic.HashSet{NuGet.Common.NuGetLogCode}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSpecificWarningProperties TransitiveNoWarnUtils.MergePackageSpecificWarningProperties(PackageSpecificWarningProperties first, PackageSpecificWarningProperties second)', validate parameter 'first' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TransitiveNoWarnUtils.MergePackageSpecificWarningProperties(NuGet.Commands.PackageSpecificWarningProperties,NuGet.Commands.PackageSpecificWarningProperties)~NuGet.Commands.PackageSpecificWarningProperties")]
[assembly: SuppressMessage("Build", "CA1822:Member CreateOwnersList does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignerActionsProvider.CreateOwnersList(System.Collections.Generic.IEnumerable{System.String})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetCertificateItemForSignature does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignerActionsProvider.GetCertificateItemForSignature(NuGet.Packaging.Signing.ISignature,System.Boolean)~NuGet.Configuration.CertificateItem")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<int> TrustedSignersCommandRunner.ExecuteCommandAsync(TrustedSignersArgs trustedSignersArgs)', validate parameter 'trustedSignersArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignersCommandRunner.ExecuteCommandAsync(NuGet.Commands.TrustedSignersArgs)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1822:Member ValidateNameExists does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignersCommandRunner.ValidateNameExists(System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<RestoreLogMessage> UnexpectedDependencyMessages.GetBumpedUpDependencies(List<IndexedRestoreTargetGraph> graphs, PackageSpec project, ISet<string> ignoreIds)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetBumpedUpDependencies(System.Collections.Generic.List{NuGet.Commands.IndexedRestoreTargetGraph},NuGet.ProjectModel.PackageSpec,System.Collections.Generic.ISet{System.String})~System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter logger of method GetDependenciesAboveUpperBounds is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetDependenciesAboveUpperBounds(System.Collections.Generic.List{NuGet.Commands.IndexedRestoreTargetGraph},NuGet.Common.ILogger)~System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<RestoreLogMessage> UnexpectedDependencyMessages.GetDependenciesAboveUpperBounds(List<IndexedRestoreTargetGraph> graphs, ILogger logger)', validate parameter 'graphs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetDependenciesAboveUpperBounds(System.Collections.Generic.List{NuGet.Commands.IndexedRestoreTargetGraph},NuGet.Common.ILogger)~System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestoreLogMessage UnexpectedDependencyMessages.GetMissingLowerBoundMessage(ResolvedDependencyKey dependency, params string[] targetGraphs)', validate parameter 'dependency' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetMissingLowerBoundMessage(NuGet.Commands.ResolvedDependencyKey,System.String[])~NuGet.Common.RestoreLogMessage")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<RestoreLogMessage> UnexpectedDependencyMessages.GetMissingLowerBounds(IEnumerable<IRestoreTargetGraph> graphs, ISet<string> ignoreIds)', validate parameter 'graphs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetMissingLowerBounds(System.Collections.Generic.IEnumerable{NuGet.Commands.IRestoreTargetGraph},System.Collections.Generic.ISet{System.String})~System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<RestoreLogMessage> UnexpectedDependencyMessages.GetProjectDependenciesMissingLowerBounds(PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.GetProjectDependenciesMissingLowerBounds(NuGet.ProjectModel.PackageSpec)~System.Collections.Generic.IEnumerable{NuGet.Common.RestoreLogMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UnexpectedDependencyMessages.LogAsync(IEnumerable<IRestoreTargetGraph> graphs, PackageSpec project, ILogger logger)', validate parameter 'logger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UnexpectedDependencyMessages.LogAsync(System.Collections.Generic.IEnumerable{NuGet.Commands.IRestoreTargetGraph},NuGet.ProjectModel.PackageSpec,NuGet.Common.ILogger)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void UpdateSourceRunner.Run(UpdateSourceArgs args, Func<ILogger> getLogger)', validate parameter 'getLogger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.UpdateSourceRunner.Run(NuGet.Commands.UpdateSourceArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<int> VerifyCommandRunner.ExecuteCommandAsync(VerifyArgs verifyArgs)', validate parameter 'verifyArgs' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.VerifyCommandRunner.ExecuteCommandAsync(NuGet.Commands.VerifyArgs)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool WarningPropertiesCollection.ApplyNoWarnProperties(IRestoreLogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.WarningPropertiesCollection.ApplyNoWarnProperties(NuGet.Common.IRestoreLogMessage)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool WarningPropertiesCollection.ApplyProjectWideNoWarnProperties(ILogMessage message, WarningProperties warningProperties)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.WarningPropertiesCollection.ApplyProjectWideNoWarnProperties(NuGet.Common.ILogMessage,NuGet.ProjectModel.WarningProperties)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool WarningPropertiesCollection.ApplyWarningProperties(IRestoreLogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.WarningPropertiesCollection.ApplyWarningProperties(NuGet.Common.IRestoreLogMessage)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property ListArgs.ListCommandLicenseUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.ListArgs.ListCommandLicenseUrl")]
[assembly: SuppressMessage("Build", "CA2227:Change 'AllowedOutputExtensionsInPackageBuildOutputFolder' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.AllowedOutputExtensionsInPackageBuildOutputFolder")]
[assembly: SuppressMessage("Build", "CA2227:Change 'AllowedOutputExtensionsInSymbolsPackageBuildOutputFolder' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.AllowedOutputExtensionsInSymbolsPackageBuildOutputFolder")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.BuildOutputFolder")]
[assembly: SuppressMessage("Build", "CA2227:Change 'ContentFiles' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.ContentFiles")]
[assembly: SuppressMessage("Build", "CA2227:Change 'SourceFiles' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.SourceFiles")]
[assembly: SuppressMessage("Build", "CA2227:Change 'TargetFrameworks' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildPackTargetArgs.TargetFrameworks")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Files' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildProjectFactory.Files")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Conditions' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildRestoreItemGroup.Conditions")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Items' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.MSBuildRestoreItemGroup.Items")]
[assembly: SuppressMessage("Build", "CA2227:Change 'FallbackRuntimes' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.FallbackRuntimes")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Inputs' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.Inputs")]
[assembly: SuppressMessage("Build", "CA2227:Change 'PreLoadedRequestProviders' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.PreLoadedRequestProviders")]
[assembly: SuppressMessage("Build", "CA2227:Change 'RequestProviders' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.RequestProviders")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Runtimes' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.Runtimes")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Sources' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreArgs.Sources")]
[assembly: SuppressMessage("Build", "CA2227:Change 'ExternalProjects' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.RestoreRequest.ExternalProjects")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Verifications' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Commands.VerifyArgs.Verifications")]
[assembly: SuppressMessage("Build", "CA1815:FilePatternMatch should override the equality (==) and inequality (!=) operators.", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.FilePatternMatch")]
[assembly: SuppressMessage("Build", "CA2231:Overload operator equals on overriding value type Equals", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.FilePatternMatch")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type PatternContextLinear should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear")]
[assembly: SuppressMessage("Build", "CA1815:FrameData should override the equality (==) and inequality (!=) operators.", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextLinear.FrameData")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type PatternContextRagged should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged")]
[assembly: SuppressMessage("Build", "CA1815:FrameData should override Equals.", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternContexts.PatternContextRagged.FrameData")]
[assembly: SuppressMessage("Build", "CA1815:PatternTestResult should override the equality (==) and inequality (!=) operators.", Justification = "<Pending>", Scope = "type", Target = "~T:Microsoft.Extensions.FileSystemGlobbing.Internal.PatternTestResult")]
[assembly: SuppressMessage("Build", "CA1067:Type NuGet.Commands.CompatibilityIssue should override Equals because it implements IEquatable<T>", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.CompatibilityIssue")]
[assembly: SuppressMessage("Build", "CA1815:ContentMetadata should override Equals.", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.ContentMetadata")]
[assembly: SuppressMessage("Build", "CA1815:OutputLibFile should override Equals.", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.OutputLibFile")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to RestoreCommandException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.RestoreCommandException")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to RestoreSpecException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.RestoreSpecException")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to SignCommandException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Commands.SignCommandException")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Commands.RestoreSummary.Log(NuGet.Common.ILogger,System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummary},System.Boolean)")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "Source code from FileSystem submodule. We don't intent to modify it since it's an archived project", Scope = "member", Target = "~M:Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoWrapper.GetDirectory(System.String)~Microsoft.Extensions.FileSystemGlobbing.Abstractions.DirectoryInfoBase")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ListClientCertRunner.Run(NuGet.Commands.ListClientCertArgs,System.Func{NuGet.Common.ILogger})")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.NoOpRestoreUtilities.VerifyRestoreOutput(NuGet.Commands.RestoreRequest,NuGet.ProjectModel.CacheFile)~System.Boolean")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.SignCommandRunner.ExecuteCommandAsync(NuGet.Commands.SignArgs)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.VulnerabilityInformationProvider.GetVulnerabilityInfoAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Model.GetVulnerabilityInfoResult}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.ListCommandRunner.PrintPackages(NuGet.Commands.ListArgs,NuGet.Common.IEnumeratorAsync{NuGet.Protocol.Core.Types.IPackageSearchMetadata})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.LockFileBuilder.EnsureUniqueLockFileLibraries(NuGet.ProjectModel.LockFile)~System.Collections.Generic.Dictionary{System.ValueTuple{System.String,NuGet.Versioning.NuGetVersion},NuGet.ProjectModel.LockFileLibrary}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.PackagesLockFileBuilder.GetPackagesLockFileVersion(NuGet.ProjectModel.LockFile)~System.Int32")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreCommand.ConcatAsString``1(System.Collections.Generic.IEnumerable{``0})~System.String")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignersCommandRunner.ValidateAndParseFingerprintAlgorithm(System.String)~NuGet.Common.HashAlgorithmName")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignersCommandRunner.ValidateAndParseV3ServiceIndexUrl(System.String)~System.Uri")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.TrustedSignersCommandRunner.ValidateListArguments(NuGet.Commands.TrustedSignersArgs)")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.VerifyCommandRunner.IsSignatureVerifyCommandSupported~System.Boolean")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.VerifyCommandRunner.ShouldExecuteVerification(NuGet.Commands.VerifyArgs,NuGet.Commands.VerifyArgs.Verification)~System.Boolean")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.VerifyCommandRunner.VerifySignatureForPackageAsync(System.String,NuGet.Common.ILogger,NuGet.Packaging.Signing.PackageSignatureVerifier,NuGet.Packaging.Signing.SignedPackageVerifierSettings)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Performance", "CA1825:Avoid zero-length array allocations", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.MSBuildProjectFrameworkUtility.GetParts(System.String)~System.String[]")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.Restore.Utility.AuditUtility.CheckPackageVulnerabilities(System.Collections.Generic.IReadOnlyList{System.Collections.Generic.IReadOnlyDictionary{System.String,System.Collections.Generic.IReadOnlyList{NuGet.Protocol.Model.PackageVulnerabilityInfo}}})")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.Restore.Utility.AuditUtility.ParseAuditLevel~NuGet.Protocol.PackageVulnerabilitySeverity")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.Restore.Utility.AuditUtility.ParseAuditMode~NuGet.Commands.Restore.Utility.AuditUtility.NuGetAuditMode")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.Restore.Utility.AuditUtility.ParseEnableValue(NuGet.ProjectModel.RestoreAuditProperties,System.String,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.Restore.Utility.AuditUtility.ReplayErrors(System.AggregateException)")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RestoreRunner.CommitAsync(NuGet.Commands.RestoreResultPair,NuGet.Commands.IRestoreProgressReporter,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Commands.RestoreSummary}")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Commands.RunnerHelper.ParseProtocolVersion(System.String)~System.Int32")]
