/*
 * Decompiled with CFR 0.152.
 */
package dumphd.gui;

import dumphd.gui.Manager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ValidatedInputDialog {
    private JDialog dialog = null;
    private JTextField valueField = null;
    private String validateErrorMsg = null;
    private boolean dialogConfirmed = false;
    private Pattern validatePattern = null;

    public ValidatedInputDialog() {
        this.dialog = new JDialog();
        this.createDialog(null, null, null, null, 16, ".*", "", "OK", "Cancel");
    }

    public ValidatedInputDialog(JDialog owner, String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
        this.dialog = new JDialog(owner);
        this.createDialog(title, message, valueName, initialValue, valueLength, validatePattern, validateErrorMsg, confirmLabel, cancelLabel);
    }

    public ValidatedInputDialog(JFrame owner, String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
        this.dialog = new JDialog(owner);
        this.createDialog(title, message, valueName, initialValue, valueLength, validatePattern, validateErrorMsg, confirmLabel, cancelLabel);
    }

    private void createDialog(String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
        this.validateErrorMsg = validateErrorMsg;
        this.validatePattern = Pattern.compile(validatePattern);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setOpaque(true);
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        contentPane.setBorder(Manager.createEmptyBorder());
        if (title != null) {
            this.dialog.setTitle(title);
        }
        if (message != null) {
            JLabel messageLabel = new JLabel(message);
            messageLabel.setAlignmentX(0.5f);
            contentPane.add(messageLabel);
            contentPane.add(Box.createRigidArea(Manager.BOX_VERTICAL_BIG_SPACING));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setAlignmentX(0.5f);
        if (valueName != null) {
            JLabel valueLabel = new JLabel(valueName);
            panel.add(valueLabel);
            panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_SMALL_SPACING));
        }
        if (initialValue != null) {
            this.valueField = new JTextField(initialValue, valueLength);
            this.valueField.selectAll();
        } else {
            this.valueField = new JTextField(valueLength);
        }
        panel.add(this.valueField);
        contentPane.add(panel);
        contentPane.add(Box.createRigidArea(Manager.BOX_VERTICAL_BIG_SPACING));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setAlignmentX(0.5f);
        ButtonListener buttonListener = new ButtonListener();
        JButton confirmButton = new JButton(confirmLabel);
        confirmButton.setActionCommand("confirm");
        confirmButton.addActionListener(buttonListener);
        JButton cancelButton = new JButton(cancelLabel);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(buttonListener);
        Manager.equalizeComponentSize(confirmButton, cancelButton);
        panel.add(confirmButton);
        panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_SMALL_SPACING));
        panel.add(cancelButton);
        contentPane.add(panel);
        this.dialog.setContentPane(contentPane);
        this.dialog.getRootPane().setDefaultButton(confirmButton);
        this.dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ValidatedInputDialog.this.valueField.requestFocusInWindow();
            }
        });
        this.dialog.pack();
    }

    public boolean show() {
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
        return this.dialogConfirmed;
    }

    public String getText() {
        return this.valueField.getText().trim();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("confirm")) {
                Matcher validator = ValidatedInputDialog.this.validatePattern.matcher(ValidatedInputDialog.this.valueField.getText().trim());
                if (validator.matches()) {
                    ValidatedInputDialog.this.dialogConfirmed = true;
                    ValidatedInputDialog.this.dialog.dispose();
                } else {
                    JOptionPane.showMessageDialog(ValidatedInputDialog.this.dialog, ValidatedInputDialog.this.validateErrorMsg, "Error", 0);
                }
            } else if (command.equals("cancel")) {
                ValidatedInputDialog.this.dialog.dispose();
            }
        }
    }
}

