e2tools development notes
=========================

This file contains a few notes for developers contributing to `e2tools`.


Source code standards
=====================

To be determined for e2tools:

   * C language standard
   * C standard library requirements
   * C sourcecode formatting rules


Release checklist
=================

This checklist outlines some basics for tagging a release on
Github. Update the list when you run into and solved issues, such as
how to properly release "make dist" generated tarballs using Github.

  * Is the `AUTHORS` file up to date?

  * Does the `NEWS.md` summarize all user visible changes?

  * Does `configure.ac` `AC_INIT` contain the correct version number?

  * Does the first line of `NEWS.md` contain the correct version number?

  * Does `make clean && make check` run?

  * Does `make distcheck` run?

  * Do the `git commit` and `git push` to the master branch on github.

  * Wait for Travis CI to finish building successfully. If the build
    fails, investigate and fix the problem.

  * Enjoy the [github releases web
    interface](https://github.com/e2tools/e2tools/releases):

      * Tag `e2tools` release `1.2.3` as `v1.2.3` beginning with the `v`.

      * Summarize the changes since the last release in the release
        notes, formatting it properly using Github flavoured
        Markdown. `NEWS.md` will come in handy here.

      * Upload the release tarball generated by `make distcheck` by
        attaching it to the Github release in the web interface. If
        that upload fails, make sure NoScript is not blocking some
        special Github release specific Javascript code.

  * Update the https://e2tools.github.io/ web page to point to the new
    Github release.

  * If necessary, adapt this release checklist and commit the updated
    `DEVELOPMENT.md` file.

  * Add a new heading to `NEWS.md` with the next release like
    `e2tools-1.2.x`, then `git commit` and `git push`.
