#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Move Review to the first character on the screen (left top)")

    def run(self):
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()
        self.env["runtime"]["CursorManager"].set_review_cursor_position(0, 0)
        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            lastChar,
        ) = char_utils.get_last_char_in_line(
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )

        char_utils.present_char_for_review(
            self.env,
            lastChar,
            interrupt=True,
            announce_capital=True,
            flush=False,
        )
        self.env["runtime"]["OutputManager"].present_text(
            _("first character in screen"), interrupt=False
        )

    def set_callback(self, callback):
        pass
