/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.codec.ByteVector;

public class LZWTreeNode {
    protected LZWTreeNode[] children = new LZWTreeNode[256];
    protected int theCode;

    public LZWTreeNode(int code) {
        this.theCode = code;
    }

    public void initialize() {
        for (int i = 0; i < 256; ++i) {
            this.children[i] = new LZWTreeNode(i);
        }
    }

    public int getCode() {
        return this.theCode;
    }

    public LZWTreeNode getChild(byte index) {
        int ndx = index;
        if (ndx < 0) {
            ndx += 256;
        }
        return this.children[ndx];
    }

    public void addChild(int index, LZWTreeNode node) {
        this.children[index] = node;
    }

    public int codeFromString(ByteVector string) {
        LZWTreeNode node = this.nodeFromString(string);
        return node == null ? -1 : node.theCode;
    }

    public LZWTreeNode nodeFromString(ByteVector string) {
        byte[] b = string.toByteArray();
        LZWTreeNode node = this;
        for (int i = 0; i < b.length; ++i) {
            int q = b[i];
            if (q < 0) {
                q += 256;
            }
            if ((node = node.children[q]) != null) continue;
            return null;
        }
        return node;
    }

    public void addTableEntry(ByteVector string, int code) {
        byte[] b = string.toByteArray();
        LZWTreeNode node = this;
        for (int i = 0; i < b.length - 1; ++i) {
            int q = b[i];
            if (q < 0) {
                q += 256;
            }
            node = node.children[q];
        }
        int q = b[b.length - 1];
        if (q < 0) {
            q += 256;
        }
        node.addChild(q, new LZWTreeNode(code));
    }
}

