/* vcard-parsing.c generated by valac 0.28.0.16-b1323, the Vala compiler
 * generated from vcard-parsing.vala, do not modify */

/*
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <bluez-test.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/small-set.h>
#include <gee.h>


#define TYPE_VCARD_PARSING_TESTS (vcard_parsing_tests_get_type ())
#define VCARD_PARSING_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VCARD_PARSING_TESTS, VcardParsingTests))
#define VCARD_PARSING_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VCARD_PARSING_TESTS, VcardParsingTestsClass))
#define IS_VCARD_PARSING_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VCARD_PARSING_TESTS))
#define IS_VCARD_PARSING_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VCARD_PARSING_TESTS))
#define VCARD_PARSING_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VCARD_PARSING_TESTS, VcardParsingTestsClass))

typedef struct _VcardParsingTests VcardParsingTests;
typedef struct _VcardParsingTestsClass VcardParsingTestsClass;
typedef struct _VcardParsingTestsPrivate VcardParsingTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VcardParsingTests {
	BluezTestTestCase parent_instance;
	VcardParsingTestsPrivate * priv;
};

struct _VcardParsingTestsClass {
	BluezTestTestCaseClass parent_class;
};


static gpointer vcard_parsing_tests_parent_class = NULL;

GType vcard_parsing_tests_get_type (void) G_GNUC_CONST;
enum  {
	VCARD_PARSING_TESTS_DUMMY_PROPERTY
};
VcardParsingTests* vcard_parsing_tests_new (void);
VcardParsingTests* vcard_parsing_tests_construct (GType object_type);
void vcard_parsing_tests_test_multiple_attributes (VcardParsingTests* self);
static void _vcard_parsing_tests_test_multiple_attributes_folks_test_case_test_method (gpointer self);
void vcard_parsing_tests_test_name_components (VcardParsingTests* self);
static void _vcard_parsing_tests_test_name_components_folks_test_case_test_method (gpointer self);
void vcard_parsing_tests_test_encoding (VcardParsingTests* self);
static void _vcard_parsing_tests_test_encoding_folks_test_case_test_method (gpointer self);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vcard_parsing_tests_test_multiple_attributes_folks_test_case_test_method (gpointer self) {
#line 30 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	vcard_parsing_tests_test_multiple_attributes ((VcardParsingTests*) self);
#line 85 "vcard-parsing.c"
}


static void _vcard_parsing_tests_test_name_components_folks_test_case_test_method (gpointer self) {
#line 31 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	vcard_parsing_tests_test_name_components ((VcardParsingTests*) self);
#line 92 "vcard-parsing.c"
}


static void _vcard_parsing_tests_test_encoding_folks_test_case_test_method (gpointer self) {
#line 32 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	vcard_parsing_tests_test_encoding ((VcardParsingTests*) self);
#line 99 "vcard-parsing.c"
}


VcardParsingTests* vcard_parsing_tests_construct (GType object_type) {
	VcardParsingTests * self = NULL;
#line 28 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	self = (VcardParsingTests*) bluez_test_test_case_construct (object_type, "VcardParsing");
#line 30 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "multiple attributes", _vcard_parsing_tests_test_multiple_attributes_folks_test_case_test_method, self);
#line 31 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "name components", _vcard_parsing_tests_test_name_components_folks_test_case_test_method, self);
#line 32 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "encoding", _vcard_parsing_tests_test_encoding_folks_test_case_test_method, self);
#line 26 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return self;
#line 115 "vcard-parsing.c"
}


VcardParsingTests* vcard_parsing_tests_new (void) {
#line 26 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return vcard_parsing_tests_construct (TYPE_VCARD_PARSING_TESTS);
#line 122 "vcard-parsing.c"
}


static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
#line 62 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return result;
#line 131 "vcard-parsing.c"
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
#line 62 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return result;
#line 140 "vcard-parsing.c"
}


void vcard_parsing_tests_test_multiple_attributes (VcardParsingTests* self) {
	BluezTestBackend* _tmp0_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	FolksIndividual* ind = NULL;
	FolksIndividual* _tmp5_ = NULL;
	FolksSmallSet* expected_phone_numbers = NULL;
	FolksSmallSet* _tmp6_ = NULL;
	FolksPhoneFieldDetails* expected_phone_fd = NULL;
	FolksPhoneFieldDetails* _tmp7_ = NULL;
	FolksPhoneFieldDetails* _tmp8_ = NULL;
	FolksPhoneFieldDetails* _tmp9_ = NULL;
	FolksPhoneFieldDetails* _tmp10_ = NULL;
	FolksPhoneFieldDetails* _tmp11_ = NULL;
	FolksPhoneFieldDetails* _tmp12_ = NULL;
	FolksPhoneFieldDetails* _tmp13_ = NULL;
	FolksPhoneFieldDetails* _tmp14_ = NULL;
	FolksSmallSet* expected_email_addresses = NULL;
	FolksSmallSet* _tmp15_ = NULL;
	FolksEmailFieldDetails* expected_email_fd = NULL;
	FolksEmailFieldDetails* _tmp16_ = NULL;
	FolksEmailFieldDetails* _tmp17_ = NULL;
	FolksEmailFieldDetails* _tmp18_ = NULL;
	FolksEmailFieldDetails* _tmp19_ = NULL;
	FolksEmailFieldDetails* _tmp20_ = NULL;
	FolksEmailFieldDetails* _tmp21_ = NULL;
	FolksSmallSet* expected_uris = NULL;
	FolksSmallSet* _tmp22_ = NULL;
	FolksUrlFieldDetails* expected_uri_fd = NULL;
	FolksUrlFieldDetails* _tmp23_ = NULL;
	FolksUrlFieldDetails* _tmp24_ = NULL;
	FolksUrlFieldDetails* _tmp25_ = NULL;
	FolksUrlFieldDetails* _tmp26_ = NULL;
	FolksUrlFieldDetails* _tmp27_ = NULL;
	FolksUrlFieldDetails* _tmp28_ = NULL;
	FolksUrlFieldDetails* _tmp29_ = NULL;
	GeeSet* _tmp30_ = NULL;
	GeeSet* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	GeeSet* _tmp33_ = NULL;
	GeeSet* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	GeeSet* _tmp36_ = NULL;
	GeeSet* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	g_return_if_fail (self != NULL);
#line 40 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp0_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 40 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	bluez_test_backend_create_simple_device_with_vcard (_tmp0_, "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:Forrest Gump\n" "TEL;TYPE=WORK,VOICE:(111) 555-1212\n" "TEL;TYPE=HOME,VOICE:(404) 555-1212\n" "EMAIL;TYPE=PREF,INTERNET:forrestgump@example.com\n" "EMAIL:test@example.com\n" "URL;TYPE=HOME:http://example.com/\n" "URL:http://forest.com/\n" "URL:https://test.com/\n" "END:VCARD\n", NULL, NULL);
#line 55 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp1_ = folks_individual_aggregator_dup ();
#line 55 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	aggregator = _tmp1_;
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp2_ = g_strdup ("Forrest Gump");
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp3_ = g_new0 (gchar*, 1 + 1);
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp3_[0] = _tmp2_;
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_ = _tmp3_;
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4__length1 = 1;
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_individuals_sync_with_timeout (aggregator, _tmp4_, 1, 5);
#line 56 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 60 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp5_ = folks_test_utils_get_individual_by_name (aggregator, "Forrest Gump");
#line 60 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp5_;
#line 62 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp6_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
#line 62 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_phone_numbers = _tmp6_;
#line 66 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp7_ = folks_phone_field_details_new ("(111) 555-1212", NULL);
#line 66 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_phone_fd = _tmp7_;
#line 67 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp8_ = expected_phone_fd;
#line 67 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp8_, "type", "work");
#line 68 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_ = expected_phone_fd;
#line 68 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp9_, "type", "voice");
#line 69 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp10_ = expected_phone_fd;
#line 69 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_phone_numbers, _tmp10_);
#line 71 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp11_ = folks_phone_field_details_new ("(404) 555-1212", NULL);
#line 71 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_phone_fd);
#line 71 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_phone_fd = _tmp11_;
#line 72 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp12_ = expected_phone_fd;
#line 72 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp12_, "type", "home");
#line 73 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp13_ = expected_phone_fd;
#line 73 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp13_, "type", "voice");
#line 74 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp14_ = expected_phone_fd;
#line 74 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_phone_numbers, _tmp14_);
#line 76 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp15_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
#line 76 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_email_addresses = _tmp15_;
#line 80 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp16_ = folks_email_field_details_new ("forrestgump@example.com", NULL);
#line 80 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_email_fd = _tmp16_;
#line 81 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp17_ = expected_email_fd;
#line 81 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp17_, "type", "pref");
#line 82 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp18_ = expected_email_fd;
#line 82 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp18_, "type", "internet");
#line 83 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp19_ = expected_email_fd;
#line 83 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_email_addresses, _tmp19_);
#line 85 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp20_ = folks_email_field_details_new ("test@example.com", NULL);
#line 85 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_email_fd);
#line 85 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_email_fd = _tmp20_;
#line 86 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp21_ = expected_email_fd;
#line 86 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_email_addresses, _tmp21_);
#line 88 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp22_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
#line 88 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_uris = _tmp22_;
#line 92 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp23_ = folks_url_field_details_new ("http://example.com/", NULL);
#line 92 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_uri_fd = _tmp23_;
#line 93 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp24_ = expected_uri_fd;
#line 93 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp24_, "type", "home");
#line 94 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp25_ = expected_uri_fd;
#line 94 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_uris, _tmp25_);
#line 96 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp26_ = folks_url_field_details_new ("http://forest.com/", NULL);
#line 96 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_uri_fd);
#line 96 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_uri_fd = _tmp26_;
#line 97 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp27_ = expected_uri_fd;
#line 97 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_uris, _tmp27_);
#line 99 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp28_ = folks_url_field_details_new ("https://test.com/", NULL);
#line 99 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_uri_fd);
#line 99 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_uri_fd = _tmp28_;
#line 100 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp29_ = expected_uri_fd;
#line 100 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) expected_uris, _tmp29_);
#line 102 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp30_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) ind);
#line 102 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp31_ = _tmp30_;
#line 102 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp32_ = folks_utils_set_afd_equal (_tmp31_, (GeeSet*) expected_phone_numbers);
#line 102 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp32_, "Utils.set_afd_equal (ind.phone_numbers, expected_phone_numbers)");
#line 103 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp33_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) ind);
#line 103 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp34_ = _tmp33_;
#line 103 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp35_ = folks_utils_set_afd_equal (_tmp34_, (GeeSet*) expected_email_addresses);
#line 103 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp35_, "Utils.set_afd_equal (ind.email_addresses,                   expected_email_addresses)");
#line 105 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp36_ = folks_url_details_get_urls ((FolksUrlDetails*) ind);
#line 105 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp37_ = _tmp36_;
#line 105 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp38_ = folks_utils_set_afd_equal (_tmp37_, (GeeSet*) expected_uris);
#line 105 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp38_, "Utils.set_afd_equal (ind.urls, expected_uris)");
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_uri_fd);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_uris);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_email_fd);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_email_addresses);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_phone_fd);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_phone_numbers);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 37 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (aggregator);
#line 365 "vcard-parsing.c"
}


void vcard_parsing_tests_test_name_components (VcardParsingTests* self) {
	BluezTestBackend* _tmp0_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	FolksIndividual* ind = NULL;
	FolksIndividual* _tmp11_ = NULL;
	FolksStructuredName* expected_name = NULL;
	FolksStructuredName* _tmp12_ = NULL;
	FolksIndividual* _tmp13_ = NULL;
	FolksStructuredName* _tmp14_ = NULL;
	FolksStructuredName* _tmp15_ = NULL;
	FolksStructuredName* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	FolksIndividual* _tmp18_ = NULL;
	FolksStructuredName* _tmp19_ = NULL;
	FolksIndividual* _tmp20_ = NULL;
	FolksStructuredName* _tmp21_ = NULL;
	FolksStructuredName* _tmp22_ = NULL;
	FolksStructuredName* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	FolksIndividual* _tmp25_ = NULL;
	FolksStructuredName* _tmp26_ = NULL;
	FolksIndividual* _tmp27_ = NULL;
	FolksStructuredName* _tmp28_ = NULL;
	FolksStructuredName* _tmp29_ = NULL;
	FolksStructuredName* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	FolksIndividual* _tmp32_ = NULL;
	FolksStructuredName* _tmp33_ = NULL;
	FolksIndividual* _tmp34_ = NULL;
	FolksStructuredName* _tmp35_ = NULL;
	FolksStructuredName* _tmp36_ = NULL;
	FolksStructuredName* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	FolksIndividual* _tmp39_ = NULL;
	FolksStructuredName* _tmp40_ = NULL;
	FolksIndividual* _tmp41_ = NULL;
	FolksStructuredName* _tmp42_ = NULL;
	FolksStructuredName* _tmp43_ = NULL;
	FolksStructuredName* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	FolksIndividual* _tmp46_ = NULL;
	FolksStructuredName* _tmp47_ = NULL;
	FolksIndividual* _tmp48_ = NULL;
	FolksStructuredName* _tmp49_ = NULL;
	FolksStructuredName* _tmp50_ = NULL;
	FolksStructuredName* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	FolksIndividual* _tmp53_ = NULL;
	FolksStructuredName* _tmp54_ = NULL;
	FolksIndividual* _tmp55_ = NULL;
	FolksStructuredName* _tmp56_ = NULL;
	FolksStructuredName* _tmp57_ = NULL;
	FolksStructuredName* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	FolksIndividual* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
#line 110 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	g_return_if_fail (self != NULL);
#line 113 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp0_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 113 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	bluez_test_backend_create_simple_device_with_vcard (_tmp0_, "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:John Public\n" "N:Public;John;Quinlan;Mr.;Esq.\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:John Stevenson\n" "N:Stevenson;John;Philip,Paul;Dr.;Jr.,M.D.,A.C.P.\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:Franco Dianno\n" "N:Dianno;Franco;;;\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:Amelia Smith\n" "N:Smith;Amelia;David;Dr.\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:Sadie Jones\n" "N:Jones;Sadie;M.\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "FN:Alex Lawson\n" "N:Lawson;Alex\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:3.0\n" "N:W;Alice;;;\n" "FN:\n" "TEL;TYPE=CELL:5145152\n" "TEL;TYPE=VOICE:545\n" "END:VCARD", NULL, NULL);
#line 163 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp1_ = folks_individual_aggregator_dup ();
#line 163 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	aggregator = _tmp1_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp2_ = g_strdup ("John Public");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp3_ = g_strdup ("John Stevenson");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_ = g_strdup ("Franco Dianno");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp5_ = g_strdup ("Amelia Smith");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp6_ = g_strdup ("Sadie Jones");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp7_ = g_strdup ("Alex Lawson");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp8_ = g_strdup ("");
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_ = g_new0 (gchar*, 7 + 1);
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[0] = _tmp2_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[1] = _tmp3_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[2] = _tmp4_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[3] = _tmp5_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[4] = _tmp6_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[5] = _tmp7_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_[6] = _tmp8_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp10_ = _tmp9_;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp10__length1 = 7;
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_individuals_sync_with_timeout (aggregator, _tmp10_, 7, 5);
#line 164 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
#line 177 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp11_ = folks_test_utils_get_individual_by_name (aggregator, "John Public");
#line 177 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp11_;
#line 178 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp12_ = folks_structured_name_new ("Public", "John", "Quinlan", "Mr.", "Esq.");
#line 178 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp12_;
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp13_ = ind;
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp14_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp13_);
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp15_ = _tmp14_;
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp16_ = expected_name;
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp17_ = folks_structured_name_equal (_tmp15_, _tmp16_);
#line 180 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp17_, "ind.structured_name.equal (expected_name)");
#line 182 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp18_ = folks_test_utils_get_individual_by_name (aggregator, "John Stevenson");
#line 182 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 182 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp18_;
#line 183 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp19_ = folks_structured_name_new ("Stevenson", "John", "Philip,Paul", "Dr.", "Jr.,M.D.,A.C.P.");
#line 183 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 183 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp19_;
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp20_ = ind;
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp21_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp20_);
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp22_ = _tmp21_;
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp23_ = expected_name;
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp24_ = folks_structured_name_equal (_tmp22_, _tmp23_);
#line 186 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp24_, "ind.structured_name.equal (expected_name)");
#line 188 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp25_ = folks_test_utils_get_individual_by_name (aggregator, "Franco Dianno");
#line 188 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 188 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp25_;
#line 189 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp26_ = folks_structured_name_new ("Dianno", "Franco", NULL, NULL, NULL);
#line 189 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 189 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp26_;
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp27_ = ind;
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp28_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp27_);
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp29_ = _tmp28_;
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp30_ = expected_name;
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp31_ = folks_structured_name_equal (_tmp29_, _tmp30_);
#line 190 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp31_, "ind.structured_name.equal (expected_name)");
#line 192 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp32_ = folks_test_utils_get_individual_by_name (aggregator, "Amelia Smith");
#line 192 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 192 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp32_;
#line 193 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp33_ = folks_structured_name_new ("Smith", "Amelia", "David", "Dr.", NULL);
#line 193 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 193 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp33_;
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp34_ = ind;
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp35_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp34_);
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp36_ = _tmp35_;
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp37_ = expected_name;
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp38_ = folks_structured_name_equal (_tmp36_, _tmp37_);
#line 195 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp38_, "ind.structured_name.equal (expected_name)");
#line 197 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp39_ = folks_test_utils_get_individual_by_name (aggregator, "Sadie Jones");
#line 197 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 197 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp39_;
#line 198 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp40_ = folks_structured_name_new ("Jones", "Sadie", "M.", NULL, NULL);
#line 198 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 198 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp40_;
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp41_ = ind;
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp42_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp41_);
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp43_ = _tmp42_;
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp44_ = expected_name;
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp45_ = folks_structured_name_equal (_tmp43_, _tmp44_);
#line 199 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp45_, "ind.structured_name.equal (expected_name)");
#line 201 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp46_ = folks_test_utils_get_individual_by_name (aggregator, "Alex Lawson");
#line 201 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 201 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp46_;
#line 202 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp47_ = folks_structured_name_new ("Lawson", "Alex", NULL, NULL, NULL);
#line 202 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 202 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp47_;
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp48_ = ind;
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp49_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp48_);
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp50_ = _tmp49_;
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp51_ = expected_name;
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp52_ = folks_structured_name_equal (_tmp50_, _tmp51_);
#line 203 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp52_, "ind.structured_name.equal (expected_name)");
#line 205 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp53_ = folks_test_utils_get_individual_by_name (aggregator, "");
#line 205 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 205 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp53_;
#line 206 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp54_ = folks_structured_name_new ("W", "Alice", NULL, NULL, NULL);
#line 206 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 206 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp54_;
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp55_ = ind;
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp56_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp55_);
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp57_ = _tmp56_;
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp58_ = expected_name;
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp59_ = folks_structured_name_equal (_tmp57_, _tmp58_);
#line 207 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp59_, "ind.structured_name.equal (expected_name)");
#line 208 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp60_ = ind;
#line 208 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp61_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp60_);
#line 208 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp62_ = _tmp61_;
#line 208 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (g_strcmp0 (_tmp62_, "") == 0, "ind.full_name == \"\"");
#line 110 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 110 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 110 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (aggregator);
#line 663 "vcard-parsing.c"
}


void vcard_parsing_tests_test_encoding (VcardParsingTests* self) {
	BluezTestBackend* _tmp0_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	FolksIndividual* ind = NULL;
	FolksIndividual* _tmp6_ = NULL;
	FolksStructuredName* expected_name = NULL;
	FolksStructuredName* _tmp7_ = NULL;
	FolksIndividual* _tmp8_ = NULL;
	FolksStructuredName* _tmp9_ = NULL;
	FolksStructuredName* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	FolksIndividual* _tmp12_ = NULL;
	FolksIndividual* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 212 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	g_return_if_fail (self != NULL);
#line 215 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp0_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 215 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	bluez_test_backend_create_simple_device_with_vcard (_tmp0_, "BEGIN:VCARD\n" "VERSION:2.1\n" "FN:Test 1\n" "N;CHARSET=UTF-8:溌剌;元気\n" "END:VCARD\n" "\n" "BEGIN:VCARD\n" "VERSION:2.1\n" "FN;ENCODING=quoted-printable:ActualValue=20=C4=9B=C5=A1" "=C4=8D=C5=99=C5=BE=C3=BD=C3=A1=C3=AD=C3=A9=C3=BA=C5=AF=C3" "=B3=C3=B6=C4=9A=C5=A0=C4=8C=C5=98=C5=BD=C3=9D=C3=81=C3=8D" "=C3=89=C3=9A=C5=AE=C3=93=C3=96=C2=A7=201234567890=2012345" "67890=201234567890=201234567890=201234567890\n" "END:VCARD\n", NULL, NULL);
#line 236 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp1_ = folks_individual_aggregator_dup ();
#line 236 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	aggregator = _tmp1_;
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp2_ = g_strdup ("Test 1");
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp3_ = g_strdup ("ActualValue ěščřžýáíéúůóöĚŠČŘŽÝÁÍÉÚŮÓÖ§ " "1234567890 1234567890 1234567890 1234567890 1234567890");
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_[0] = _tmp2_;
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp4_[1] = _tmp3_;
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp5_ = _tmp4_;
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp5__length1 = 2;
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_individuals_sync_with_timeout (aggregator, _tmp5_, 2, 5);
#line 237 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 246 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp6_ = folks_test_utils_get_individual_by_name (aggregator, "Test 1");
#line 246 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp6_;
#line 247 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp7_ = folks_structured_name_new ("溌剌", "元気", NULL, NULL, NULL);
#line 247 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	expected_name = _tmp7_;
#line 249 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp8_ = ind;
#line 249 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp9_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp8_);
#line 249 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp10_ = _tmp9_;
#line 249 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp11_ = folks_structured_name_equal (_tmp10_, expected_name);
#line 249 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (_tmp11_, "ind.structured_name.equal (expected_name)");
#line 251 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp12_ = folks_test_utils_get_individual_by_name (aggregator, "ActualValue ěščřžýáíéúůóöĚŠČŘŽÝÁÍÉÚŮÓÖ§ " "1234567890 1234567890 1234567890 1234567890 1234567890");
#line 251 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 251 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	ind = _tmp12_;
#line 255 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp13_ = ind;
#line 255 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp14_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp13_);
#line 255 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp15_ = _tmp14_;
#line 255 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_vala_assert (g_strcmp0 (_tmp15_, "ActualValue ěščřžýáíéúůóöĚŠČŘŽÝÁÍÉÚŮÓÖ§ " "1234567890 1234567890 1234567890 1234567890 1234567890") == 0, "ind.full_name == \"ActualValue \304\233\305\241\304\215\305\231\305\276\303\275\303\241\303\255\303\251\303\272\305\257\303\263\303\266\304\232\305\240\304\214\305\230\305\275\303\235\303\201\303\215\303\211\303\232\305\256\303\223\303\226\302\247 \" +                   \"1234567890 1234567890 1234567890 1234567890 1234567890\"");
#line 212 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (expected_name);
#line 212 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (ind);
#line 212 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (aggregator);
#line 754 "vcard-parsing.c"
}


static void vcard_parsing_tests_class_init (VcardParsingTestsClass * klass) {
#line 24 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	vcard_parsing_tests_parent_class = g_type_class_peek_parent (klass);
#line 761 "vcard-parsing.c"
}


static void vcard_parsing_tests_instance_init (VcardParsingTests * self) {
}


GType vcard_parsing_tests_get_type (void) {
	static volatile gsize vcard_parsing_tests_type_id__volatile = 0;
	if (g_once_init_enter (&vcard_parsing_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VcardParsingTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vcard_parsing_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VcardParsingTests), 0, (GInstanceInitFunc) vcard_parsing_tests_instance_init, NULL };
		GType vcard_parsing_tests_type_id;
		vcard_parsing_tests_type_id = g_type_register_static (BLUEZ_TEST_TYPE_TEST_CASE, "VcardParsingTests", &g_define_type_info, 0);
		g_once_init_leave (&vcard_parsing_tests_type_id__volatile, vcard_parsing_tests_type_id);
	}
	return vcard_parsing_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	VcardParsingTests* tests = NULL;
	VcardParsingTests* _tmp0_ = NULL;
#line 262 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	g_test_init (&args_length1, &args, NULL);
#line 264 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_tmp0_ = vcard_parsing_tests_new ();
#line 264 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	tests = _tmp0_;
#line 265 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 266 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	g_test_run ();
#line 267 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 269 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	result = 0;
#line 269 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	_g_object_unref0 (tests);
#line 269 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return result;
#line 803 "vcard-parsing.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 260 "/opt/gnome3/source/folks/tests/bluez/vcard-parsing.vala"
	return _vala_main (argv, argc);
#line 813 "vcard-parsing.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



