## Charset and Collation of MySQL and MariaDB latest versions

`collate2charset` and `collate2charset.maria` hold a mapping from the collation to their charset.

```sql
select json_objectagg(collation_name, character_set_name) from information_schema.collations\G;
```

`charset2collate` and `charset2collate.maria` hold a mapping from the charset to its default collation extracted
by the following query:

```sql
select json_objectagg(character_set_name, default_collate_name) from information_schema.character_sets\G;
```