{-# LANGUAGE NoImplicitPrelude, UnicodeSyntax #-}

module Data.Monoid.Unicode ( (∅), (⊕) ) where

-------------------------------------------------------------------------------
-- Imports
-------------------------------------------------------------------------------

-- from base:
import Data.Monoid ( Monoid, mempty, mappend )


-------------------------------------------------------------------------------
-- Fixities
-------------------------------------------------------------------------------

infixr 6 ⊕


-------------------------------------------------------------------------------
-- Symbols
-------------------------------------------------------------------------------

{-|
(&#x2205;) = 'mempty'

U+2205, EMPTY SET
-}
(∅) ∷ Monoid α ⇒ α
(∅) = mempty
{-# INLINE (∅) #-}

{-|
(&#x2295;) = 'mappend'

U+2295, CIRCLED PLUS
-}
(⊕) ∷ Monoid α ⇒ α → α → α
(⊕) = mappend
{-# INLINE (⊕) #-}
