/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;

public class TextFileSettings {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    Database database;
    String dataFileName;
    int maxCacheRows;
    int maxCacheBytes;
    static final byte[] BYTES_LINE_SEP = NL.getBytes();
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextFileSettings(Database database, String string) {
        this.database = database;
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", "textdb");
        HsqlDatabaseProperties hsqlDatabaseProperties = database.getProperties();
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                this.dataFileName = null;
            }
            case 1: {
                this.dataFileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = hsqlDatabaseProperties.getStringProperty("textdb.fs");
        this.fs = hsqlProperties.getProperty("textdb.fs", this.fs);
        this.vs = hsqlDatabaseProperties.getStringProperty("textdb.vs");
        this.vs = hsqlProperties.getProperty("textdb.vs", this.vs);
        this.lvs = hsqlDatabaseProperties.getStringProperty("textdb.lvs");
        this.lvs = hsqlProperties.getProperty("textdb.lvs", this.lvs);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = TextFileSettings.translateSep(this.fs);
        this.vs = TextFileSettings.translateSep(this.vs);
        this.lvs = TextFileSettings.translateSep(this.lvs);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        this.ignoreFirst = hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first");
        this.ignoreFirst = hsqlProperties.isPropertyTrue("textdb.ignore_first", this.ignoreFirst);
        this.isQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.quoted");
        this.isQuoted = hsqlProperties.isPropertyTrue("textdb.quoted", this.isQuoted);
        this.isAllQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted");
        this.isAllQuoted = hsqlProperties.isPropertyTrue("textdb.all_quoted", this.isAllQuoted);
        this.stringEncoding = hsqlDatabaseProperties.getStringProperty("textdb.encoding");
        this.stringEncoding = hsqlProperties.getProperty("textdb.encoding", this.stringEncoding);
        int n = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale");
        n = hsqlProperties.getIntegerProperty("textdb.cache_scale", n);
        int n2 = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale");
        n2 = hsqlProperties.getIntegerProperty("textdb.cache_size_scale", n2);
        this.maxCacheRows = (1 << n) * 3;
        this.maxCacheRows = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheRows = hsqlProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << n2) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4) {
            this.maxCacheBytes = 4;
        }
        this.maxCacheBytes = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes = hsqlProperties.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes *= 1024;
    }

    String getFileName() {
        return this.dataFileName;
    }

    int getMaxCacheRows() {
        return this.maxCacheRows;
    }

    int getMaxCacheBytes() {
        return this.maxCacheBytes;
    }

    private static String translateSep(String string) {
        return TextFileSettings.translateSep(string, false);
    }

    private static String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }
}

