/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  A GUI toolkit-independent base shell subject
//

#ifndef IBGSHELLSUBJECT_H
#define IBGSHELLSUBJECT_H


#include "ibgelement.h"


class iString;

class iggShell;


class ibgShellSubject : public ibgElement
{

	friend class iggShell;

protected:

	ibgShellSubject(iggShell *owner, int argc, char **argv);
	virtual ~ibgShellSubject();

	//
	//  System-level operations
	//
	virtual void GetDesktopDimensions(int &w, int &h) const = 0;
	virtual void ProcessEvents(bool sync) = 0;
	virtual void CompleteStartUp() = 0;
	virtual void EnterEventLoop() = 0;
	virtual void Exit() = 0;

	//
	//  Shell capabilities
	//
	virtual bool CanRecognize8BitDisplay(bool check = false) const = 0;
	virtual bool CanDockWindows() const = 0;
	virtual bool CanChangeFontSize() const = 0;
	
	virtual bool CheckCondition(int flag) const = 0;

	iggShell *mOwner;
};

#endif  // IBGSHELLSUBJECT_H

