# - Try to locate SDL2_ttf
# This module defines:
#
#  SDL2TTF_INCLUDE_DIR
#  SDL2TTF_LIBRARY
#  SDL2TTF_FOUND
#

FIND_PATH(SDL2TTF_INCLUDE_DIR NAMES SDL_ttf.h PATH_SUFFIXES SDL2)

FIND_LIBRARY(SDL2TTF_LIBRARY NAMES SDL2_ttf)

IF(SDL2TTF_INCLUDE_DIR AND SDL2TTF_LIBRARY)
	SET(SDL2TTF_FOUND TRUE)
ENDIF(SDL2TTF_INCLUDE_DIR AND SDL2TTF_LIBRARY)

IF(SDL2TTF_FOUND)
	IF(NOT SDL2_ttf_FIND_QUIETLY)
		MESSAGE(STATUS "Found SDL2_ttf: -I${SDL2TTF_INCLUDE_DIR}, ${SDL2TTF_LIBRARY}")
	ENDIF(NOT SDL2_ttf_FIND_QUIETLY)
ELSE(SDL2TTF_FOUND)
	IF(SDL2_ttf_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find SDL2_ttf")
	ENDIF(SDL2_ttf_FIND_REQUIRED)
ENDIF(SDL2TTF_FOUND)

MARK_AS_ADVANCED(SDL2TTF_INCLUDE_DIR SDL2TTF_LIBRARY SDL2TTF_FOUND)
