/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;

class Merger {
    private static final Log LOG = LogFactory.getLog(Merger.class);
    private static LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    Merger() {
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return new MergeQueue<K, V>(conf, fs, inputs, deleteInputs, codec, comparator, reporter).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, false, codec).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return Merger.merge(conf, fs, keyClass, valueClass, segments, mergeFactor, tmpDir, comparator, reporter, false, readsCounter, writesCounter);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter);
    }

    static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter);
    }

    static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, List<Segment<K, V>> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments, codec).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter);
    }

    public static <K, V> void writeFile(RawKeyValueIterator records, IFile.Writer<K, V> writer, Progressable progressable, Configuration conf) throws IOException {
        long progressBar = conf.getLong("mapred.merge.recordsBeforeProgress", 10000L);
        long recordCtr = 0L;
        while (records.next()) {
            writer.append(records.getKey(), records.getValue());
            if (recordCtr++ % progressBar != 0L) continue;
            progressable.progress();
        }
    }

    private static class MergeQueue<K, V>
    extends PriorityQueue<Segment<K, V>>
    implements RawKeyValueIterator {
        Configuration conf;
        FileSystem fs;
        CompressionCodec codec;
        List<Segment<K, V>> segments = new ArrayList<Segment<K, V>>();
        RawComparator<K> comparator;
        private long totalBytesProcessed;
        private float progPerByte;
        private Progress mergeProgress = new Progress();
        Progressable reporter;
        DataInputBuffer key;
        DataInputBuffer value;
        Segment<K, V> minSegment;
        Comparator<Segment<K, V>> segmentComparator = new Comparator<Segment<K, V>>(){

            @Override
            public int compare(Segment<K, V> o1, Segment<K, V> o2) {
                if (o1.getLength() == o2.getLength()) {
                    return 0;
                }
                return o1.getLength() < o2.getLength() ? -1 : 1;
            }
        };

        public MergeQueue(Configuration conf, FileSystem fs, Path[] inputs, boolean deleteInputs, CompressionCodec codec, RawComparator<K> comparator, Progressable reporter) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.codec = codec;
            this.comparator = comparator;
            this.reporter = reporter;
            for (Path file : inputs) {
                this.segments.add(new Segment(conf, fs, file, codec, !deleteInputs));
            }
            Collections.sort(this.segments, this.segmentComparator);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter) {
            this(conf, fs, segments, comparator, reporter, false);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter, boolean sortSegments) {
            this.conf = conf;
            this.fs = fs;
            this.comparator = comparator;
            this.segments = segments;
            this.reporter = reporter;
            if (sortSegments) {
                Collections.sort(segments, this.segmentComparator);
            }
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, CompressionCodec codec) {
            this(conf, fs, segments, comparator, reporter, sortSegments);
            this.codec = codec;
        }

        @Override
        public void close() throws IOException {
            Segment segment;
            while ((segment = (Segment)this.pop()) != null) {
                segment.close();
            }
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            return this.key;
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            return this.value;
        }

        private void adjustPriorityQueue(Segment<K, V> reader) throws IOException {
            long startPos = reader.getPosition();
            boolean hasNext = reader.next();
            long endPos = reader.getPosition();
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
            if (hasNext) {
                this.adjustTop();
            } else {
                this.pop();
                reader.close();
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.size() == 0) {
                return false;
            }
            if (this.minSegment != null) {
                this.adjustPriorityQueue(this.minSegment);
                if (this.size() == 0) {
                    this.minSegment = null;
                    return false;
                }
            }
            this.minSegment = (Segment)this.top();
            this.key = this.minSegment.getKey();
            this.value = this.minSegment.getValue();
            return true;
        }

        @Override
        protected boolean lessThan(Object a, Object b) {
            DataInputBuffer key1 = ((Segment)a).getKey();
            DataInputBuffer key2 = ((Segment)b).getKey();
            int s1 = key1.getPosition();
            int l1 = key1.getLength() - s1;
            int s2 = key2.getPosition();
            int l2 = key2.getLength() - s2;
            return this.comparator.compare(key1.getData(), s1, l1, key2.getData(), s2, l2) < 0;
        }

        public RawKeyValueIterator merge(Class<K> keyClass, Class<V> valueClass, int factor, Path tmpDir, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
            return this.merge(keyClass, valueClass, factor, 0, tmpDir, readsCounter, writesCounter);
        }

        RawKeyValueIterator merge(Class<K> keyClass, Class<V> valueClass, int factor, int inMem, Path tmpDir, Counters.Counter readsCounter, Counters.Counter writesCounter) throws IOException {
            LOG.info((Object)("Merging " + this.segments.size() + " sorted segments"));
            int numSegments = this.segments.size();
            int origFactor = factor;
            int passNo = 1;
            while (true) {
                factor = this.getPassFactor(factor, passNo, numSegments - inMem);
                if (1 == passNo) {
                    factor += inMem;
                }
                ArrayList<Segment<K, V>> segmentsToMerge = new ArrayList<Segment<K, V>>();
                int segmentsConsidered = 0;
                int numSegmentsToConsider = factor;
                long startBytes = 0L;
                while (true) {
                    List<Segment<K, V>> mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                    for (Segment<K, V> segment : mStream) {
                        ((Segment)segment).init(readsCounter);
                        long l = segment.getPosition();
                        boolean hasNext = segment.next();
                        long endPos = segment.getPosition();
                        startBytes += endPos - l;
                        if (hasNext) {
                            segmentsToMerge.add(segment);
                            ++segmentsConsidered;
                            continue;
                        }
                        segment.close();
                        --numSegments;
                    }
                    if (segmentsConsidered == factor || this.segments.size() == 0) break;
                    numSegmentsToConsider = factor - segmentsConsidered;
                }
                this.initialize(segmentsToMerge.size());
                this.clear();
                for (Segment segment : segmentsToMerge) {
                    this.put(segment);
                }
                if (numSegments <= factor) {
                    this.totalBytesProcessed = startBytes;
                    long totalBytes = 0L;
                    for (int i = 0; i < segmentsToMerge.size(); ++i) {
                        totalBytes += ((Segment)segmentsToMerge.get(i)).getLength();
                    }
                    if (totalBytes != 0L) {
                        this.progPerByte = 1.0f / (float)totalBytes;
                    }
                    if (totalBytes != 0L) {
                        this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
                    } else {
                        this.mergeProgress.set(1.0f);
                    }
                    LOG.info((Object)("Down to the last merge-pass, with " + numSegments + " segments left of total size: " + totalBytes + " bytes"));
                    return this;
                }
                LOG.info((Object)("Merging " + segmentsToMerge.size() + " intermediate segments out of a total of " + (this.segments.size() + segmentsToMerge.size())));
                long approxOutputSize = 0L;
                for (Segment segment : segmentsToMerge) {
                    approxOutputSize = (long)((double)approxOutputSize + ((double)segment.getLength() + ChecksumFileSystem.getApproxChkSumLength(segment.getLength())));
                }
                Path tmpFilename = new Path(tmpDir, "intermediate").suffix("." + passNo);
                Path path = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, this.conf);
                IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.conf, this.fs, path, keyClass, valueClass, this.codec, writesCounter);
                Merger.writeFile(this, writer, this.reporter, this.conf);
                writer.close();
                this.close();
                Segment tempSegment = new Segment(this.conf, this.fs, path, this.codec, false);
                this.segments.add(tempSegment);
                numSegments = this.segments.size();
                Collections.sort(this.segments, this.segmentComparator);
                ++passNo;
                factor = origFactor;
            }
        }

        private int getPassFactor(int factor, int passNo, int numSegments) {
            if (passNo > 1 || numSegments <= factor || factor == 1) {
                return factor;
            }
            int mod = (numSegments - 1) % (factor - 1);
            if (mod == 0) {
                return factor;
            }
            return mod + 1;
        }

        private List<Segment<K, V>> getSegmentDescriptors(int numDescriptors) {
            if (numDescriptors > this.segments.size()) {
                ArrayList<Segment<K, V>> subList = new ArrayList<Segment<K, V>>(this.segments);
                this.segments.clear();
                return subList;
            }
            ArrayList<Segment<K, V>> subList = new ArrayList<Segment<K, V>>(this.segments.subList(0, numDescriptors));
            for (int i = 0; i < numDescriptors; ++i) {
                this.segments.remove(0);
            }
            return subList;
        }

        @Override
        public Progress getProgress() {
            return this.mergeProgress;
        }
    }

    public static class Segment<K, V> {
        IFile.Reader<K, V> reader = null;
        DataInputBuffer key = new DataInputBuffer();
        DataInputBuffer value = new DataInputBuffer();
        Configuration conf = null;
        FileSystem fs = null;
        Path file = null;
        boolean preserve = false;
        CompressionCodec codec = null;
        long segmentOffset = 0L;
        long segmentLength = -1L;

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean preserve) throws IOException {
            this(conf, fs, file, 0L, fs.getFileStatus(file).getLen(), codec, preserve);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean preserve) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.file = file;
            this.codec = codec;
            this.preserve = preserve;
            this.segmentOffset = segmentOffset;
            this.segmentLength = segmentLength;
        }

        public Segment(IFile.Reader<K, V> reader, boolean preserve) {
            this.reader = reader;
            this.preserve = preserve;
            this.segmentLength = reader.getLength();
        }

        private void init(Counters.Counter readsCounter) throws IOException {
            if (this.reader == null) {
                FSDataInputStream in = this.fs.open(this.file);
                in.seek(this.segmentOffset);
                this.reader = new IFile.Reader(this.conf, in, this.segmentLength, this.codec, readsCounter);
            }
        }

        DataInputBuffer getKey() {
            return this.key;
        }

        DataInputBuffer getValue() {
            return this.value;
        }

        long getLength() {
            return this.reader == null ? this.segmentLength : this.reader.getLength();
        }

        boolean next() throws IOException {
            return this.reader.next(this.key, this.value);
        }

        void close() throws IOException {
            this.reader.close();
            if (!this.preserve && this.fs != null) {
                this.fs.delete(this.file, false);
            }
        }

        public long getPosition() throws IOException {
            return this.reader.getPosition();
        }
    }
}

