/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.StringUtils;

public class FileOutputCommitter
extends OutputCommitter {
    private static final Log LOG = LogFactory.getLog(FileOutputCommitter.class);
    protected static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
    private FileSystem outputFileSystem = null;
    private Path outputPath = null;
    private Path workPath = null;

    public FileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        if (outputPath != null) {
            this.outputPath = outputPath;
            this.outputFileSystem = outputPath.getFileSystem(context.getConfiguration());
            this.workPath = new Path(outputPath, "_temporary/_" + context.getTaskAttemptID().toString()).makeQualified(this.outputFileSystem);
        }
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        if (this.outputPath != null && !(fileSys = (tmpDir = new Path(this.outputPath, TEMP_DIR_NAME)).getFileSystem(context.getConfiguration())).mkdirs(tmpDir)) {
            LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
        }
    }

    private static boolean shouldMarkOutputDir(Configuration conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true);
    }

    private void markOutputDirSuccessful(JobContext context) throws IOException {
        FileSystem fileSys;
        if (this.outputPath != null && (fileSys = this.outputPath.getFileSystem(context.getConfiguration())).exists(this.outputPath)) {
            Path filePath = new Path(this.outputPath, SUCCEEDED_FILE_NAME);
            fileSys.create(filePath).close();
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        this.cleanupJob(context);
        if (FileOutputCommitter.shouldMarkOutputDir(context.getConfiguration())) {
            this.markOutputDirSuccessful(context);
        }
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        if (this.outputPath != null) {
            Path tmpDir = new Path(this.outputPath, TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem(context.getConfiguration());
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        } else {
            LOG.warn((Object)"Output path is null in cleanup");
        }
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        this.cleanupJob(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        if (this.workPath != null) {
            context.progress();
            if (this.outputFileSystem.exists(this.workPath)) {
                this.moveTaskOutputs(context, this.outputFileSystem, this.outputPath, this.workPath);
                if (!this.outputFileSystem.delete(this.workPath, true)) {
                    LOG.warn((Object)("Failed to delete the temporary output directory of task: " + attemptId + " - " + this.workPath));
                }
                LOG.info((Object)("Saved output of task '" + attemptId + "' to " + this.outputPath));
            }
        }
    }

    private void moveTaskOutputs(TaskAttemptContext context, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        context.progress();
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.workPath);
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + attemptId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + attemptId);
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(taskOutput).isDir()) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.workPath);
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(context, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) {
        try {
            if (this.workPath != null) {
                context.progress();
                this.outputFileSystem.delete(this.workPath, true);
            }
        }
        catch (IOException ie) {
            LOG.warn((Object)("Error discarding output" + StringUtils.stringifyException(ie)));
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI relativePath;
        URI taskOutputUri = taskOutput.toUri();
        if (taskOutputUri == (relativePath = taskOutputPath.toUri().relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPath + " child = " + taskOutput);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.workPath != null && this.outputFileSystem.exists(this.workPath);
    }

    public Path getWorkPath() throws IOException {
        return this.workPath;
    }
}

