/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.UserGroupInformation;

class User
implements Principal {
    private final String fullName;
    private final String shortName;
    private UserGroupInformation.AuthenticationMethod authMethod = null;
    private LoginContext login = null;
    private long lastLogin = 0L;

    public User(String name) {
        this(name, null, null);
    }

    public User(String name, UserGroupInformation.AuthenticationMethod authMethod, LoginContext login) {
        try {
            this.shortName = new KerberosName(name).getShortName();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Illegal principal name " + name, ioe);
        }
        this.fullName = name;
        this.authMethod = authMethod;
        this.login = login;
    }

    @Override
    public String getName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.fullName.equals(((User)o).fullName) && this.authMethod == ((User)o).authMethod;
    }

    @Override
    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public String toString() {
        return this.fullName;
    }

    public void setAuthenticationMethod(UserGroupInformation.AuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public UserGroupInformation.AuthenticationMethod getAuthenticationMethod() {
        return this.authMethod;
    }

    public LoginContext getLogin() {
        return this.login;
    }

    public void setLogin(LoginContext login) {
        this.login = login;
    }

    public void setLastLogin(long time) {
        this.lastLogin = time;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }
}

