/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__OBJECT_HPP)
#include <Object.hpp>
#endif

using namespace corelinux;

//
// Default constructor
//

Object::Object( void )
   :
   theIdentity(0)
{
   NEVER_GET_HERE;
}

//
// Proper constructor
//

Object::Object( DwordIdentifierCref aId )
   :
   theIdentity( aId )
{
   ;  // do nothing
}

//
// Copy constructor
//

Object::Object( ObjectCref )
{
   ;  // won't ever get here
}

//
// Destructor
//

Object::~Object( void )
{
   theIdentity=0;
}

//
// Assignment operator
//

ObjectRef  Object::operator=( ObjectCref )
{
   NEVER_GET_HERE;
   return (*this);   // won't happen
}

//
// Equality operator
//

bool  Object::operator==( ObjectCref aRef ) const
{
   return (getIdentity() == aRef.getIdentity());
}

//
// Retrieves my id
//

DwordIdentifierCref Object::getIdentity( void ) const
{
   return theIdentity;
}

