use Test::More 'no_plan';

use List::Maker;

is_deeply [<1,2..10>],    [1,2,3,4,5,6,7,8,9,10]       => '<1,2..10>';
is_deeply [<1,2,..10>],   [1,2,3,4,5,6,7,8,9,10]       => '<1,2,..10>';
is_deeply [<1, 2 .. 10>], [1,2,3,4,5,6,7,8,9,10]       => '<1, 2 .. 10>';

is_deeply [<-1,0..10>],  [-1,0,1,2,3,4,5,6,7,8,9,10]   => '<-1,0..10>';
is_deeply [<1,1,..1>],   [1]                           => '<1,1,..1>';
is_deeply [<1,2,..1>],   [1]                           => '<1,2,..1>';
is_deeply [<10,9..1>],   [10,9,8,7,6,5,4,3,2,1]        => '<10,9..1>';

is_deeply [<1.1,2.1..9.9>], [map { $_+0.1 } 1..9]      => '<1.1,2.1..9.9>';
is_deeply [<9.9,8.9..1.1>], [map { 10-$_+0.9 } 1..9]   => '<9.9,8.9..1.1x-1>';

is_deeply [<1,3..10>],   [1,3,5,7,9]                   => '<1,3..10>';
is_deeply [<1,4..10>],   [1,4,7,10]                    => '<1,4..10>';
is_deeply [<1,5..10>],   [1,5,9]                       => '<1,5..10>';
is_deeply [<1,6..10>],   [1,6]                         => '<1,6..10>';
is_deeply [<1,7..10>],   [1,7]                         => '<1,7..10>';
is_deeply [<1,8..10>],   [1,8]                         => '<1,8..10>';
is_deeply [<1,9..10>],   [1,9]                         => '<1,9..10>';
is_deeply [<1,10..10>],  [1,10]                        => '<1,10..10>';

is_deeply [<1.1,3.6,..9.9>], [1.1, 3.6, 6.1, 8.6]      => '<1.1,3.6,..9.9>';

# EXCLUSIVE...
#
is_deeply [<1,2..^10>],    [1,2,3,4,5,6,7,8,9]          => '<1,2..^10>';
is_deeply [<1,2,..^10>],   [1,2,3,4,5,6,7,8,9]          => '<1,2,..^10>';
is_deeply [<1, 2 ..^ 10>], [1,2,3,4,5,6,7,8,9]          => '<1, 2 ..^10>';

is_deeply [<-1,0..^10>],  [-1,0,1,2,3,4,5,6,7,8,9]      => '<-1,0..^10>';
is_deeply [<1,1,..^1>],   []                            => '<1,1..^1>';
is_deeply [<1,2,..^1>],   []                            => '<1,2..^1>';
is_deeply [<10,9..^1>],   [10,9,8,7,6,5,4,3,2]          => '<10,9..^1>';

is_deeply [<1.1,2.1..^9.9>], [map { $_+0.1 } 1..9]      => '<1.1,2.1..^9.9>';
is_deeply [<9.9,8.9..^1.1>], [map { 10-$_+0.9 } 1..9]   => '<9.9,8.9..^1.1>';

is_deeply [<1.1,2.2..^9.9>], [map { $_*1.1 } 1..8]      => '<1.1,2.2..^9.9>';
is_deeply [<9.9,8.8..^1.1>], [map { 9.9-$_*1.1 } 0..7]  => '<9.9,8.8..^1.1>';

is_deeply [<1,3..^10>],   [1,3,5,7,9]                   => '<1,3..^10>';
is_deeply [<1,4..^10>],   [1,4,7]                       => '<1,4..^10>';
is_deeply [<1,5..^10>],   [1,5,9]                       => '<1,5..^10>';
is_deeply [<1,6..^10>],   [1,6]                         => '<1,6..^10>';
is_deeply [<1,7..^10>],   [1,7]                         => '<1,7..^10>';
is_deeply [<1,8..^10>],   [1,8]                         => '<1,8..^10>';
is_deeply [<1,9..^10>],   [1,9]                         => '<1,9..^10>';
is_deeply [<1,10..^10>],  [1]                           => '<1,10..^10>';
