C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

	PROGRAM GRAF02
C
C	THIS PROGRAM DEMONSTRATES MAGICS GRAPH PLOTTING FACILITIES.
C	THERE ARE THREE FEATURES DEMONSTRATED:

C	(1) HIDDEN BARS
C	(2) CLUSTERED BARS
C	(3) OVERLAPPING BARS
C
C	OPEN MAGICS
C
	CALL POPEN
      CALL PARSE_COMMAND_LINE ('bar')
C
	CALL PSETC ('PAGE_ID_LINE','OFF')
	CALL PSETC ('SUBPAGE_MAP_PROJECTION', 'cartesian')
C
C	PLOT HIDDEN BARS
C
	CALL GRAF02_ONE
	CALL PNEW ('PAGE')
C
C	PLOT CLUSTERED BARS   
C
	CALL GRAF02_TWO
	CALL PNEW ('PAGE')
C
C	PLOT OVERLAPPING BARS  
C
	CALL GRAF02_THREE
	CALL PNEW ('PAGE')
	CALL GRAF02_FOUR
	CALL PNEW ('PAGE')
	CALL GRAF02_FIVE
	CALL PNEW ('PAGE')
C
C
C
C	PLOT OVERLAPPING BARS  
	CALL PCLOSE
	STOP
	END
	SUBROUTINE GRAF02_ONE

	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,4.,2.,3.,6./
	DATA YU2/5.0,8.,7.,6.,5.,9./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	Centered Bar
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETR ('GRAPH_BAR_WIDTH',3.5) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','my ytxt')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','centered BAR plotting ')
	CALL PTEXT
	RETURN      
	END
	SUBROUTINE GRAF02_TWO
	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,3.,6.,5.,2./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	Centered Bar
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_BAR_JUSTIFICATION','left')
	CALL PSETR ('GRAPH_BAR_WIDTH',1.) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','GREEN')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','my text')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','left BAR plotting ')

	CALL PTEXT
	RETURN
C
	END
	SUBROUTINE GRAF02_THREE
	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,3.,6.,5.,2./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	Centered Bar
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_BAR_JUSTIFICATION','right')
	CALL PSETR ('GRAPH_BAR_WIDTH',0.8) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','grey')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','my text')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','right BAR plotting ')
	call ptext
C
	RETURN
C
	END
	SUBROUTINE GRAF02_FOUR
	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,0.,2.,9./
	DATA YU2/5.0,2.,3.,6.,5.,2./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	Centered Bar
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_BAR_style','linebar')
	CALL PSETR ('GRAPH_BAR_WIDTH',0.8) 
	CALL PSETC ('GRAPH_BAR_LINE_COLOUR',"red") 
	CALL PSETC ('GRAPH_BAR_LINE_STYLE',"dash") 
	CALL PSETI ('GRAPH_BAR_LINE_THICKNESS',4) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','pink')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YU1, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU2,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','my text')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','line BAR plotting ')
	call ptext
	return
	end
	SUBROUTINE GRAF02_FIVE
	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,3.,6.,5.,2./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	Centered Bar
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_BAR_style','linebar')
	CALL PSETR ('GRAPH_BAR_WIDTH',0.8) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','pink')
	CALL PSETC ('GRAPH_BAR_LINE_COLOUR',"black") 
	CALL PSETC ('GRAPH_BAR_LINE_STYLE',"solid") 
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YU1, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU2,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','my text')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Error method  ')
	call ptext
	return
	end


C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END

