//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation. All rights reserved.
//
// This file is automatically generated. Please do not edit it directly.
// To modify this file, edit the schema: dml/Tools/DirectMLSchema.json
// And run this script to regenerate: dml/Tools/GenerateSchema.ps1
//
// #dml-new-operator-location
//---------------------------------------------------------------------------

#pragma once

#include "precomp.h"

template <typename T>
T ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
#ifndef WAI_BUILD_LINUX
    // Clang will instantiate this template even if it isn't used,
    // so this static_assert will always fire and break the build.
    static_assert(false, "Not implemented for this type");
#endif
}


template <>
DML_TENSOR_DATA_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_TENSOR_DATA_TYPE_UNKNOWN", DML_TENSOR_DATA_TYPE_UNKNOWN},
        {"DML_TENSOR_DATA_TYPE_FLOAT32", DML_TENSOR_DATA_TYPE_FLOAT32},
        {"DML_TENSOR_DATA_TYPE_FLOAT16", DML_TENSOR_DATA_TYPE_FLOAT16},
        {"DML_TENSOR_DATA_TYPE_UINT32", DML_TENSOR_DATA_TYPE_UINT32},
        {"DML_TENSOR_DATA_TYPE_UINT16", DML_TENSOR_DATA_TYPE_UINT16},
        {"DML_TENSOR_DATA_TYPE_UINT8", DML_TENSOR_DATA_TYPE_UINT8},
        {"DML_TENSOR_DATA_TYPE_INT32", DML_TENSOR_DATA_TYPE_INT32},
        {"DML_TENSOR_DATA_TYPE_INT16", DML_TENSOR_DATA_TYPE_INT16},
        {"DML_TENSOR_DATA_TYPE_INT8", DML_TENSOR_DATA_TYPE_INT8},
        {"DML_TENSOR_DATA_TYPE_FLOAT64", DML_TENSOR_DATA_TYPE_FLOAT64},
        {"DML_TENSOR_DATA_TYPE_UINT64", DML_TENSOR_DATA_TYPE_UINT64},
        {"DML_TENSOR_DATA_TYPE_INT64", DML_TENSOR_DATA_TYPE_INT64},
        {"DML_TENSOR_DATA_TYPE_UINT4", DML_TENSOR_DATA_TYPE_UINT4},
        {"DML_TENSOR_DATA_TYPE_INT4", DML_TENSOR_DATA_TYPE_INT4},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_TENSOR_DATA_TYPE>(0);
    }
    return static_cast<DML_TENSOR_DATA_TYPE>(*index);
}


template <>
DML_TENSOR_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_TENSOR_TYPE_INVALID", DML_TENSOR_TYPE_INVALID},
        {"DML_TENSOR_TYPE_BUFFER", DML_TENSOR_TYPE_BUFFER},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_TENSOR_TYPE>(0);
    }
    return static_cast<DML_TENSOR_TYPE>(*index);
}


template <>
DML_OPERATOR_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_OPERATOR_INVALID", DML_OPERATOR_INVALID},
        {"DML_OPERATOR_ELEMENT_WISE_IDENTITY", DML_OPERATOR_ELEMENT_WISE_IDENTITY},
        {"DML_OPERATOR_ELEMENT_WISE_ABS", DML_OPERATOR_ELEMENT_WISE_ABS},
        {"DML_OPERATOR_ELEMENT_WISE_ACOS", DML_OPERATOR_ELEMENT_WISE_ACOS},
        {"DML_OPERATOR_ELEMENT_WISE_ADD", DML_OPERATOR_ELEMENT_WISE_ADD},
        {"DML_OPERATOR_ELEMENT_WISE_ASIN", DML_OPERATOR_ELEMENT_WISE_ASIN},
        {"DML_OPERATOR_ELEMENT_WISE_ATAN", DML_OPERATOR_ELEMENT_WISE_ATAN},
        {"DML_OPERATOR_ELEMENT_WISE_CEIL", DML_OPERATOR_ELEMENT_WISE_CEIL},
        {"DML_OPERATOR_ELEMENT_WISE_CLIP", DML_OPERATOR_ELEMENT_WISE_CLIP},
        {"DML_OPERATOR_ELEMENT_WISE_COS", DML_OPERATOR_ELEMENT_WISE_COS},
        {"DML_OPERATOR_ELEMENT_WISE_DIVIDE", DML_OPERATOR_ELEMENT_WISE_DIVIDE},
        {"DML_OPERATOR_ELEMENT_WISE_EXP", DML_OPERATOR_ELEMENT_WISE_EXP},
        {"DML_OPERATOR_ELEMENT_WISE_FLOOR", DML_OPERATOR_ELEMENT_WISE_FLOOR},
        {"DML_OPERATOR_ELEMENT_WISE_LOG", DML_OPERATOR_ELEMENT_WISE_LOG},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND", DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS", DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN", DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN", DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL", DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL", DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT", DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR", DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR},
        {"DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR", DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR},
        {"DML_OPERATOR_ELEMENT_WISE_MAX", DML_OPERATOR_ELEMENT_WISE_MAX},
        {"DML_OPERATOR_ELEMENT_WISE_MEAN", DML_OPERATOR_ELEMENT_WISE_MEAN},
        {"DML_OPERATOR_ELEMENT_WISE_MIN", DML_OPERATOR_ELEMENT_WISE_MIN},
        {"DML_OPERATOR_ELEMENT_WISE_MULTIPLY", DML_OPERATOR_ELEMENT_WISE_MULTIPLY},
        {"DML_OPERATOR_ELEMENT_WISE_POW", DML_OPERATOR_ELEMENT_WISE_POW},
        {"DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW", DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW},
        {"DML_OPERATOR_ELEMENT_WISE_RECIP", DML_OPERATOR_ELEMENT_WISE_RECIP},
        {"DML_OPERATOR_ELEMENT_WISE_SIN", DML_OPERATOR_ELEMENT_WISE_SIN},
        {"DML_OPERATOR_ELEMENT_WISE_SQRT", DML_OPERATOR_ELEMENT_WISE_SQRT},
        {"DML_OPERATOR_ELEMENT_WISE_SUBTRACT", DML_OPERATOR_ELEMENT_WISE_SUBTRACT},
        {"DML_OPERATOR_ELEMENT_WISE_TAN", DML_OPERATOR_ELEMENT_WISE_TAN},
        {"DML_OPERATOR_ELEMENT_WISE_THRESHOLD", DML_OPERATOR_ELEMENT_WISE_THRESHOLD},
        {"DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR", DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR},
        {"DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR", DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR},
        {"DML_OPERATOR_ACTIVATION_ELU", DML_OPERATOR_ACTIVATION_ELU},
        {"DML_OPERATOR_ACTIVATION_CELU", DML_OPERATOR_ACTIVATION_CELU},
        {"DML_OPERATOR_ACTIVATION_HARDMAX", DML_OPERATOR_ACTIVATION_HARDMAX},
        {"DML_OPERATOR_ACTIVATION_HARDMAX1", DML_OPERATOR_ACTIVATION_HARDMAX1},
        {"DML_OPERATOR_ACTIVATION_HARD_SIGMOID", DML_OPERATOR_ACTIVATION_HARD_SIGMOID},
        {"DML_OPERATOR_ACTIVATION_IDENTITY", DML_OPERATOR_ACTIVATION_IDENTITY},
        {"DML_OPERATOR_ACTIVATION_LEAKY_RELU", DML_OPERATOR_ACTIVATION_LEAKY_RELU},
        {"DML_OPERATOR_ACTIVATION_LINEAR", DML_OPERATOR_ACTIVATION_LINEAR},
        {"DML_OPERATOR_ACTIVATION_LOG_SOFTMAX", DML_OPERATOR_ACTIVATION_LOG_SOFTMAX},
        {"DML_OPERATOR_ACTIVATION_LOG_SOFTMAX1", DML_OPERATOR_ACTIVATION_LOG_SOFTMAX1},
        {"DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU", DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU},
        {"DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS", DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS},
        {"DML_OPERATOR_ACTIVATION_RELU", DML_OPERATOR_ACTIVATION_RELU},
        {"DML_OPERATOR_ACTIVATION_SCALED_ELU", DML_OPERATOR_ACTIVATION_SCALED_ELU},
        {"DML_OPERATOR_ACTIVATION_SCALED_TANH", DML_OPERATOR_ACTIVATION_SCALED_TANH},
        {"DML_OPERATOR_ACTIVATION_SIGMOID", DML_OPERATOR_ACTIVATION_SIGMOID},
        {"DML_OPERATOR_ACTIVATION_SOFTMAX", DML_OPERATOR_ACTIVATION_SOFTMAX},
        {"DML_OPERATOR_ACTIVATION_SOFTMAX1", DML_OPERATOR_ACTIVATION_SOFTMAX1},
        {"DML_OPERATOR_ACTIVATION_SOFTPLUS", DML_OPERATOR_ACTIVATION_SOFTPLUS},
        {"DML_OPERATOR_ACTIVATION_SOFTSIGN", DML_OPERATOR_ACTIVATION_SOFTSIGN},
        {"DML_OPERATOR_ACTIVATION_TANH", DML_OPERATOR_ACTIVATION_TANH},
        {"DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU", DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU},
        {"DML_OPERATOR_CONVOLUTION", DML_OPERATOR_CONVOLUTION},
        {"DML_OPERATOR_GEMM", DML_OPERATOR_GEMM},
        {"DML_OPERATOR_REDUCE", DML_OPERATOR_REDUCE},
        {"DML_OPERATOR_AVERAGE_POOLING", DML_OPERATOR_AVERAGE_POOLING},
        {"DML_OPERATOR_AVERAGE_POOLING1", DML_OPERATOR_AVERAGE_POOLING1},
        {"DML_OPERATOR_LP_POOLING", DML_OPERATOR_LP_POOLING},
        {"DML_OPERATOR_LP_POOLING1", DML_OPERATOR_LP_POOLING1},
        {"DML_OPERATOR_MAX_POOLING", DML_OPERATOR_MAX_POOLING},
        {"DML_OPERATOR_ROI_POOLING", DML_OPERATOR_ROI_POOLING},
        {"DML_OPERATOR_SLICE", DML_OPERATOR_SLICE},
        {"DML_OPERATOR_CAST", DML_OPERATOR_CAST},
        {"DML_OPERATOR_SPLIT", DML_OPERATOR_SPLIT},
        {"DML_OPERATOR_JOIN", DML_OPERATOR_JOIN},
        {"DML_OPERATOR_PADDING", DML_OPERATOR_PADDING},
        {"DML_OPERATOR_PADDING1", DML_OPERATOR_PADDING1},
        {"DML_OPERATOR_VALUE_SCALE_2D", DML_OPERATOR_VALUE_SCALE_2D},
        {"DML_OPERATOR_UPSAMPLE_2D", DML_OPERATOR_UPSAMPLE_2D},
        {"DML_OPERATOR_GATHER", DML_OPERATOR_GATHER},
        {"DML_OPERATOR_SPACE_TO_DEPTH", DML_OPERATOR_SPACE_TO_DEPTH},
        {"DML_OPERATOR_DEPTH_TO_SPACE", DML_OPERATOR_DEPTH_TO_SPACE},
        {"DML_OPERATOR_TILE", DML_OPERATOR_TILE},
        {"DML_OPERATOR_TOP_K", DML_OPERATOR_TOP_K},
        {"DML_OPERATOR_BATCH_NORMALIZATION", DML_OPERATOR_BATCH_NORMALIZATION},
        {"DML_OPERATOR_BATCH_NORMALIZATION_TRAINING", DML_OPERATOR_BATCH_NORMALIZATION_TRAINING},
        {"DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION", DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION},
        {"DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION", DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION},
        {"DML_OPERATOR_LP_NORMALIZATION", DML_OPERATOR_LP_NORMALIZATION},
        {"DML_OPERATOR_RNN", DML_OPERATOR_RNN},
        {"DML_OPERATOR_LSTM", DML_OPERATOR_LSTM},
        {"DML_OPERATOR_GRU", DML_OPERATOR_GRU},
        {"DML_OPERATOR_ELEMENT_WISE_SIGN", DML_OPERATOR_ELEMENT_WISE_SIGN},
        {"DML_OPERATOR_ELEMENT_WISE_IS_NAN", DML_OPERATOR_ELEMENT_WISE_IS_NAN},
        {"DML_OPERATOR_ELEMENT_WISE_ERF", DML_OPERATOR_ELEMENT_WISE_ERF},
        {"DML_OPERATOR_ELEMENT_WISE_SINH", DML_OPERATOR_ELEMENT_WISE_SINH},
        {"DML_OPERATOR_ELEMENT_WISE_COSH", DML_OPERATOR_ELEMENT_WISE_COSH},
        {"DML_OPERATOR_ELEMENT_WISE_TANH", DML_OPERATOR_ELEMENT_WISE_TANH},
        {"DML_OPERATOR_ELEMENT_WISE_ASINH", DML_OPERATOR_ELEMENT_WISE_ASINH},
        {"DML_OPERATOR_ELEMENT_WISE_ACOSH", DML_OPERATOR_ELEMENT_WISE_ACOSH},
        {"DML_OPERATOR_ELEMENT_WISE_ATANH", DML_OPERATOR_ELEMENT_WISE_ATANH},
        {"DML_OPERATOR_ELEMENT_WISE_IF", DML_OPERATOR_ELEMENT_WISE_IF},
        {"DML_OPERATOR_ELEMENT_WISE_ADD1", DML_OPERATOR_ELEMENT_WISE_ADD1},
        {"DML_OPERATOR_ACTIVATION_SHRINK", DML_OPERATOR_ACTIVATION_SHRINK},
        {"DML_OPERATOR_MAX_POOLING1", DML_OPERATOR_MAX_POOLING1},
        {"DML_OPERATOR_MAX_UNPOOLING", DML_OPERATOR_MAX_UNPOOLING},
        {"DML_OPERATOR_DIAGONAL_MATRIX", DML_OPERATOR_DIAGONAL_MATRIX},
        {"DML_OPERATOR_SCATTER", DML_OPERATOR_SCATTER},
        {"DML_OPERATOR_ONE_HOT", DML_OPERATOR_ONE_HOT},
        {"DML_OPERATOR_RESAMPLE", DML_OPERATOR_RESAMPLE},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_LEFT", DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_LEFT},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_RIGHT", DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_RIGHT},
        {"DML_OPERATOR_ELEMENT_WISE_ROUND", DML_OPERATOR_ELEMENT_WISE_ROUND},
        {"DML_OPERATOR_ELEMENT_WISE_IS_INFINITY", DML_OPERATOR_ELEMENT_WISE_IS_INFINITY},
        {"DML_OPERATOR_ELEMENT_WISE_MODULUS_TRUNCATE", DML_OPERATOR_ELEMENT_WISE_MODULUS_TRUNCATE},
        {"DML_OPERATOR_ELEMENT_WISE_MODULUS_FLOOR", DML_OPERATOR_ELEMENT_WISE_MODULUS_FLOOR},
        {"DML_OPERATOR_FILL_VALUE_SEQUENCE", DML_OPERATOR_FILL_VALUE_SEQUENCE},
        {"DML_OPERATOR_FILL_VALUE_CONSTANT", DML_OPERATOR_FILL_VALUE_CONSTANT},
        {"DML_OPERATOR_CUMULATIVE_SUMMATION", DML_OPERATOR_CUMULATIVE_SUMMATION},
        {"DML_OPERATOR_REVERSE_SUBSEQUENCES", DML_OPERATOR_REVERSE_SUBSEQUENCES},
        {"DML_OPERATOR_GATHER_ELEMENTS", DML_OPERATOR_GATHER_ELEMENTS},
        {"DML_OPERATOR_GATHER_ND", DML_OPERATOR_GATHER_ND},
        {"DML_OPERATOR_SCATTER_ND", DML_OPERATOR_SCATTER_ND},
        {"DML_OPERATOR_MAX_POOLING2", DML_OPERATOR_MAX_POOLING2},
        {"DML_OPERATOR_SLICE1", DML_OPERATOR_SLICE1},
        {"DML_OPERATOR_TOP_K1", DML_OPERATOR_TOP_K1},
        {"DML_OPERATOR_DEPTH_TO_SPACE1", DML_OPERATOR_DEPTH_TO_SPACE1},
        {"DML_OPERATOR_SPACE_TO_DEPTH1", DML_OPERATOR_SPACE_TO_DEPTH1},
        {"DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION1", DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION1},
        {"DML_OPERATOR_RESAMPLE1", DML_OPERATOR_RESAMPLE1},
        {"DML_OPERATOR_MATRIX_MULTIPLY_INTEGER", DML_OPERATOR_MATRIX_MULTIPLY_INTEGER},
        {"DML_OPERATOR_QUANTIZED_LINEAR_MATRIX_MULTIPLY", DML_OPERATOR_QUANTIZED_LINEAR_MATRIX_MULTIPLY},
        {"DML_OPERATOR_CONVOLUTION_INTEGER", DML_OPERATOR_CONVOLUTION_INTEGER},
        {"DML_OPERATOR_QUANTIZED_LINEAR_CONVOLUTION", DML_OPERATOR_QUANTIZED_LINEAR_CONVOLUTION},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_AND", DML_OPERATOR_ELEMENT_WISE_BIT_AND},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_OR", DML_OPERATOR_ELEMENT_WISE_BIT_OR},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_XOR", DML_OPERATOR_ELEMENT_WISE_BIT_XOR},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_NOT", DML_OPERATOR_ELEMENT_WISE_BIT_NOT},
        {"DML_OPERATOR_ELEMENT_WISE_BIT_COUNT", DML_OPERATOR_ELEMENT_WISE_BIT_COUNT},
        {"DML_OPERATOR_ACTIVATION_RELU_GRAD", DML_OPERATOR_ACTIVATION_RELU_GRAD},
        {"DML_OPERATOR_AVERAGE_POOLING_GRAD", DML_OPERATOR_AVERAGE_POOLING_GRAD},
        {"DML_OPERATOR_MAX_POOLING_GRAD", DML_OPERATOR_MAX_POOLING_GRAD},
        {"DML_OPERATOR_RANDOM_GENERATOR", DML_OPERATOR_RANDOM_GENERATOR},
        {"DML_OPERATOR_NONZERO_COORDINATES", DML_OPERATOR_NONZERO_COORDINATES},
        {"DML_OPERATOR_RESAMPLE_GRAD", DML_OPERATOR_RESAMPLE_GRAD},
        {"DML_OPERATOR_SLICE_GRAD", DML_OPERATOR_SLICE_GRAD},
        {"DML_OPERATOR_ADAM_OPTIMIZER", DML_OPERATOR_ADAM_OPTIMIZER},
        {"DML_OPERATOR_ARGMIN", DML_OPERATOR_ARGMIN},
        {"DML_OPERATOR_ARGMAX", DML_OPERATOR_ARGMAX},
        {"DML_OPERATOR_ROI_ALIGN", DML_OPERATOR_ROI_ALIGN},
        {"DML_OPERATOR_GATHER_ND1", DML_OPERATOR_GATHER_ND1},
        {"DML_OPERATOR_ELEMENT_WISE_ATAN_YX", DML_OPERATOR_ELEMENT_WISE_ATAN_YX},
        {"DML_OPERATOR_ELEMENT_WISE_CLIP_GRAD", DML_OPERATOR_ELEMENT_WISE_CLIP_GRAD},
        {"DML_OPERATOR_ELEMENT_WISE_DIFFERENCE_SQUARE", DML_OPERATOR_ELEMENT_WISE_DIFFERENCE_SQUARE},
        {"DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION_GRAD", DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION_GRAD},
        {"DML_OPERATOR_CUMULATIVE_PRODUCT", DML_OPERATOR_CUMULATIVE_PRODUCT},
        {"DML_OPERATOR_BATCH_NORMALIZATION_GRAD", DML_OPERATOR_BATCH_NORMALIZATION_GRAD},
        {"DML_OPERATOR_BATCH_NORMALIZATION_TRAINING_GRAD", DML_OPERATOR_BATCH_NORMALIZATION_TRAINING_GRAD},
        {"DML_OPERATOR_ELEMENT_WISE_QUANTIZED_LINEAR_ADD", DML_OPERATOR_ELEMENT_WISE_QUANTIZED_LINEAR_ADD},
        {"DML_OPERATOR_DYNAMIC_QUANTIZE_LINEAR", DML_OPERATOR_DYNAMIC_QUANTIZE_LINEAR},
        {"DML_OPERATOR_ROI_ALIGN1", DML_OPERATOR_ROI_ALIGN1},
        {"DML_OPERATOR_ELEMENT_WISE_CLIP1", DML_OPERATOR_ELEMENT_WISE_CLIP1},
        {"DML_OPERATOR_ELEMENT_WISE_CLIP_GRAD1", DML_OPERATOR_ELEMENT_WISE_CLIP_GRAD1},
        {"DML_OPERATOR_ELEMENT_WISE_NEGATE", DML_OPERATOR_ELEMENT_WISE_NEGATE},
        {"DML_OPERATOR_ACTIVATION_GELU", DML_OPERATOR_ACTIVATION_GELU},
        {"DML_OPERATOR_ACTIVATION_SWISH", DML_OPERATOR_ACTIVATION_SWISH},
        {"DML_OPERATOR_ACTIVATION_HARD_SWISH", DML_OPERATOR_ACTIVATION_HARD_SWISH},
        {"DML_OPERATOR_RESAMPLE2", DML_OPERATOR_RESAMPLE2},
        {"DML_OPERATOR_RESAMPLE3", DML_OPERATOR_RESAMPLE3},
        {"DML_OPERATOR_RESAMPLE_GRAD1", DML_OPERATOR_RESAMPLE_GRAD1},
        {"DML_OPERATOR_DIAGONAL_MATRIX1", DML_OPERATOR_DIAGONAL_MATRIX1},
        {"DML_OPERATOR_MULTIHEAD_ATTENTION", DML_OPERATOR_MULTIHEAD_ATTENTION},
        {"DML_OPERATOR_QUANTIZED_LINEAR_AVERAGE_POOLING", DML_OPERATOR_QUANTIZED_LINEAR_AVERAGE_POOLING},
        {"DML_OPERATOR_MATRIX_MULTIPLY_INTEGER_TO_FLOAT", DML_OPERATOR_MATRIX_MULTIPLY_INTEGER_TO_FLOAT},
        {"DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION2", DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION2},
        {"DML_OPERATOR_MULTIHEAD_ATTENTION1", DML_OPERATOR_MULTIHEAD_ATTENTION1},
        {"DML_OPERATOR_QUANTIZE", DML_OPERATOR_QUANTIZE},
        {"DML_OPERATOR_DEQUANTIZE", DML_OPERATOR_DEQUANTIZE},
        {"DML_OPERATOR_ROI_ALIGN_GRAD", DML_OPERATOR_ROI_ALIGN_GRAD},
        {"DML_OPERATOR_FOLD", DML_OPERATOR_FOLD},
        {"DML_OPERATOR_UNFOLD", DML_OPERATOR_UNFOLD},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_OPERATOR_TYPE>(0);
    }
    return static_cast<DML_OPERATOR_TYPE>(*index);
}


template <>
DML_BINDING_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_BINDING_TYPE_NONE", DML_BINDING_TYPE_NONE},
        {"DML_BINDING_TYPE_BUFFER", DML_BINDING_TYPE_BUFFER},
        {"DML_BINDING_TYPE_BUFFER_ARRAY", DML_BINDING_TYPE_BUFFER_ARRAY},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_BINDING_TYPE>(0);
    }
    return static_cast<DML_BINDING_TYPE>(*index);
}


template <>
DML_REDUCE_FUNCTION ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_REDUCE_FUNCTION_ARGMAX", DML_REDUCE_FUNCTION_ARGMAX},
        {"DML_REDUCE_FUNCTION_ARGMIN", DML_REDUCE_FUNCTION_ARGMIN},
        {"DML_REDUCE_FUNCTION_AVERAGE", DML_REDUCE_FUNCTION_AVERAGE},
        {"DML_REDUCE_FUNCTION_L1", DML_REDUCE_FUNCTION_L1},
        {"DML_REDUCE_FUNCTION_L2", DML_REDUCE_FUNCTION_L2},
        {"DML_REDUCE_FUNCTION_LOG_SUM", DML_REDUCE_FUNCTION_LOG_SUM},
        {"DML_REDUCE_FUNCTION_LOG_SUM_EXP", DML_REDUCE_FUNCTION_LOG_SUM_EXP},
        {"DML_REDUCE_FUNCTION_MAX", DML_REDUCE_FUNCTION_MAX},
        {"DML_REDUCE_FUNCTION_MIN", DML_REDUCE_FUNCTION_MIN},
        {"DML_REDUCE_FUNCTION_MULTIPLY", DML_REDUCE_FUNCTION_MULTIPLY},
        {"DML_REDUCE_FUNCTION_SUM", DML_REDUCE_FUNCTION_SUM},
        {"DML_REDUCE_FUNCTION_SUM_SQUARE", DML_REDUCE_FUNCTION_SUM_SQUARE},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_REDUCE_FUNCTION>(0);
    }
    return static_cast<DML_REDUCE_FUNCTION>(*index);
}

template <>
DML_MATRIX_TRANSFORM ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_MATRIX_TRANSFORM_NONE", DML_MATRIX_TRANSFORM_NONE},
        {"DML_MATRIX_TRANSFORM_TRANSPOSE", DML_MATRIX_TRANSFORM_TRANSPOSE},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_MATRIX_TRANSFORM>(0);
    }
    return static_cast<DML_MATRIX_TRANSFORM>(*index);
}


template <>
DML_CONVOLUTION_MODE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_CONVOLUTION_MODE_CONVOLUTION", DML_CONVOLUTION_MODE_CONVOLUTION},
        {"DML_CONVOLUTION_MODE_CROSS_CORRELATION", DML_CONVOLUTION_MODE_CROSS_CORRELATION},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_CONVOLUTION_MODE>(0);
    }
    return static_cast<DML_CONVOLUTION_MODE>(*index);
}


template <>
DML_CONVOLUTION_DIRECTION ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_CONVOLUTION_DIRECTION_FORWARD", DML_CONVOLUTION_DIRECTION_FORWARD},
        {"DML_CONVOLUTION_DIRECTION_BACKWARD", DML_CONVOLUTION_DIRECTION_BACKWARD},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_CONVOLUTION_DIRECTION>(0);
    }
    return static_cast<DML_CONVOLUTION_DIRECTION>(*index);
}

template <>
DML_PADDING_MODE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_PADDING_MODE_CONSTANT", DML_PADDING_MODE_CONSTANT},
        {"DML_PADDING_MODE_EDGE", DML_PADDING_MODE_EDGE},
        {"DML_PADDING_MODE_REFLECTION", DML_PADDING_MODE_REFLECTION},
        {"DML_PADDING_MODE_SYMMETRIC", DML_PADDING_MODE_SYMMETRIC},
        {"DML_PADDING_MODE_WRAP", DML_PADDING_MODE_WRAP},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_PADDING_MODE>(0);
    }
    return static_cast<DML_PADDING_MODE>(*index);
}


template <>
DML_INTERPOLATION_MODE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_INTERPOLATION_MODE_NEAREST_NEIGHBOR", DML_INTERPOLATION_MODE_NEAREST_NEIGHBOR},
        {"DML_INTERPOLATION_MODE_LINEAR", DML_INTERPOLATION_MODE_LINEAR},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_INTERPOLATION_MODE>(0);
    }
    return static_cast<DML_INTERPOLATION_MODE>(*index);
}


template <>
DML_RECURRENT_NETWORK_DIRECTION ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_RECURRENT_NETWORK_DIRECTION_FORWARD", DML_RECURRENT_NETWORK_DIRECTION_FORWARD},
        {"DML_RECURRENT_NETWORK_DIRECTION_BACKWARD", DML_RECURRENT_NETWORK_DIRECTION_BACKWARD},
        {"DML_RECURRENT_NETWORK_DIRECTION_BIDIRECTIONAL", DML_RECURRENT_NETWORK_DIRECTION_BIDIRECTIONAL},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_RECURRENT_NETWORK_DIRECTION>(0);
    }
    return static_cast<DML_RECURRENT_NETWORK_DIRECTION>(*index);
}


template <>
DML_FEATURE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_FEATURE_TENSOR_DATA_TYPE_SUPPORT", DML_FEATURE_TENSOR_DATA_TYPE_SUPPORT},
        {"DML_FEATURE_FEATURE_LEVELS", DML_FEATURE_FEATURE_LEVELS},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_FEATURE>(0);
    }
    return static_cast<DML_FEATURE>(*index);
}


template <>
DML_FEATURE_LEVEL ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_FEATURE_LEVEL_1_0", DML_FEATURE_LEVEL_1_0},
        {"DML_FEATURE_LEVEL_2_0", DML_FEATURE_LEVEL_2_0},
        {"DML_FEATURE_LEVEL_2_1", DML_FEATURE_LEVEL_2_1},
        {"DML_FEATURE_LEVEL_3_0", DML_FEATURE_LEVEL_3_0},
        {"DML_FEATURE_LEVEL_3_1", DML_FEATURE_LEVEL_3_1},
        {"DML_FEATURE_LEVEL_4_0", DML_FEATURE_LEVEL_4_0},
        {"DML_FEATURE_LEVEL_4_1", DML_FEATURE_LEVEL_4_1},
        {"DML_FEATURE_LEVEL_5_0", DML_FEATURE_LEVEL_5_0},
        {"DML_FEATURE_LEVEL_5_1", DML_FEATURE_LEVEL_5_1},
        {"DML_FEATURE_LEVEL_5_2", DML_FEATURE_LEVEL_5_2},
        {"DML_FEATURE_LEVEL_6_0", DML_FEATURE_LEVEL_6_0},
        {"DML_FEATURE_LEVEL_6_1", DML_FEATURE_LEVEL_6_1},
        {"DML_FEATURE_LEVEL_6_2", DML_FEATURE_LEVEL_6_2},
        {"DML_FEATURE_LEVEL_6_3", DML_FEATURE_LEVEL_6_3},
        {"DML_FEATURE_LEVEL_6_4", DML_FEATURE_LEVEL_6_4},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_FEATURE_LEVEL>(0);
    }
    return static_cast<DML_FEATURE_LEVEL>(*index);
}


template <>
DML_IS_INFINITY_MODE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_IS_INFINITY_MODE_EITHER", DML_IS_INFINITY_MODE_EITHER},
        {"DML_IS_INFINITY_MODE_POSITIVE", DML_IS_INFINITY_MODE_POSITIVE},
        {"DML_IS_INFINITY_MODE_NEGATIVE", DML_IS_INFINITY_MODE_NEGATIVE},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_IS_INFINITY_MODE>(0);
    }
    return static_cast<DML_IS_INFINITY_MODE>(*index);
}


template <>
DML_DEPTH_SPACE_ORDER ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_DEPTH_SPACE_ORDER_DEPTH_COLUMN_ROW", DML_DEPTH_SPACE_ORDER_DEPTH_COLUMN_ROW},
        {"DML_DEPTH_SPACE_ORDER_COLUMN_ROW_DEPTH", DML_DEPTH_SPACE_ORDER_COLUMN_ROW_DEPTH},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_DEPTH_SPACE_ORDER>(0);
    }
    return static_cast<DML_DEPTH_SPACE_ORDER>(*index);
}


template <>
DML_AXIS_DIRECTION ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_AXIS_DIRECTION_INCREASING", DML_AXIS_DIRECTION_INCREASING},
        {"DML_AXIS_DIRECTION_DECREASING", DML_AXIS_DIRECTION_DECREASING},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_AXIS_DIRECTION>(0);
    }
    return static_cast<DML_AXIS_DIRECTION>(*index);
}


template <>
DML_ROUNDING_MODE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_ROUNDING_MODE_HALVES_TO_NEAREST_EVEN", DML_ROUNDING_MODE_HALVES_TO_NEAREST_EVEN},
        {"DML_ROUNDING_MODE_TOWARD_ZERO", DML_ROUNDING_MODE_TOWARD_ZERO},
        {"DML_ROUNDING_MODE_TOWARD_INFINITY", DML_ROUNDING_MODE_TOWARD_INFINITY},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_ROUNDING_MODE>(0);
    }
    return static_cast<DML_ROUNDING_MODE>(*index);
}


template <>
DML_RANDOM_GENERATOR_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_RANDOM_GENERATOR_TYPE_PHILOX_4X32_10", DML_RANDOM_GENERATOR_TYPE_PHILOX_4X32_10},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_RANDOM_GENERATOR_TYPE>(0);
    }
    return static_cast<DML_RANDOM_GENERATOR_TYPE>(*index);
}


template <>
DML_MULTIHEAD_ATTENTION_MASK_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_MULTIHEAD_ATTENTION_MASK_TYPE_NONE", DML_MULTIHEAD_ATTENTION_MASK_TYPE_NONE},
        {"DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_SEQUENCE_LENGTH", DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_SEQUENCE_LENGTH},
        {"DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_SEQUENCE_END_START", DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_SEQUENCE_END_START},
        {"DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_QUERY_SEQUENCE_LENGTH_START_END", DML_MULTIHEAD_ATTENTION_MASK_TYPE_KEY_QUERY_SEQUENCE_LENGTH_START_END},
        {"DML_MULTIHEAD_ATTENTION_MASK_TYPE_BOOLEAN", DML_MULTIHEAD_ATTENTION_MASK_TYPE_BOOLEAN},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_MULTIHEAD_ATTENTION_MASK_TYPE>(0);
    }
    return static_cast<DML_MULTIHEAD_ATTENTION_MASK_TYPE>(*index);
}


template <>
DML_QUANTIZATION_TYPE ApiTraits::StringifyHelpers::FromString(std::string_view value)
{
    constexpr StringUtil::NameAndIndex mapping[] =
    {
        {"DML_QUANTIZATION_TYPE_NONE", DML_QUANTIZATION_TYPE_NONE},
        {"DML_QUANTIZATION_TYPE_SCALE", DML_QUANTIZATION_TYPE_SCALE},
        {"DML_QUANTIZATION_TYPE_SCALE_ZERO_POINT", DML_QUANTIZATION_TYPE_SCALE_ZERO_POINT},
    };
    auto index = StringUtil::MapToIndex(value, mapping);
    if (!index)
    {
        assert(false);
        return static_cast<DML_QUANTIZATION_TYPE>(0);
    }
    return static_cast<DML_QUANTIZATION_TYPE>(*index);
}
