#!/bin/bash

################################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_PCIDevice.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_PCIDevice provider module";
Name = "PCI_OpenDRIM_PCIDeviceModule";
Location = "cmpiPCI_OpenDRIM_PCIDeviceProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_PCIDevice provider";
Name = "PCI_OpenDRIM_PCIDeviceProvider";
ProviderModuleName = "PCI_OpenDRIM_PCIDeviceModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_PCIDevice provider capabilities";
ProviderModuleName = "PCI_OpenDRIM_PCIDeviceModule";
ProviderName = "PCI_OpenDRIM_PCIDeviceProvider";
ClassName = "OpenDRIM_PCIDevice";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"InstanceID", "Caption", "Description", "ElementName", "InstallDate", "Name", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "CommunicationStatus", "DetailedStatus", "OperatingStatus", "PrimaryStatus", "EnabledState", "OtherEnabledState", "RequestedState", "EnabledDefault", "TimeOfLastStateChange", "AvailableRequestedStates", "TransitioningToState", "SystemCreationClassName", "SystemName", "CreationClassName", "DeviceID", "PowerManagementSupported", "PowerManagementCapabilities", "Availability", "StatusInfo", "LastErrorCode", "ErrorDescription", "ErrorCleared", "OtherIdentifyingInfo", "PowerOnHours", "TotalPowerOnHours", "IdentifyingDescriptions", "AdditionalAvailability", "MaxQuiesceTime", "TimeOfLastReset", "ProtocolSupported", "MaxNumberControlled", "ProtocolDescription", "CommandRegister", "Capabilities", "CapabilityDescriptions", "DeviceSelectTiming", "ClassCode", "CacheLineSize", "LatencyTimer", "InterruptPin", "ExpansionROMBaseAddress", "SelfTestEnabled", "BaseAddress", "SubsystemID", "SubsystemVendorID", "MinGrantTime", "MaxLatency", "BusNumber", "DeviceNumber", "FunctionNumber", "PCIDeviceID", "VendorID", "RevisionID"};
SupportedMethods = {"RequestStateChange", "SetPowerState", "Reset", "EnableDevice", "OnlineDevice", "QuiesceDevice", "SaveProperties", "RestoreProperties", "BISTExecution"};
CapabilityID = "PCI_OpenDRIM_PCIDevice";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_PCIDevice.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_PCIDevice]   
   provider: PCI_OpenDRIM_PCIDeviceProvider
   location: cmpiPCI_OpenDRIM_PCIDeviceProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_PCIDevice.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_PCIDevice-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_PCIDevice.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
