###############################################################################
# OpenVAS Vulnerability Test
# $Id: GlassFish_detect.nasl 7190 2010-03-31 14:02:04Z chandra $
#
# GlassFish Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  GlassFish, an application server project led by Sun Microsystems for
  the Java EE platform is running at this host.

 See also:
  https://glassfish.dev.java.net/

 Risk factor : None";

if (description)
{
 script_id(100190);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("GlassFish Server Detection");  

 script_description(desc);
 script_summary("Checks for the presence of GlassFish Server");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 8080);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:8080);

if(!get_port_state(port))exit(0);

 url = string("/"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  

 if( buf == NULL )continue;
 if( egrep(pattern: 'Server:.*GlassFish.*', string: buf, icase: TRUE) )
 { 
   
    vers = string("unknown");

    ### try to get version.
    version = eregmatch(string: buf, pattern: 'Server:.*GlassFish[^0-9]+v([0-9.]+)',icase:TRUE);
    
    if ( !isnull(version[1]) ) {
       vers=version[1];
    } 

    if(egrep(pattern:"Location:.*login.jsf", string: buf)) {
      report = "\nThe GlassFish Administration Console is running at this Port.\n";
      set_kb_item(name: string("www/", port, "/GlassFishAdminConsole"), value: TRUE);
    }  else {
      set_kb_item(name: string("www/", port, "/GlassFish"), value: vers);	
    }  

    info = string("None\n\nGlassFish Version '");
    info += string(vers);
    info += string("' was detected on the remote host\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );    
       
       if(report_verbosity > 0) {
	 if(report) {
	  desc = report;
	 }  
         security_note(port:port,data:string(desc));
       }
       exit(0);
  
 }

exit(0);
