# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1042-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56663);
 script_cve_id("CVE-2006-1721");
 script_bugtraq_id(17446);
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1042-1 (cyrus-sasl2)";
 script_name(name);

 desc = "The remote host is missing an update to cyrus-sasl2
announced via advisory DSA 1042-1.

The Mu Security research team discovered a denial of service condition
in the Simple Authentication and Security Layer authentication library
(SASL) during DIGEST-MD5 negotiation.  This potentially affects
multiple products that use SASL DIGEST-MD5 authentication including
OpenLDAP, Sendmail, Postfix, etc.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 2.1.19-1.5sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.1.19.dfsg1-0.2.

We recommend that you upgrade your cyrus-sasl2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201042-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1042-1 (cyrus-sasl2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsasl2", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-dev", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-gssapi-heimdal", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-kerberos-heimdal", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-sql", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sasl2-bin", ver:"2.1.19-1.5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
