# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1420-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59955);
 script_cve_id("CVE-2007-6210");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1420-1 (zabbix)";
 script_name(name);

 desc = "The remote host is missing an update to zabbix
announced via advisory DSA 1420-1.

Bas van Schaik discovered that the agentd process of Zabbix, a network
monitor system, may run user-supplied commands as group id root, not
zabbix, which may lead to a privilege escalation.

For the stable distribution (etch), this problem has been fixed in version
1:1.1.4-10etch1

zabbix is not included in the oldstable distribution (sarge).

We recommend that you upgrade your zabbix packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201420-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1420-1 (zabbix)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zabbix-frontend-php", ver:"1.1.4-10etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zabbix-server-mysql", ver:"1.1.4-10etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zabbix-agent", ver:"1.1.4-10etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zabbix-server-pgsql", ver:"1.1.4-10etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
