###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_realtek_media_player_bof_vuln.nasl 731 2008-12-29 12:39:43Z dec $
#
# Realtek Media Player Playlist Buffer Overflow Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900067);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5664");
  script_bugtraq_id(32860);
  script_name("Realtek Media Player Playlist Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has Realtek Media Player installed and is prone to
  buffer overflow vulnerability.

  Vulnerability Insight:
  The issue is caused due to improper bounds checking when processing
  playlist files.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  code to cause buffer overflow and can lead to application crash.

  Impact Level: Application

  Affected Software/OS:
  Realtek Media Player A4.06 (5.36) and prior on Windows.

  Fix: No solution or patch is available as on 26th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.realtek.com.tw/downloads/

  References:
  http://www.milw0rm.com/exploits/7492
  http://xforce.iss.net/xforce/xfdb/47380

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Realtek Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Realtek Semiconductor Corp.")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("Realtek" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    rmpVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(!rmpVer){
      exit(0);
    }

    # Realtek Version <= 5.36 (A4.06)
    if(version_is_less_equal(version:rmpVer, test_version:"5.36")){
      security_hole(0);
    }
    exit(0);
  }
}
