###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_websvn_mult_vuln.nasl 881 2009-01-23 13:50:29Z jan $
#
# WebSVN Script Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900441);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5918", "CVE-2008-5919", "CVE-2008-5920", "CVE-2009-0240");
  script_bugtraq_id(31891);
  script_name("WebSVN Script Multiple Vulnerabilities");
  desc = "

  Overview: This host is running WebSVN and is prone to Multiple
  Vulnerabilities.

  Vulnerability:
  Multiple flaws are due to,
  - input passed in the URL to index.php is not properly sanitised before
    being returned to the user.
  - input passed to the rev parameter in rss.php is not properly sanitised
    before being used, when magic_quotes_gpc is disable.
  - restricted access to the repositories is not properly enforced.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the web application and execute cross site scripting attacks and
  can gain sensitive information or can cause directory traversal attacks.

  Impact Level: Application

  Affected Software/OS:
  WebSVN version prior to 2.1.0

  Fix:
  Upgrade to the latest version 2.1.0
  http://websvn.tigris.org/servlets/ProjectDocumentList

  References:
  http://secunia.com/advisories/32338
  http://www.milw0rm.com/exploits/6822
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=512191

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of WebSVN");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_websvn_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

websvnPort = get_kb_item("Services/www");
if(!websvnPort){
  exit(0);
}

if(get_port_state(websvnPort))
{
  svnVer = get_kb_item("www/" + websvnPort + "/WebSVN");
  if(svnVer != NULL)
  {
    # Grep for WebSVN version prior to 2.1.0
    if(version_is_less(version:svnVer, test_version:"2.1.0")){
      security_hole(websvnPort);
    }
  }
}
